/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 * 
 * $Id: XMLthreadEndLoader.java,v 1.6 2004/11/22 21:48:51 slavescu Exp $
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCThreadDeadEvent;
import org.eclipse.hyades.models.trace.TraceFactory;
import org.eclipse.hyades.models.trace.impl.TRCThreadImpl;
/**
 * @author slavescu
 *  
 */
public class XMLthreadEndLoader extends TraceXMLFragmentLoader {
	//~ Methods
	// ------------------------------------------------------------------------------------
	public void addYourselfInContext() {
		TRCProcess p = getProcess();
		TRCThread thread = (TRCThread) LookupServiceExtensions.getInstance().locate(context, TRCThreadImpl.class, LoadersUtils.getLookUpKey(threadIdRef));
		if (thread != null) {
			thread.setStopTime(createDeltaTime());
			TRCThreadDeadEvent event = TraceFactory.eINSTANCE.createTRCThreadDeadEvent();
			event.setTime(thread.getStopTime());
			thread.getThreadEvents().add(event);
		}
	}
	public void initialize(HierarchyContext context, String name) {
		super.initialize(context, name);
	}
}