/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCCallerCalleeInvocationInfo.java,v 1.6 2004/12/03 17:22:57 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.trace;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>TRC Caller Callee Invocation Info</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * Covers both the caller and callee sites of an invocation. Will be fully populated when the call/return and entry/exit are on the same thread, otherwise just the call/return will be populated, entry/exit will be represented by an extra TRCFullMethodInvocation
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCCallerCalleeInvocationInfo#getCallTime <em>Call Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCCallerCalleeInvocationInfo#getReturnTime <em>Return Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCCallerCalleeInvocationInfo#getCallOverhead <em>Call Overhead</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCCallerCalleeInvocationInfo()
 * @model 
 * @generated
 */
public interface TRCCallerCalleeInvocationInfo extends TRCFullMethodInvocation {
	/**
	 * Returns the value of the '<em><b>Call Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Method call time (the time when the caller made the call), relative to hierarchy.TRCAgent.startTime
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Call Time</em>' attribute.
	 * @see #setCallTime(double)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCCallerCalleeInvocationInfo_CallTime()
	 * @model 
	 * @generated
	 */
	double getCallTime();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCCallerCalleeInvocationInfo#getCallTime <em>Call Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Call Time</em>' attribute.
	 * @see #getCallTime()
	 * @generated
	 */
	void setCallTime(double value);

	/**
	 * Returns the value of the '<em><b>Return Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Method return time (the time when the caller received the return info), relative to hierarchy.TRCAgent.startTime
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Return Time</em>' attribute.
	 * @see #setReturnTime(double)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCCallerCalleeInvocationInfo_ReturnTime()
	 * @model 
	 * @generated
	 */
	double getReturnTime();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCCallerCalleeInvocationInfo#getReturnTime <em>Return Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Return Time</em>' attribute.
	 * @see #getReturnTime()
	 * @generated
	 */
	void setReturnTime(double value);

	/**
	 * Returns the value of the '<em><b>Call Overhead</b></em>' attribute.
	 * The default value is <code>"0.0"</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Overhead introduced by tracing the application. Tracking this time on a per-invocation basis is important because the cost of tracing is not uniform.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Call Overhead</em>' attribute.
	 * @see #setCallOverhead(double)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCCallerCalleeInvocationInfo_CallOverhead()
	 * @model default="0.0"
	 * @generated
	 */
	double getCallOverhead();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCCallerCalleeInvocationInfo#getCallOverhead <em>Call Overhead</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Call Overhead</em>' attribute.
	 * @see #getCallOverhead()
	 * @generated
	 */
	void setCallOverhead(double value);

} // TRCCallerCalleeInvocationInfo
