/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCObjectValuePosition.java,v 1.6 2004/12/03 17:22:57 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.trace;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>TRC Object Value Position</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * Represents the position in time where the value was captured.
 * <!-- end-model-doc -->
 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCObjectValuePosition()
 * @model
 * @generated
 */
public final class TRCObjectValuePosition extends AbstractEnumerator {
	/**
	 * The '<em><b>Before</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #BEFORE_LITERAL
	 * @model name="before"
	 * @generated
	 * @ordered
	 */
	public static final int BEFORE = 0;

	/**
	 * The '<em><b>After</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #AFTER_LITERAL
	 * @model name="after"
	 * @generated
	 * @ordered
	 */
	public static final int AFTER = 1;

	/**
	 * The '<em><b>Exit</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #EXIT_LITERAL
	 * @model name="exit"
	 * @generated
	 * @ordered
	 */
	public static final int EXIT = 2;

	/**
	 * The '<em><b>Before</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * the value on the call/entry
	 * <!-- end-model-doc -->
	 * @see #BEFORE
	 * @generated
	 * @ordered
	 */
	public static final TRCObjectValuePosition BEFORE_LITERAL = new TRCObjectValuePosition(BEFORE, "before");

	/**
	 * The '<em><b>After</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The value on the return/exit
	 * <!-- end-model-doc -->
	 * @see #AFTER
	 * @generated
	 * @ordered
	 */
	public static final TRCObjectValuePosition AFTER_LITERAL = new TRCObjectValuePosition(AFTER, "after");

	/**
	 * The '<em><b>Exit</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * represents an exit object, like return value or thown exception
	 * <!-- end-model-doc -->
	 * @see #EXIT
	 * @generated
	 * @ordered
	 */
	public static final TRCObjectValuePosition EXIT_LITERAL = new TRCObjectValuePosition(EXIT, "exit");

	/**
	 * An array of all the '<em><b>TRC Object Value Position</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final TRCObjectValuePosition[] VALUES_ARRAY =
		new TRCObjectValuePosition[] {
			BEFORE_LITERAL,
			AFTER_LITERAL,
			EXIT_LITERAL,
		};

	/**
	 * A public read-only list of all the '<em><b>TRC Object Value Position</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>TRC Object Value Position</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static TRCObjectValuePosition get(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			TRCObjectValuePosition result = VALUES_ARRAY[i];
			if (result.toString().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>TRC Object Value Position</b></em>' literal with the specified value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static TRCObjectValuePosition get(int value) {
		switch (value) {
			case BEFORE: return BEFORE_LITERAL;
			case AFTER: return AFTER_LITERAL;
			case EXIT: return EXIT_LITERAL;
		}
		return null;	
	}

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private TRCObjectValuePosition(int value, String name) {
		super(value, name);
	}

} //TRCObjectValuePosition
