/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCProcess.java,v 1.15 2004/12/03 17:22:57 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.trace;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.hyades.models.hierarchy.AbstractTRCProcess;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>TRC Process</b></em>'.
 * @extends org.eclipse.hyades.loaders.trace.IDeltaManager
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * TRCProcess represents a process. In this case it is one that has been monitored. It is the root container of a profiling trace.
 * 
 * - calls, baseTime, and cumulativeTime: these are aggregate measures of all the method invocations whose receiver object is of the given class (or package, or process).  For cumulativeTime, time spent in any method invocations that call each other is not counted more than once for that class (or package, or process).
 * 
 * - inheritedCalls, inheritedBaseTime, and inheritedCumulativeTime: these are aggregate measures of all the method invocations whose receiver object is of the given class (or package, or process), but limited to those whose method is not implemented in the class of the receiver object (i.e. it is implemented in a class further up in the class hierarchy).
 * 
 * 
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCProcess#getPid <em>Pid</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCProcess#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCProcess#getId <em>Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCProcess#getStartTime <em>Start Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCProcess#getStopTime <em>Stop Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCProcess#getLastEventTime <em>Last Event Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCProcess#getInitFinishedTime <em>Init Finished Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCProcess#getBaseTime <em>Base Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCProcess#getCumulativeTime <em>Cumulative Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCProcess#getCalls <em>Calls</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCProcess#getInheritedCalls <em>Inherited Calls</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCProcess#getInheritedBaseTime <em>Inherited Base Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCProcess#getInheritedCumulativeTime <em>Inherited Cumulative Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCProcess#getTotalSize <em>Total Size</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCProcess#getTotalInstances <em>Total Instances</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCProcess#getCollectedSize <em>Collected Size</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCProcess#getCollectedInstances <em>Collected Instances</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCProcess#getReferencePointerSize <em>Reference Pointer Size</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCProcess#getThreadStates <em>Thread States</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCProcess#getTotalCpuTime <em>Total Cpu Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCProcess#getCpuSampleResolution <em>Cpu Sample Resolution</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCProcess#getThreads <em>Threads</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCProcess#getPackages <em>Packages</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCProcess#getClassClass <em>Class Class</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCProcess#getCollectionBoundaryPoints <em>Collection Boundary Points</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCProcess#getClassLoaders <em>Class Loaders</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCProcess#getSourceInfos <em>Source Infos</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCProcess#getObjects <em>Objects</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCProcess#getHeapDumps <em>Heap Dumps</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCProcess#getInvocations <em>Invocations</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCProcess#getInputOutputContainer <em>Input Output Container</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCProcess#getMethodLockAccessEntries <em>Method Lock Access Entries</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.TRCProcess#getAllocationSitesEntries <em>Allocation Sites Entries</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCProcess()
 * @model 
 * @generated
 */
public interface TRCProcess extends AbstractTRCProcess, org.eclipse.hyades.loaders.trace.IDeltaManager{
	/**
	 * Returns the value of the '<em><b>Pid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Process ID as defined natively on the execution platform
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Pid</em>' attribute.
	 * @see #setPid(int)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCProcess_Pid()
	 * @model 
	 * @generated
	 */
	int getPid();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCProcess#getPid <em>Pid</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Pid</em>' attribute.
	 * @see #getPid()
	 * @generated
	 */
	void setPid(int value);

	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The name of the executable. The name is totally dependant on what the execution environment is able to provide, and what is collected by the agent. On some operating systems in an attach scenario for example the process name is simply not available, however in a scenario where the process is launched by the workbench, the tools can apply a robust name that is very meaningful to the end user.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCProcess_Name()
	 * @model 
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCProcess#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

	/**
	 * Returns the value of the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * A GUID based ID to identify a process instance
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Id</em>' attribute.
	 * @see #setId(String)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCProcess_Id()
	 * @model 
	 * @generated
	 */
	String getId();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCProcess#getId <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Id</em>' attribute.
	 * @see #getId()
	 * @generated
	 */
	void setId(String value);

	/**
	 * Returns the value of the '<em><b>Start Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The time when the process was started, relative to hierarchy.TRCAgent.startTime
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Start Time</em>' attribute.
	 * @see #setStartTime(double)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCProcess_StartTime()
	 * @model 
	 * @generated
	 */
	double getStartTime();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCProcess#getStartTime <em>Start Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Start Time</em>' attribute.
	 * @see #getStartTime()
	 * @generated
	 */
	void setStartTime(double value);

	/**
	 * Returns the value of the '<em><b>Stop Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The time when the process was stopped, relative to hierarchy.TRCAgent.startTime
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Stop Time</em>' attribute.
	 * @see #setStopTime(double)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCProcess_StopTime()
	 * @model 
	 * @generated
	 */
	double getStopTime();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCProcess#getStopTime <em>Stop Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Stop Time</em>' attribute.
	 * @see #getStopTime()
	 * @generated
	 */
	void setStopTime(double value);

	/**
	 * Returns the value of the '<em><b>Last Event Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The time of the last event received on this process, relative to hierarchy.TRCAgent.startTime
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Last Event Time</em>' attribute.
	 * @see #setLastEventTime(double)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCProcess_LastEventTime()
	 * @model 
	 * @generated
	 */
	double getLastEventTime();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCProcess#getLastEventTime <em>Last Event Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Last Event Time</em>' attribute.
	 * @see #getLastEventTime()
	 * @generated
	 */
	void setLastEventTime(double value);

	/**
	 * Returns the value of the '<em><b>Init Finished Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The time when the JVM initialization ended
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Init Finished Time</em>' attribute.
	 * @see #setInitFinishedTime(double)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCProcess_InitFinishedTime()
	 * @model 
	 * @generated
	 */
	double getInitFinishedTime();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCProcess#getInitFinishedTime <em>Init Finished Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Init Finished Time</em>' attribute.
	 * @see #getInitFinishedTime()
	 * @generated
	 */
	void setInitFinishedTime(double value);

	/**
	 * Returns the value of the '<em><b>Base Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Time spent in methods of the owning element
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Base Time</em>' attribute.
	 * @see #setBaseTime(double)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCProcess_BaseTime()
	 * @model 
	 * @generated
	 */
	double getBaseTime();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCProcess#getBaseTime <em>Base Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Base Time</em>' attribute.
	 * @see #getBaseTime()
	 * @generated
	 */
	void setBaseTime(double value);

	/**
	 * Returns the value of the '<em><b>Cumulative Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Time spent in methods of this owning element + all methods called from these methods (but owned by other elements)
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Cumulative Time</em>' attribute.
	 * @see #setCumulativeTime(double)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCProcess_CumulativeTime()
	 * @model 
	 * @generated
	 */
	double getCumulativeTime();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCProcess#getCumulativeTime <em>Cumulative Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Cumulative Time</em>' attribute.
	 * @see #getCumulativeTime()
	 * @generated
	 */
	void setCumulativeTime(double value);

	/**
	 * Returns the value of the '<em><b>Calls</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * number of calls to the owning element
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Calls</em>' attribute.
	 * @see #setCalls(int)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCProcess_Calls()
	 * @model 
	 * @generated
	 */
	int getCalls();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCProcess#getCalls <em>Calls</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Calls</em>' attribute.
	 * @see #getCalls()
	 * @generated
	 */
	void setCalls(int value);

	/**
	 * Returns the value of the '<em><b>Inherited Calls</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Number of calls to methods defined in superclasses of classes from the owning element
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Inherited Calls</em>' attribute.
	 * @see #setInheritedCalls(int)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCProcess_InheritedCalls()
	 * @model 
	 * @generated
	 */
	int getInheritedCalls();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCProcess#getInheritedCalls <em>Inherited Calls</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Inherited Calls</em>' attribute.
	 * @see #getInheritedCalls()
	 * @generated
	 */
	void setInheritedCalls(int value);

	/**
	 * Returns the value of the '<em><b>Inherited Base Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Time spent in methods defined in superclasses of this classes from the owning element
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Inherited Base Time</em>' attribute.
	 * @see #setInheritedBaseTime(double)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCProcess_InheritedBaseTime()
	 * @model 
	 * @generated
	 */
	double getInheritedBaseTime();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCProcess#getInheritedBaseTime <em>Inherited Base Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Inherited Base Time</em>' attribute.
	 * @see #getInheritedBaseTime()
	 * @generated
	 */
	void setInheritedBaseTime(double value);

	/**
	 * Returns the value of the '<em><b>Inherited Cumulative Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Time spent in methods of classes from the owning element + all methods called from the methods defined in superclasses of classes from the owning element
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Inherited Cumulative Time</em>' attribute.
	 * @see #setInheritedCumulativeTime(double)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCProcess_InheritedCumulativeTime()
	 * @model 
	 * @generated
	 */
	double getInheritedCumulativeTime();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCProcess#getInheritedCumulativeTime <em>Inherited Cumulative Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Inherited Cumulative Time</em>' attribute.
	 * @see #getInheritedCumulativeTime()
	 * @generated
	 */
	void setInheritedCumulativeTime(double value);

	/**
	 * Returns the value of the '<em><b>Total Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The total size of memory allocated
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Total Size</em>' attribute.
	 * @see #setTotalSize(int)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCProcess_TotalSize()
	 * @model 
	 * @generated
	 */
	int getTotalSize();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCProcess#getTotalSize <em>Total Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Total Size</em>' attribute.
	 * @see #getTotalSize()
	 * @generated
	 */
	void setTotalSize(int value);

	/**
	 * Returns the value of the '<em><b>Total Instances</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Number of instances created
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Total Instances</em>' attribute.
	 * @see #setTotalInstances(int)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCProcess_TotalInstances()
	 * @model 
	 * @generated
	 */
	int getTotalInstances();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCProcess#getTotalInstances <em>Total Instances</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Total Instances</em>' attribute.
	 * @see #getTotalInstances()
	 * @generated
	 */
	void setTotalInstances(int value);

	/**
	 * Returns the value of the '<em><b>Collected Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The total size of memory garbage collected
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Collected Size</em>' attribute.
	 * @see #setCollectedSize(int)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCProcess_CollectedSize()
	 * @model 
	 * @generated
	 */
	int getCollectedSize();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCProcess#getCollectedSize <em>Collected Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Collected Size</em>' attribute.
	 * @see #getCollectedSize()
	 * @generated
	 */
	void setCollectedSize(int value);

	/**
	 * Returns the value of the '<em><b>Collected Instances</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Number of instances garbage collected
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Collected Instances</em>' attribute.
	 * @see #setCollectedInstances(int)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCProcess_CollectedInstances()
	 * @model 
	 * @generated
	 */
	int getCollectedInstances();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCProcess#getCollectedInstances <em>Collected Instances</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Collected Instances</em>' attribute.
	 * @see #getCollectedInstances()
	 * @generated
	 */
	void setCollectedInstances(int value);

	/**
	 * Returns the value of the '<em><b>Reference Pointer Size</b></em>' attribute.
	 * The default value is <code>"4"</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Represents the number of bytes used for a reference pointer.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Reference Pointer Size</em>' attribute.
	 * @see #setReferencePointerSize(short)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCProcess_ReferencePointerSize()
	 * @model default="4"
	 * @generated
	 */
	short getReferencePointerSize();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCProcess#getReferencePointerSize <em>Reference Pointer Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Reference Pointer Size</em>' attribute.
	 * @see #getReferencePointerSize()
	 * @generated
	 */
	void setReferencePointerSize(short value);

	/**
	 * Returns the value of the '<em><b>Thread States</b></em>' attribute list.
	 * The list contents are of type {@link java.lang.String}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The name of the executable. The name is totally dependant on what the execution environment is able to provide, and what is collected by the agent. On some operating systems in an attach scenario for example the process name is simply not available, however in a scenario where the process is launched by the workbench, the tools can apply a robust name that is very meaningful to the end user.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Thread States</em>' attribute list.
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCProcess_ThreadStates()
	 * @model type="java.lang.String"
	 * @generated
	 */
	EList getThreadStates();

	/**
	 * Returns the value of the '<em><b>Total Cpu Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Holds the thread CPU time consumed by all invocations of all methods in all classes contained in this package
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Total Cpu Time</em>' attribute.
	 * @see #setTotalCpuTime(double)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCProcess_TotalCpuTime()
	 * @model 
	 * @generated
	 */
	double getTotalCpuTime();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCProcess#getTotalCpuTime <em>Total Cpu Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Total Cpu Time</em>' attribute.
	 * @see #getTotalCpuTime()
	 * @generated
	 */
	void setTotalCpuTime(double value);

	/**
	 * Returns the value of the '<em><b>Cpu Sample Resolution</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This records the lowest resolution (most granular) for collection of CPU time samples in the Process to enable viewers to prevent sampling resolution errors.
	 * 
	 * For example the thread CPU sample resolution is Windows is 100 nanoseconds. Thus if a method that has an elapsed time of 10 nanoseconds is called 10 times the CPU time will get recorded as 0 value for nine of the call instances and 100 nanoseconds for one instance, 
	 * Other platforms are likely to have lower resolution
	 * 
	 * It is noted that a Process might run mixed languages etc. that might cause the sample resolution to be different. The model should be set to record the lowest resolution of any sample.
	 * This was considered an exceptional case and the overriding requirement to keep model foot print down hence we will only hold the single resolution value
	 * 
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Cpu Sample Resolution</em>' attribute.
	 * @see #setCpuSampleResolution(double)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCProcess_CpuSampleResolution()
	 * @model 
	 * @generated
	 */
	double getCpuSampleResolution();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCProcess#getCpuSampleResolution <em>Cpu Sample Resolution</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Cpu Sample Resolution</em>' attribute.
	 * @see #getCpuSampleResolution()
	 * @generated
	 */
	void setCpuSampleResolution(double value);

	/**
	 * Returns the value of the '<em><b>Threads</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.trace.TRCThread}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.trace.TRCThread#getProcess <em>Process</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Threads</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Threads</em>' containment reference list.
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCProcess_Threads()
	 * @see org.eclipse.hyades.models.trace.TRCThread#getProcess
	 * @model type="org.eclipse.hyades.models.trace.TRCThread" opposite="process" containment="true" required="true"
	 * @generated
	 */
	EList getThreads();

	/**
	 * Returns the value of the '<em><b>Packages</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.trace.TRCPackage}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.trace.TRCPackage#getProcess <em>Process</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Packages</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Packages</em>' containment reference list.
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCProcess_Packages()
	 * @see org.eclipse.hyades.models.trace.TRCPackage#getProcess
	 * @model type="org.eclipse.hyades.models.trace.TRCPackage" opposite="process" containment="true"
	 * @generated
	 */
	EList getPackages();

	/**
	 * Returns the value of the '<em><b>Class Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Class Class</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Class Class</em>' reference.
	 * @see #setClassClass(TRCClass)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCProcess_ClassClass()
	 * @model 
	 * @generated
	 */
	TRCClass getClassClass();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCProcess#getClassClass <em>Class Class</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Class Class</em>' reference.
	 * @see #getClassClass()
	 * @generated
	 */
	void setClassClass(TRCClass value);

	/**
	 * Returns the value of the '<em><b>Collection Boundary Points</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.trace.TRCCollectionBoundary}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.trace.TRCCollectionBoundary#getProcess <em>Process</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Collection Boundary Points</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Collection Boundary Points</em>' containment reference list.
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCProcess_CollectionBoundaryPoints()
	 * @see org.eclipse.hyades.models.trace.TRCCollectionBoundary#getProcess
	 * @model type="org.eclipse.hyades.models.trace.TRCCollectionBoundary" opposite="process" containment="true"
	 * @generated
	 */
	EList getCollectionBoundaryPoints();

	/**
	 * Returns the value of the '<em><b>Class Loaders</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.trace.TRCClassLoader}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.trace.TRCClassLoader#getProcess <em>Process</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Class Loaders</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Class Loaders</em>' containment reference list.
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCProcess_ClassLoaders()
	 * @see org.eclipse.hyades.models.trace.TRCClassLoader#getProcess
	 * @model type="org.eclipse.hyades.models.trace.TRCClassLoader" opposite="process" containment="true"
	 * @generated
	 */
	EList getClassLoaders();

	/**
	 * Returns the value of the '<em><b>Source Infos</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.trace.TRCSourceInfo}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Source Infos</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Source Infos</em>' containment reference list.
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCProcess_SourceInfos()
	 * @model type="org.eclipse.hyades.models.trace.TRCSourceInfo" containment="true"
	 * @generated
	 */
	EList getSourceInfos();

	/**
	 * Returns the value of the '<em><b>Objects</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.trace.TRCObject}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.trace.TRCObject#getProcess <em>Process</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Objects</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Objects</em>' containment reference list.
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCProcess_Objects()
	 * @see org.eclipse.hyades.models.trace.TRCObject#getProcess
	 * @model type="org.eclipse.hyades.models.trace.TRCObject" opposite="process" containment="true"
	 * @generated
	 */
	EList getObjects();

	/**
	 * Returns the value of the '<em><b>Heap Dumps</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.trace.TRCHeapDump}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.trace.TRCHeapDump#getProcess <em>Process</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Heap Dumps</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Heap Dumps</em>' containment reference list.
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCProcess_HeapDumps()
	 * @see org.eclipse.hyades.models.trace.TRCHeapDump#getProcess
	 * @model type="org.eclipse.hyades.models.trace.TRCHeapDump" opposite="process" containment="true"
	 * @generated
	 */
	EList getHeapDumps();

	/**
	 * Returns the value of the '<em><b>Invocations</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.models.trace.TRCMethodInvocation}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.trace.TRCMethodInvocation#getProcess <em>Process</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Invocations</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Invocations</em>' containment reference list.
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCProcess_Invocations()
	 * @see org.eclipse.hyades.models.trace.TRCMethodInvocation#getProcess
	 * @model type="org.eclipse.hyades.models.trace.TRCMethodInvocation" opposite="process" containment="true"
	 * @generated
	 */
	EList getInvocations();

	/**
	 * Returns the value of the '<em><b>Input Output Container</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.trace.TRCInputOutputContainer#getProcess <em>Process</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Input Output Container</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Input Output Container</em>' reference.
	 * @see #setInputOutputContainer(TRCInputOutputContainer)
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCProcess_InputOutputContainer()
	 * @see org.eclipse.hyades.models.trace.TRCInputOutputContainer#getProcess
	 * @model opposite="process"
	 * @generated
	 */
	TRCInputOutputContainer getInputOutputContainer();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.models.trace.TRCProcess#getInputOutputContainer <em>Input Output Container</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Input Output Container</em>' reference.
	 * @see #getInputOutputContainer()
	 * @generated
	 */
	void setInputOutputContainer(TRCInputOutputContainer value);

	/**
	 * Returns the value of the '<em><b>Method Lock Access Entries</b></em>' map.
	 * The key is of type {@link org.eclipse.hyades.models.trace.TRCMethodInvocation},
	 * and the value is of type list of {@link org.eclipse.hyades.models.trace.TRCLockAccess},
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Method Lock Access Entries</em>' map isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Method Lock Access Entries</em>' map.
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCProcess_MethodLockAccessEntries()
	 * @model mapType="org.eclipse.hyades.models.trace.TRCMthdLckAccEntry" keyType="org.eclipse.hyades.models.trace.TRCMethodInvocation" valueType="org.eclipse.hyades.models.trace.TRCLockAccess"
	 * @generated
	 */
	EMap getMethodLockAccessEntries();

	/**
	 * Returns the value of the '<em><b>Allocation Sites Entries</b></em>' map.
	 * The key is of type {@link org.eclipse.hyades.models.trace.TRCMethodInvocation},
	 * and the value is of type list of {@link org.eclipse.hyades.models.trace.TRCObjectAllocationSite},
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Allocation Sites Entries</em>' map isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Allocation Sites Entries</em>' map.
	 * @see org.eclipse.hyades.models.trace.TracePackage#getTRCProcess_AllocationSitesEntries()
	 * @model mapType="org.eclipse.hyades.models.trace.TRCObjectAllocationSitesEntry" keyType="org.eclipse.hyades.models.trace.TRCMethodInvocation" valueType="org.eclipse.hyades.models.trace.TRCObjectAllocationSite"
	 * @generated
	 */
	EMap getAllocationSitesEntries();

} // TRCProcess
