/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCAggregatedObjectReferenceImpl.java,v 1.8 2004/12/03 17:22:57 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.hyades.models.trace.TRCAggregatedObjectReference;
import org.eclipse.hyades.models.trace.TRCHeapDump;
import org.eclipse.hyades.models.trace.TRCHeapObject;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Aggregated Object Reference</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCAggregatedObjectReferenceImpl#getOwnerSize <em>Owner Size</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCAggregatedObjectReferenceImpl#getTargetSize <em>Target Size</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCAggregatedObjectReferenceImpl#getCount <em>Count</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCAggregatedObjectReferenceImpl extends TRCObjectReferenceImpl implements TRCAggregatedObjectReference {
	/**
	 * The default value of the '{@link #getOwnerSize() <em>Owner Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOwnerSize()
	 * @generated
	 * @ordered
	 */
	protected static final int OWNER_SIZE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getOwnerSize() <em>Owner Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOwnerSize()
	 * @generated
	 * @ordered
	 */
	protected int ownerSize = OWNER_SIZE_EDEFAULT;

	/**
	 * The default value of the '{@link #getTargetSize() <em>Target Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTargetSize()
	 * @generated
	 * @ordered
	 */
	protected static final int TARGET_SIZE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getTargetSize() <em>Target Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTargetSize()
	 * @generated
	 * @ordered
	 */
	protected int targetSize = TARGET_SIZE_EDEFAULT;

	/**
	 * The default value of the '{@link #getCount() <em>Count</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCount()
	 * @generated
	 * @ordered
	 */
	protected static final int COUNT_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getCount() <em>Count</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCount()
	 * @generated
	 * @ordered
	 */
	protected int count = COUNT_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCAggregatedObjectReferenceImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return TracePackage.eINSTANCE.getTRCAggregatedObjectReference();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getOwnerSize() {
		return ownerSize;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOwnerSize(int newOwnerSize) {
		int oldOwnerSize = ownerSize;
		ownerSize = newOwnerSize;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__OWNER_SIZE, oldOwnerSize, ownerSize));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getTargetSize() {
		return targetSize;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTargetSize(int newTargetSize) {
		int oldTargetSize = targetSize;
		targetSize = newTargetSize;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__TARGET_SIZE, oldTargetSize, targetSize));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getCount() {
		return count;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCount(int newCount) {
		int oldCount = count;
		count = newCount;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__COUNT, oldCount, count));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__HEAP_DUMP:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__HEAP_DUMP, msgs);
				case TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__OWNER:
					if (owner != null)
						msgs = ((InternalEObject)owner).eInverseRemove(this, TracePackage.TRC_HEAP_OBJECT__REF_OWNER, TRCHeapObject.class, msgs);
					return basicSetOwner((TRCHeapObject)otherEnd, msgs);
				case TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__TARGET:
					if (target != null)
						msgs = ((InternalEObject)target).eInverseRemove(this, TracePackage.TRC_HEAP_OBJECT__REF_TARGET, TRCHeapObject.class, msgs);
					return basicSetTarget((TRCHeapObject)otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__HEAP_DUMP:
					return eBasicSetContainer(null, TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__HEAP_DUMP, msgs);
				case TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__OWNER:
					return basicSetOwner(null, msgs);
				case TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__TARGET:
					return basicSetTarget(null, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__HEAP_DUMP:
					return ((InternalEObject)eContainer).eInverseRemove(this, TracePackage.TRC_HEAP_DUMP__REFERENCES, TRCHeapDump.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__HEAP_DUMP:
				return getHeapDump();
			case TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__OWNER:
				if (resolve) return getOwner();
				return basicGetOwner();
			case TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__TARGET:
				if (resolve) return getTarget();
				return basicGetTarget();
			case TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__OWNER_SIZE:
				return new Integer(getOwnerSize());
			case TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__TARGET_SIZE:
				return new Integer(getTargetSize());
			case TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__COUNT:
				return new Integer(getCount());
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__HEAP_DUMP:
				setHeapDump((TRCHeapDump)newValue);
				return;
			case TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__OWNER:
				setOwner((TRCHeapObject)newValue);
				return;
			case TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__TARGET:
				setTarget((TRCHeapObject)newValue);
				return;
			case TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__OWNER_SIZE:
				setOwnerSize(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__TARGET_SIZE:
				setTargetSize(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__COUNT:
				setCount(((Integer)newValue).intValue());
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__HEAP_DUMP:
				setHeapDump((TRCHeapDump)null);
				return;
			case TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__OWNER:
				setOwner((TRCHeapObject)null);
				return;
			case TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__TARGET:
				setTarget((TRCHeapObject)null);
				return;
			case TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__OWNER_SIZE:
				setOwnerSize(OWNER_SIZE_EDEFAULT);
				return;
			case TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__TARGET_SIZE:
				setTargetSize(TARGET_SIZE_EDEFAULT);
				return;
			case TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__COUNT:
				setCount(COUNT_EDEFAULT);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__HEAP_DUMP:
				return getHeapDump() != null;
			case TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__OWNER:
				return owner != null;
			case TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__TARGET:
				return target != null;
			case TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__OWNER_SIZE:
				return ownerSize != OWNER_SIZE_EDEFAULT;
			case TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__TARGET_SIZE:
				return targetSize != TARGET_SIZE_EDEFAULT;
			case TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE__COUNT:
				return count != COUNT_EDEFAULT;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (ownerSize: ");
		result.append(ownerSize);
		result.append(", targetSize: ");
		result.append(targetSize);
		result.append(", count: ");
		result.append(count);
		result.append(')');
		return result.toString();
	}

} //TRCAggregatedObjectReferenceImpl
