/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCArrayClassImpl.java,v 1.10 2004/12/03 17:22:57 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.trace.TRCArrayClass;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCClassLoader;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TRCPrimitiveType;
import org.eclipse.hyades.models.trace.TRCSourceInfo;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Array Class</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCArrayClassImpl#getArrayType <em>Array Type</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCArrayClassImpl#getElementType <em>Element Type</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCArrayClassImpl extends TRCClassImpl implements TRCArrayClass {
	/**
	 * The default value of the '{@link #getArrayType() <em>Array Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getArrayType()
	 * @generated
	 * @ordered
	 */
	protected static final TRCPrimitiveType ARRAY_TYPE_EDEFAULT = TRCPrimitiveType.JAVA_REFERENCE_LITERAL;

	/**
	 * The cached value of the '{@link #getArrayType() <em>Array Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getArrayType()
	 * @generated
	 * @ordered
	 */
	protected TRCPrimitiveType arrayType = ARRAY_TYPE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getElementType() <em>Element Type</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getElementType()
	 * @generated
	 * @ordered
	 */
	protected TRCClass elementType = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCArrayClassImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return TracePackage.eINSTANCE.getTRCArrayClass();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCPrimitiveType getArrayType() {
		return arrayType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setArrayType(TRCPrimitiveType newArrayType) {
		TRCPrimitiveType oldArrayType = arrayType;
		arrayType = newArrayType == null ? ARRAY_TYPE_EDEFAULT : newArrayType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_ARRAY_CLASS__ARRAY_TYPE, oldArrayType, arrayType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCClass getElementType() {
		if (elementType != null && elementType.eIsProxy()) {
			TRCClass oldElementType = elementType;
			elementType = (TRCClass)eResolveProxy((InternalEObject)elementType);
			if (elementType != oldElementType) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_ARRAY_CLASS__ELEMENT_TYPE, oldElementType, elementType));
			}
		}
		return elementType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCClass basicGetElementType() {
		return elementType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setElementType(TRCClass newElementType) {
		TRCClass oldElementType = elementType;
		elementType = newElementType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_ARRAY_CLASS__ELEMENT_TYPE, oldElementType, elementType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_ARRAY_CLASS__OBJECTS:
					return ((InternalEList)getObjects()).basicAdd(otherEnd, msgs);
				case TracePackage.TRC_ARRAY_CLASS__METHODS:
					return ((InternalEList)getMethods()).basicAdd(otherEnd, msgs);
				case TracePackage.TRC_ARRAY_CLASS__PACKAGE:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, TracePackage.TRC_ARRAY_CLASS__PACKAGE, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_ARRAY_CLASS__OBJECTS:
					return ((InternalEList)getObjects()).basicRemove(otherEnd, msgs);
				case TracePackage.TRC_ARRAY_CLASS__METHODS:
					return ((InternalEList)getMethods()).basicRemove(otherEnd, msgs);
				case TracePackage.TRC_ARRAY_CLASS__PACKAGE:
					return eBasicSetContainer(null, TracePackage.TRC_ARRAY_CLASS__PACKAGE, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case TracePackage.TRC_ARRAY_CLASS__PACKAGE:
					return ((InternalEObject)eContainer).eInverseRemove(this, TracePackage.TRC_PACKAGE__CLASSES, TRCPackage.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_ARRAY_CLASS__ID:
				return new Long(getId());
			case TracePackage.TRC_ARRAY_CLASS__NAME:
				return getName();
			case TracePackage.TRC_ARRAY_CLASS__SIZE:
				return new Integer(getSize());
			case TracePackage.TRC_ARRAY_CLASS__LOAD_TIME:
				return new Double(getLoadTime());
			case TracePackage.TRC_ARRAY_CLASS__UNLOAD_TIME:
				return new Double(getUnloadTime());
			case TracePackage.TRC_ARRAY_CLASS__INTERFACE:
				return isInterface() ? Boolean.TRUE : Boolean.FALSE;
			case TracePackage.TRC_ARRAY_CLASS__LINE_NO:
				return new Integer(getLineNo());
			case TracePackage.TRC_ARRAY_CLASS__BASE_TIME:
				return new Double(getBaseTime());
			case TracePackage.TRC_ARRAY_CLASS__CUMULATIVE_TIME:
				return new Double(getCumulativeTime());
			case TracePackage.TRC_ARRAY_CLASS__CALLS:
				return new Integer(getCalls());
			case TracePackage.TRC_ARRAY_CLASS__INHERITED_CALLS:
				return new Integer(getInheritedCalls());
			case TracePackage.TRC_ARRAY_CLASS__INHERITED_BASE_TIME:
				return new Double(getInheritedBaseTime());
			case TracePackage.TRC_ARRAY_CLASS__INHERITED_CUMULATIVE_TIME:
				return new Double(getInheritedCumulativeTime());
			case TracePackage.TRC_ARRAY_CLASS__TOTAL_SIZE:
				return new Integer(getTotalSize());
			case TracePackage.TRC_ARRAY_CLASS__TOTAL_INSTANCES:
				return new Integer(getTotalInstances());
			case TracePackage.TRC_ARRAY_CLASS__COLLECTED_SIZE:
				return new Integer(getCollectedSize());
			case TracePackage.TRC_ARRAY_CLASS__COLLECTED_INSTANCES:
				return new Integer(getCollectedInstances());
			case TracePackage.TRC_ARRAY_CLASS__TOTAL_CPU_TIME:
				return new Double(getTotalCpuTime());
			case TracePackage.TRC_ARRAY_CLASS__OBJECTS:
				return getObjects();
			case TracePackage.TRC_ARRAY_CLASS__LOADED_BY:
				if (resolve) return getLoadedBy();
				return basicGetLoadedBy();
			case TracePackage.TRC_ARRAY_CLASS__METHODS:
				return getMethods();
			case TracePackage.TRC_ARRAY_CLASS__CLASS_OBJECTS:
				return getClassObjects();
			case TracePackage.TRC_ARRAY_CLASS__PACKAGE:
				return getPackage();
			case TracePackage.TRC_ARRAY_CLASS__CLASS_LOADER:
				if (resolve) return getClassLoader();
				return basicGetClassLoader();
			case TracePackage.TRC_ARRAY_CLASS__SOURCE_INFO:
				if (resolve) return getSourceInfo();
				return basicGetSourceInfo();
			case TracePackage.TRC_ARRAY_CLASS__ENCLOSED_BY:
				if (resolve) return getEnclosedBy();
				return basicGetEnclosedBy();
			case TracePackage.TRC_ARRAY_CLASS__EXTENDS:
				return getExtends();
			case TracePackage.TRC_ARRAY_CLASS__IMPLEMENTS:
				return getImplements();
			case TracePackage.TRC_ARRAY_CLASS__LOCKS:
				return getLocks();
			case TracePackage.TRC_ARRAY_CLASS__ARRAY_TYPE:
				return getArrayType();
			case TracePackage.TRC_ARRAY_CLASS__ELEMENT_TYPE:
				if (resolve) return getElementType();
				return basicGetElementType();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_ARRAY_CLASS__ID:
				setId(((Long)newValue).longValue());
				return;
			case TracePackage.TRC_ARRAY_CLASS__NAME:
				setName((String)newValue);
				return;
			case TracePackage.TRC_ARRAY_CLASS__SIZE:
				setSize(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_ARRAY_CLASS__LOAD_TIME:
				setLoadTime(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_ARRAY_CLASS__UNLOAD_TIME:
				setUnloadTime(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_ARRAY_CLASS__INTERFACE:
				setInterface(((Boolean)newValue).booleanValue());
				return;
			case TracePackage.TRC_ARRAY_CLASS__LINE_NO:
				setLineNo(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_ARRAY_CLASS__BASE_TIME:
				setBaseTime(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_ARRAY_CLASS__CUMULATIVE_TIME:
				setCumulativeTime(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_ARRAY_CLASS__CALLS:
				setCalls(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_ARRAY_CLASS__INHERITED_CALLS:
				setInheritedCalls(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_ARRAY_CLASS__INHERITED_BASE_TIME:
				setInheritedBaseTime(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_ARRAY_CLASS__INHERITED_CUMULATIVE_TIME:
				setInheritedCumulativeTime(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_ARRAY_CLASS__TOTAL_SIZE:
				setTotalSize(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_ARRAY_CLASS__TOTAL_INSTANCES:
				setTotalInstances(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_ARRAY_CLASS__COLLECTED_SIZE:
				setCollectedSize(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_ARRAY_CLASS__COLLECTED_INSTANCES:
				setCollectedInstances(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_ARRAY_CLASS__TOTAL_CPU_TIME:
				setTotalCpuTime(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_ARRAY_CLASS__OBJECTS:
				getObjects().clear();
				getObjects().addAll((Collection)newValue);
				return;
			case TracePackage.TRC_ARRAY_CLASS__LOADED_BY:
				setLoadedBy((TRCThread)newValue);
				return;
			case TracePackage.TRC_ARRAY_CLASS__METHODS:
				getMethods().clear();
				getMethods().addAll((Collection)newValue);
				return;
			case TracePackage.TRC_ARRAY_CLASS__CLASS_OBJECTS:
				getClassObjects().clear();
				getClassObjects().addAll((Collection)newValue);
				return;
			case TracePackage.TRC_ARRAY_CLASS__PACKAGE:
				setPackage((TRCPackage)newValue);
				return;
			case TracePackage.TRC_ARRAY_CLASS__CLASS_LOADER:
				setClassLoader((TRCClassLoader)newValue);
				return;
			case TracePackage.TRC_ARRAY_CLASS__SOURCE_INFO:
				setSourceInfo((TRCSourceInfo)newValue);
				return;
			case TracePackage.TRC_ARRAY_CLASS__ENCLOSED_BY:
				setEnclosedBy((TRCClass)newValue);
				return;
			case TracePackage.TRC_ARRAY_CLASS__EXTENDS:
				getExtends().clear();
				getExtends().addAll((Collection)newValue);
				return;
			case TracePackage.TRC_ARRAY_CLASS__IMPLEMENTS:
				getImplements().clear();
				getImplements().addAll((Collection)newValue);
				return;
			case TracePackage.TRC_ARRAY_CLASS__LOCKS:
				getLocks().clear();
				getLocks().addAll((Collection)newValue);
				return;
			case TracePackage.TRC_ARRAY_CLASS__ARRAY_TYPE:
				setArrayType((TRCPrimitiveType)newValue);
				return;
			case TracePackage.TRC_ARRAY_CLASS__ELEMENT_TYPE:
				setElementType((TRCClass)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_ARRAY_CLASS__ID:
				setId(ID_EDEFAULT);
				return;
			case TracePackage.TRC_ARRAY_CLASS__NAME:
				setName(NAME_EDEFAULT);
				return;
			case TracePackage.TRC_ARRAY_CLASS__SIZE:
				setSize(SIZE_EDEFAULT);
				return;
			case TracePackage.TRC_ARRAY_CLASS__LOAD_TIME:
				setLoadTime(LOAD_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_ARRAY_CLASS__UNLOAD_TIME:
				setUnloadTime(UNLOAD_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_ARRAY_CLASS__INTERFACE:
				setInterface(INTERFACE_EDEFAULT);
				return;
			case TracePackage.TRC_ARRAY_CLASS__LINE_NO:
				setLineNo(LINE_NO_EDEFAULT);
				return;
			case TracePackage.TRC_ARRAY_CLASS__BASE_TIME:
				setBaseTime(BASE_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_ARRAY_CLASS__CUMULATIVE_TIME:
				setCumulativeTime(CUMULATIVE_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_ARRAY_CLASS__CALLS:
				setCalls(CALLS_EDEFAULT);
				return;
			case TracePackage.TRC_ARRAY_CLASS__INHERITED_CALLS:
				setInheritedCalls(INHERITED_CALLS_EDEFAULT);
				return;
			case TracePackage.TRC_ARRAY_CLASS__INHERITED_BASE_TIME:
				setInheritedBaseTime(INHERITED_BASE_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_ARRAY_CLASS__INHERITED_CUMULATIVE_TIME:
				setInheritedCumulativeTime(INHERITED_CUMULATIVE_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_ARRAY_CLASS__TOTAL_SIZE:
				setTotalSize(TOTAL_SIZE_EDEFAULT);
				return;
			case TracePackage.TRC_ARRAY_CLASS__TOTAL_INSTANCES:
				setTotalInstances(TOTAL_INSTANCES_EDEFAULT);
				return;
			case TracePackage.TRC_ARRAY_CLASS__COLLECTED_SIZE:
				setCollectedSize(COLLECTED_SIZE_EDEFAULT);
				return;
			case TracePackage.TRC_ARRAY_CLASS__COLLECTED_INSTANCES:
				setCollectedInstances(COLLECTED_INSTANCES_EDEFAULT);
				return;
			case TracePackage.TRC_ARRAY_CLASS__TOTAL_CPU_TIME:
				setTotalCpuTime(TOTAL_CPU_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_ARRAY_CLASS__OBJECTS:
				getObjects().clear();
				return;
			case TracePackage.TRC_ARRAY_CLASS__LOADED_BY:
				setLoadedBy((TRCThread)null);
				return;
			case TracePackage.TRC_ARRAY_CLASS__METHODS:
				getMethods().clear();
				return;
			case TracePackage.TRC_ARRAY_CLASS__CLASS_OBJECTS:
				getClassObjects().clear();
				return;
			case TracePackage.TRC_ARRAY_CLASS__PACKAGE:
				setPackage((TRCPackage)null);
				return;
			case TracePackage.TRC_ARRAY_CLASS__CLASS_LOADER:
				setClassLoader((TRCClassLoader)null);
				return;
			case TracePackage.TRC_ARRAY_CLASS__SOURCE_INFO:
				setSourceInfo((TRCSourceInfo)null);
				return;
			case TracePackage.TRC_ARRAY_CLASS__ENCLOSED_BY:
				setEnclosedBy((TRCClass)null);
				return;
			case TracePackage.TRC_ARRAY_CLASS__EXTENDS:
				getExtends().clear();
				return;
			case TracePackage.TRC_ARRAY_CLASS__IMPLEMENTS:
				getImplements().clear();
				return;
			case TracePackage.TRC_ARRAY_CLASS__LOCKS:
				getLocks().clear();
				return;
			case TracePackage.TRC_ARRAY_CLASS__ARRAY_TYPE:
				setArrayType(ARRAY_TYPE_EDEFAULT);
				return;
			case TracePackage.TRC_ARRAY_CLASS__ELEMENT_TYPE:
				setElementType((TRCClass)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_ARRAY_CLASS__ID:
				return id != ID_EDEFAULT;
			case TracePackage.TRC_ARRAY_CLASS__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case TracePackage.TRC_ARRAY_CLASS__SIZE:
				return size != SIZE_EDEFAULT;
			case TracePackage.TRC_ARRAY_CLASS__LOAD_TIME:
				return loadTime != LOAD_TIME_EDEFAULT;
			case TracePackage.TRC_ARRAY_CLASS__UNLOAD_TIME:
				return unloadTime != UNLOAD_TIME_EDEFAULT;
			case TracePackage.TRC_ARRAY_CLASS__INTERFACE:
				return interface_ != INTERFACE_EDEFAULT;
			case TracePackage.TRC_ARRAY_CLASS__LINE_NO:
				return lineNo != LINE_NO_EDEFAULT;
			case TracePackage.TRC_ARRAY_CLASS__BASE_TIME:
				return baseTime != BASE_TIME_EDEFAULT;
			case TracePackage.TRC_ARRAY_CLASS__CUMULATIVE_TIME:
				return cumulativeTime != CUMULATIVE_TIME_EDEFAULT;
			case TracePackage.TRC_ARRAY_CLASS__CALLS:
				return calls != CALLS_EDEFAULT;
			case TracePackage.TRC_ARRAY_CLASS__INHERITED_CALLS:
				return inheritedCalls != INHERITED_CALLS_EDEFAULT;
			case TracePackage.TRC_ARRAY_CLASS__INHERITED_BASE_TIME:
				return inheritedBaseTime != INHERITED_BASE_TIME_EDEFAULT;
			case TracePackage.TRC_ARRAY_CLASS__INHERITED_CUMULATIVE_TIME:
				return inheritedCumulativeTime != INHERITED_CUMULATIVE_TIME_EDEFAULT;
			case TracePackage.TRC_ARRAY_CLASS__TOTAL_SIZE:
				return totalSize != TOTAL_SIZE_EDEFAULT;
			case TracePackage.TRC_ARRAY_CLASS__TOTAL_INSTANCES:
				return totalInstances != TOTAL_INSTANCES_EDEFAULT;
			case TracePackage.TRC_ARRAY_CLASS__COLLECTED_SIZE:
				return collectedSize != COLLECTED_SIZE_EDEFAULT;
			case TracePackage.TRC_ARRAY_CLASS__COLLECTED_INSTANCES:
				return collectedInstances != COLLECTED_INSTANCES_EDEFAULT;
			case TracePackage.TRC_ARRAY_CLASS__TOTAL_CPU_TIME:
				return totalCpuTime != TOTAL_CPU_TIME_EDEFAULT;
			case TracePackage.TRC_ARRAY_CLASS__OBJECTS:
				return objects != null && !objects.isEmpty();
			case TracePackage.TRC_ARRAY_CLASS__LOADED_BY:
				return loadedBy != null;
			case TracePackage.TRC_ARRAY_CLASS__METHODS:
				return methods != null && !methods.isEmpty();
			case TracePackage.TRC_ARRAY_CLASS__CLASS_OBJECTS:
				return classObjects != null && !classObjects.isEmpty();
			case TracePackage.TRC_ARRAY_CLASS__PACKAGE:
				return getPackage() != null;
			case TracePackage.TRC_ARRAY_CLASS__CLASS_LOADER:
				return classLoader != null;
			case TracePackage.TRC_ARRAY_CLASS__SOURCE_INFO:
				return sourceInfo != null;
			case TracePackage.TRC_ARRAY_CLASS__ENCLOSED_BY:
				return enclosedBy != null;
			case TracePackage.TRC_ARRAY_CLASS__EXTENDS:
				return extends_ != null && !extends_.isEmpty();
			case TracePackage.TRC_ARRAY_CLASS__IMPLEMENTS:
				return implements_ != null && !implements_.isEmpty();
			case TracePackage.TRC_ARRAY_CLASS__LOCKS:
				return locks != null && !locks.isEmpty();
			case TracePackage.TRC_ARRAY_CLASS__ARRAY_TYPE:
				return arrayType != ARRAY_TYPE_EDEFAULT;
			case TracePackage.TRC_ARRAY_CLASS__ELEMENT_TYPE:
				return elementType != null;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (arrayType: ");
		result.append(arrayType);
		result.append(')');
		return result.toString();
	}

} //TRCArrayClassImpl
