/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCCallerCalleeInvocationInfoImpl.java,v 1.7 2004/12/03 17:22:57 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.trace.TRCCallerCalleeInvocationInfo;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCTraceObject;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Caller Callee Invocation Info</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCCallerCalleeInvocationInfoImpl#getCallTime <em>Call Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCCallerCalleeInvocationInfoImpl#getReturnTime <em>Return Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCCallerCalleeInvocationInfoImpl#getCallOverhead <em>Call Overhead</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCCallerCalleeInvocationInfoImpl extends TRCFullMethodInvocationImpl implements TRCCallerCalleeInvocationInfo {
	/**
	 * The default value of the '{@link #getCallTime() <em>Call Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCallTime()
	 * @generated
	 * @ordered
	 */
	protected static final double CALL_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getCallTime() <em>Call Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCallTime()
	 * @generated
	 * @ordered
	 */
	protected double callTime = CALL_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getReturnTime() <em>Return Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReturnTime()
	 * @generated
	 * @ordered
	 */
	protected static final double RETURN_TIME_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getReturnTime() <em>Return Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getReturnTime()
	 * @generated
	 * @ordered
	 */
	protected double returnTime = RETURN_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #getCallOverhead() <em>Call Overhead</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCallOverhead()
	 * @generated
	 * @ordered
	 */
	protected static final double CALL_OVERHEAD_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getCallOverhead() <em>Call Overhead</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCallOverhead()
	 * @generated
	 * @ordered
	 */
	protected double callOverhead = CALL_OVERHEAD_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCCallerCalleeInvocationInfoImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return TracePackage.eINSTANCE.getTRCCallerCalleeInvocationInfo();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getCallTime() {
		return callTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCallTime(double newCallTime) {
		double oldCallTime = callTime;
		callTime = newCallTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__CALL_TIME, oldCallTime, callTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getReturnTime() {
		return returnTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setReturnTime(double newReturnTime) {
		double oldReturnTime = returnTime;
		returnTime = newReturnTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__RETURN_TIME, oldReturnTime, returnTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public double getCallOverhead() {
		return callOverhead;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCallOverhead(double newCallOverhead) {
		double oldCallOverhead = callOverhead;
		callOverhead = newCallOverhead;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__CALL_OVERHEAD, oldCallOverhead, callOverhead));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__METHOD:
					if (method != null)
						msgs = ((InternalEObject)method).eInverseRemove(this, TracePackage.TRC_METHOD__INVOCATIONS, TRCMethod.class, msgs);
					return basicSetMethod((TRCMethod)otherEnd, msgs);
				case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__INVOKED_BY:
					if (invokedBy != null)
						msgs = ((InternalEObject)invokedBy).eInverseRemove(this, TracePackage.TRC_METHOD_INVOCATION__INVOKES, TRCMethodInvocation.class, msgs);
					return basicSetInvokedBy((TRCMethodInvocation)otherEnd, msgs);
				case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__INVOKES:
					return ((InternalEList)getInvokes()).basicAdd(otherEnd, msgs);
				case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__PROCESS:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__PROCESS, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__METHOD:
					return basicSetMethod(null, msgs);
				case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__INVOKED_BY:
					return basicSetInvokedBy(null, msgs);
				case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__INVOKES:
					return ((InternalEList)getInvokes()).basicRemove(otherEnd, msgs);
				case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__PROCESS:
					return eBasicSetContainer(null, TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__PROCESS, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__PROCESS:
					return ((InternalEObject)eContainer).eInverseRemove(this, TracePackage.TRC_PROCESS__INVOCATIONS, TRCProcess.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__METHOD:
				if (resolve) return getMethod();
				return basicGetMethod();
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__INVOKED_BY:
				if (resolve) return getInvokedBy();
				return basicGetInvokedBy();
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__INVOKES:
				return getInvokes();
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__THREAD:
				if (resolve) return getThread();
				return basicGetThread();
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__PROCESS:
				return getProcess();
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__OWNING_OBJECT:
				if (resolve) return getOwningObject();
				return basicGetOwningObject();
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__STACK_DEPTH:
				return new Short(getStackDepth());
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__ENTRY_TIME:
				return new Double(getEntryTime());
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__EXIT_TIME:
				return new Double(getExitTime());
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__TICKET:
				return new Long(getTicket());
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__OVERHEAD:
				return new Double(getOverhead());
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__CALLER_LINE_NO:
				return new Integer(getCallerLineNo());
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__CPU_TIME:
				return new Double(getCpuTime());
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__CALL_TIME:
				return new Double(getCallTime());
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__RETURN_TIME:
				return new Double(getReturnTime());
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__CALL_OVERHEAD:
				return new Double(getCallOverhead());
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__METHOD:
				setMethod((TRCMethod)newValue);
				return;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__INVOKED_BY:
				setInvokedBy((TRCMethodInvocation)newValue);
				return;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__INVOKES:
				getInvokes().clear();
				getInvokes().addAll((Collection)newValue);
				return;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__THREAD:
				setThread((TRCThread)newValue);
				return;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__PROCESS:
				setProcess((TRCProcess)newValue);
				return;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__OWNING_OBJECT:
				setOwningObject((TRCTraceObject)newValue);
				return;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__STACK_DEPTH:
				setStackDepth(((Short)newValue).shortValue());
				return;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__ENTRY_TIME:
				setEntryTime(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__EXIT_TIME:
				setExitTime(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__TICKET:
				setTicket(((Long)newValue).longValue());
				return;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__OVERHEAD:
				setOverhead(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__CALLER_LINE_NO:
				setCallerLineNo(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__CPU_TIME:
				setCpuTime(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__CALL_TIME:
				setCallTime(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__RETURN_TIME:
				setReturnTime(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__CALL_OVERHEAD:
				setCallOverhead(((Double)newValue).doubleValue());
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__METHOD:
				setMethod((TRCMethod)null);
				return;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__INVOKED_BY:
				setInvokedBy((TRCMethodInvocation)null);
				return;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__INVOKES:
				getInvokes().clear();
				return;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__THREAD:
				setThread((TRCThread)null);
				return;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__PROCESS:
				setProcess((TRCProcess)null);
				return;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__OWNING_OBJECT:
				setOwningObject((TRCTraceObject)null);
				return;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__STACK_DEPTH:
				setStackDepth(STACK_DEPTH_EDEFAULT);
				return;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__ENTRY_TIME:
				setEntryTime(ENTRY_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__EXIT_TIME:
				setExitTime(EXIT_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__TICKET:
				setTicket(TICKET_EDEFAULT);
				return;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__OVERHEAD:
				setOverhead(OVERHEAD_EDEFAULT);
				return;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__CALLER_LINE_NO:
				setCallerLineNo(CALLER_LINE_NO_EDEFAULT);
				return;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__CPU_TIME:
				setCpuTime(CPU_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__CALL_TIME:
				setCallTime(CALL_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__RETURN_TIME:
				setReturnTime(RETURN_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__CALL_OVERHEAD:
				setCallOverhead(CALL_OVERHEAD_EDEFAULT);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__METHOD:
				return method != null;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__INVOKED_BY:
				return invokedBy != null;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__INVOKES:
				return invokes != null && !invokes.isEmpty();
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__THREAD:
				return thread != null;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__PROCESS:
				return getProcess() != null;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__OWNING_OBJECT:
				return owningObject != null;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__STACK_DEPTH:
				return stackDepth != STACK_DEPTH_EDEFAULT;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__ENTRY_TIME:
				return entryTime != ENTRY_TIME_EDEFAULT;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__EXIT_TIME:
				return exitTime != EXIT_TIME_EDEFAULT;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__TICKET:
				return ticket != TICKET_EDEFAULT;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__OVERHEAD:
				return overhead != OVERHEAD_EDEFAULT;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__CALLER_LINE_NO:
				return callerLineNo != CALLER_LINE_NO_EDEFAULT;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__CPU_TIME:
				return cpuTime != CPU_TIME_EDEFAULT;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__CALL_TIME:
				return callTime != CALL_TIME_EDEFAULT;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__RETURN_TIME:
				return returnTime != RETURN_TIME_EDEFAULT;
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO__CALL_OVERHEAD:
				return callOverhead != CALL_OVERHEAD_EDEFAULT;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (callTime: ");
		result.append(callTime);
		result.append(", returnTime: ");
		result.append(returnTime);
		result.append(", callOverhead: ");
		result.append(callOverhead);
		result.append(')');
		return result.toString();
	}

} //TRCCallerCalleeInvocationInfoImpl
