/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TRCMethodWithLLDataImpl.java,v 1.9 2004/12/03 17:22:57 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCLLData;
import org.eclipse.hyades.models.trace.TRCMethodWithLLData;
import org.eclipse.hyades.models.trace.TRCSignatureNotation;
import org.eclipse.hyades.models.trace.TRCSourceInfo;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Method With LL Data</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCMethodWithLLDataImpl#getLLData <em>LL Data</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCMethodWithLLDataImpl extends TRCMethodImpl implements TRCMethodWithLLData {
	/**
	 * The cached value of the '{@link #getLLData() <em>LL Data</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLLData()
	 * @generated
	 * @ordered
	 */
	protected TRCLLData llData = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCMethodWithLLDataImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return TracePackage.eINSTANCE.getTRCMethodWithLLData();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCLLData getLLData() {
		return llData;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetLLData(TRCLLData newLLData, NotificationChain msgs) {
		TRCLLData oldLLData = llData;
		llData = newLLData;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, TracePackage.TRC_METHOD_WITH_LL_DATA__LL_DATA, oldLLData, newLLData);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLLData(TRCLLData newLLData) {
		if (newLLData != llData) {
			NotificationChain msgs = null;
			if (llData != null)
				msgs = ((InternalEObject)llData).eInverseRemove(this, TracePackage.TRCLL_DATA__METHOD, TRCLLData.class, msgs);
			if (newLLData != null)
				msgs = ((InternalEObject)newLLData).eInverseAdd(this, TracePackage.TRCLL_DATA__METHOD, TRCLLData.class, msgs);
			msgs = basicSetLLData(newLLData, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_METHOD_WITH_LL_DATA__LL_DATA, newLLData, newLLData));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_METHOD_WITH_LL_DATA__DEFINING_CLASS:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, TracePackage.TRC_METHOD_WITH_LL_DATA__DEFINING_CLASS, msgs);
				case TracePackage.TRC_METHOD_WITH_LL_DATA__INVOCATIONS:
					return ((InternalEList)getInvocations()).basicAdd(otherEnd, msgs);
				case TracePackage.TRC_METHOD_WITH_LL_DATA__LL_DATA:
					if (llData != null)
						msgs = ((InternalEObject)llData).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - TracePackage.TRC_METHOD_WITH_LL_DATA__LL_DATA, null, msgs);
					return basicSetLLData((TRCLLData)otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_METHOD_WITH_LL_DATA__DEFINING_CLASS:
					return eBasicSetContainer(null, TracePackage.TRC_METHOD_WITH_LL_DATA__DEFINING_CLASS, msgs);
				case TracePackage.TRC_METHOD_WITH_LL_DATA__INVOCATIONS:
					return ((InternalEList)getInvocations()).basicRemove(otherEnd, msgs);
				case TracePackage.TRC_METHOD_WITH_LL_DATA__LL_DATA:
					return basicSetLLData(null, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case TracePackage.TRC_METHOD_WITH_LL_DATA__DEFINING_CLASS:
					return ((InternalEObject)eContainer).eInverseRemove(this, TracePackage.TRC_CLASS__METHODS, TRCClass.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_METHOD_WITH_LL_DATA__ID:
				return new Integer(getId());
			case TracePackage.TRC_METHOD_WITH_LL_DATA__NAME:
				return getName();
			case TracePackage.TRC_METHOD_WITH_LL_DATA__SIGNATURE:
				return getSignature();
			case TracePackage.TRC_METHOD_WITH_LL_DATA__MODIFIER:
				return new Integer(getModifier());
			case TracePackage.TRC_METHOD_WITH_LL_DATA__NOTATION:
				return getNotation();
			case TracePackage.TRC_METHOD_WITH_LL_DATA__LINE_NO:
				return new Integer(getLineNo());
			case TracePackage.TRC_METHOD_WITH_LL_DATA__BASE_TIME:
				return new Double(getBaseTime());
			case TracePackage.TRC_METHOD_WITH_LL_DATA__CUMULATIVE_TIME:
				return new Double(getCumulativeTime());
			case TracePackage.TRC_METHOD_WITH_LL_DATA__CALLS:
				return new Integer(getCalls());
			case TracePackage.TRC_METHOD_WITH_LL_DATA__TOTAL_CPU_TIME:
				return new Double(getTotalCpuTime());
			case TracePackage.TRC_METHOD_WITH_LL_DATA__DEFINING_CLASS:
				return getDefiningClass();
			case TracePackage.TRC_METHOD_WITH_LL_DATA__INVOCATIONS:
				return getInvocations();
			case TracePackage.TRC_METHOD_WITH_LL_DATA__SOURCE_INFO:
				if (resolve) return getSourceInfo();
				return basicGetSourceInfo();
			case TracePackage.TRC_METHOD_WITH_LL_DATA__LL_DATA:
				return getLLData();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_METHOD_WITH_LL_DATA__ID:
				setId(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_METHOD_WITH_LL_DATA__NAME:
				setName((String)newValue);
				return;
			case TracePackage.TRC_METHOD_WITH_LL_DATA__SIGNATURE:
				setSignature((String)newValue);
				return;
			case TracePackage.TRC_METHOD_WITH_LL_DATA__MODIFIER:
				setModifier(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_METHOD_WITH_LL_DATA__NOTATION:
				setNotation((TRCSignatureNotation)newValue);
				return;
			case TracePackage.TRC_METHOD_WITH_LL_DATA__LINE_NO:
				setLineNo(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_METHOD_WITH_LL_DATA__BASE_TIME:
				setBaseTime(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_METHOD_WITH_LL_DATA__CUMULATIVE_TIME:
				setCumulativeTime(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_METHOD_WITH_LL_DATA__CALLS:
				setCalls(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_METHOD_WITH_LL_DATA__TOTAL_CPU_TIME:
				setTotalCpuTime(((Double)newValue).doubleValue());
				return;
			case TracePackage.TRC_METHOD_WITH_LL_DATA__DEFINING_CLASS:
				setDefiningClass((TRCClass)newValue);
				return;
			case TracePackage.TRC_METHOD_WITH_LL_DATA__INVOCATIONS:
				getInvocations().clear();
				getInvocations().addAll((Collection)newValue);
				return;
			case TracePackage.TRC_METHOD_WITH_LL_DATA__SOURCE_INFO:
				setSourceInfo((TRCSourceInfo)newValue);
				return;
			case TracePackage.TRC_METHOD_WITH_LL_DATA__LL_DATA:
				setLLData((TRCLLData)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_METHOD_WITH_LL_DATA__ID:
				setId(ID_EDEFAULT);
				return;
			case TracePackage.TRC_METHOD_WITH_LL_DATA__NAME:
				setName(NAME_EDEFAULT);
				return;
			case TracePackage.TRC_METHOD_WITH_LL_DATA__SIGNATURE:
				setSignature(SIGNATURE_EDEFAULT);
				return;
			case TracePackage.TRC_METHOD_WITH_LL_DATA__MODIFIER:
				setModifier(MODIFIER_EDEFAULT);
				return;
			case TracePackage.TRC_METHOD_WITH_LL_DATA__NOTATION:
				setNotation(NOTATION_EDEFAULT);
				return;
			case TracePackage.TRC_METHOD_WITH_LL_DATA__LINE_NO:
				setLineNo(LINE_NO_EDEFAULT);
				return;
			case TracePackage.TRC_METHOD_WITH_LL_DATA__BASE_TIME:
				setBaseTime(BASE_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_METHOD_WITH_LL_DATA__CUMULATIVE_TIME:
				setCumulativeTime(CUMULATIVE_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_METHOD_WITH_LL_DATA__CALLS:
				setCalls(CALLS_EDEFAULT);
				return;
			case TracePackage.TRC_METHOD_WITH_LL_DATA__TOTAL_CPU_TIME:
				setTotalCpuTime(TOTAL_CPU_TIME_EDEFAULT);
				return;
			case TracePackage.TRC_METHOD_WITH_LL_DATA__DEFINING_CLASS:
				setDefiningClass((TRCClass)null);
				return;
			case TracePackage.TRC_METHOD_WITH_LL_DATA__INVOCATIONS:
				getInvocations().clear();
				return;
			case TracePackage.TRC_METHOD_WITH_LL_DATA__SOURCE_INFO:
				setSourceInfo((TRCSourceInfo)null);
				return;
			case TracePackage.TRC_METHOD_WITH_LL_DATA__LL_DATA:
				setLLData((TRCLLData)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_METHOD_WITH_LL_DATA__ID:
				return id != ID_EDEFAULT;
			case TracePackage.TRC_METHOD_WITH_LL_DATA__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case TracePackage.TRC_METHOD_WITH_LL_DATA__SIGNATURE:
				return SIGNATURE_EDEFAULT == null ? signature != null : !SIGNATURE_EDEFAULT.equals(signature);
			case TracePackage.TRC_METHOD_WITH_LL_DATA__MODIFIER:
				return modifier != MODIFIER_EDEFAULT;
			case TracePackage.TRC_METHOD_WITH_LL_DATA__NOTATION:
				return notation != NOTATION_EDEFAULT;
			case TracePackage.TRC_METHOD_WITH_LL_DATA__LINE_NO:
				return lineNo != LINE_NO_EDEFAULT;
			case TracePackage.TRC_METHOD_WITH_LL_DATA__BASE_TIME:
				return baseTime != BASE_TIME_EDEFAULT;
			case TracePackage.TRC_METHOD_WITH_LL_DATA__CUMULATIVE_TIME:
				return cumulativeTime != CUMULATIVE_TIME_EDEFAULT;
			case TracePackage.TRC_METHOD_WITH_LL_DATA__CALLS:
				return calls != CALLS_EDEFAULT;
			case TracePackage.TRC_METHOD_WITH_LL_DATA__TOTAL_CPU_TIME:
				return totalCpuTime != TOTAL_CPU_TIME_EDEFAULT;
			case TracePackage.TRC_METHOD_WITH_LL_DATA__DEFINING_CLASS:
				return getDefiningClass() != null;
			case TracePackage.TRC_METHOD_WITH_LL_DATA__INVOCATIONS:
				return invocations != null && !invocations.isEmpty();
			case TracePackage.TRC_METHOD_WITH_LL_DATA__SOURCE_INFO:
				return sourceInfo != null;
			case TracePackage.TRC_METHOD_WITH_LL_DATA__LL_DATA:
				return llData != null;
		}
		return eDynamicIsSet(eFeature);
	}

} //TRCMethodWithLLDataImpl
