/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: TraceSwitch.java,v 1.16 2004/12/03 17:22:57 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.trace.util;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.AbstractTRCCollectionBoundary;
import org.eclipse.hyades.models.hierarchy.AbstractTRCProcess;
import org.eclipse.hyades.models.trace.*;

import org.eclipse.hyades.models.trace.TRCAggregatedMethodInvocation;
import org.eclipse.hyades.models.trace.TRCAggregatedObjectReference;
import org.eclipse.hyades.models.trace.TRCArrayClass;
import org.eclipse.hyades.models.trace.TRCCallerCalleeInvocationInfo;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCClassLoader;
import org.eclipse.hyades.models.trace.TRCCollectionBoundary;
import org.eclipse.hyades.models.trace.TRCFullHeapObject;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCHeapDump;
import org.eclipse.hyades.models.trace.TRCHeapObject;
import org.eclipse.hyades.models.trace.TRCHeapRoot;
import org.eclipse.hyades.models.trace.TRCInputOutputContainer;
import org.eclipse.hyades.models.trace.TRCLLData;
import org.eclipse.hyades.models.trace.TRCLineCoverageData;
import org.eclipse.hyades.models.trace.TRCLinePerformanceData;
import org.eclipse.hyades.models.trace.TRCLockAccess;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCMethodWithLLData;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCObjectAllocationSite;
import org.eclipse.hyades.models.trace.TRCObjectReference;
import org.eclipse.hyades.models.trace.TRCObjectValue;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TRCSourceInfo;
import org.eclipse.hyades.models.trace.TRCSourceInfoWithLLData;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCThreadDeadEvent;
import org.eclipse.hyades.models.trace.TRCThreadEvent;
import org.eclipse.hyades.models.trace.TRCThreadRunningEvent;
import org.eclipse.hyades.models.trace.TRCThreadSleepingEvent;
import org.eclipse.hyades.models.trace.TRCThreadWaitingForLockEvent;
import org.eclipse.hyades.models.trace.TRCThreadWaitingForObjectEvent;
import org.eclipse.hyades.models.trace.TRCTraceObject;
import org.eclipse.hyades.models.trace.TRCTypedObjectValue;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see org.eclipse.hyades.models.trace.TracePackage
 * @generated
 */
public class TraceSwitch {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static TracePackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TraceSwitch() {
		if (modelPackage == null) {
			modelPackage = TracePackage.eINSTANCE;
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	public Object doSwitch(EObject theEObject) {
		return doSwitch(theEObject.eClass(), theEObject);
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected Object doSwitch(EClass theEClass, EObject theEObject) {
		if (theEClass.eContainer() == modelPackage) {
			return doSwitch(theEClass.getClassifierID(), theEObject);
		}
		else {
			List eSuperTypes = theEClass.getESuperTypes();
			return
				eSuperTypes.isEmpty() ?
					defaultCase(theEObject) :
					doSwitch((EClass)eSuperTypes.get(0), theEObject);
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected Object doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
			case TracePackage.TRC_OBJECT: {
				TRCObject trcObject = (TRCObject)theEObject;
				Object result = caseTRCObject(trcObject);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_CLASS: {
				TRCClass trcClass = (TRCClass)theEObject;
				Object result = caseTRCClass(trcClass);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_METHOD_INVOCATION: {
				TRCMethodInvocation trcMethodInvocation = (TRCMethodInvocation)theEObject;
				Object result = caseTRCMethodInvocation(trcMethodInvocation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_PROCESS: {
				TRCProcess trcProcess = (TRCProcess)theEObject;
				Object result = caseTRCProcess(trcProcess);
				if (result == null) result = caseAbstractTRCProcess(trcProcess);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_THREAD: {
				TRCThread trcThread = (TRCThread)theEObject;
				Object result = caseTRCThread(trcThread);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_METHOD: {
				TRCMethod trcMethod = (TRCMethod)theEObject;
				Object result = caseTRCMethod(trcMethod);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_PACKAGE: {
				TRCPackage trcPackage = (TRCPackage)theEObject;
				Object result = caseTRCPackage(trcPackage);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_COLLECTION_BOUNDARY: {
				TRCCollectionBoundary trcCollectionBoundary = (TRCCollectionBoundary)theEObject;
				Object result = caseTRCCollectionBoundary(trcCollectionBoundary);
				if (result == null) result = caseAbstractTRCCollectionBoundary(trcCollectionBoundary);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_CLASS_LOADER: {
				TRCClassLoader trcClassLoader = (TRCClassLoader)theEObject;
				Object result = caseTRCClassLoader(trcClassLoader);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_SOURCE_INFO: {
				TRCSourceInfo trcSourceInfo = (TRCSourceInfo)theEObject;
				Object result = caseTRCSourceInfo(trcSourceInfo);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_HEAP_OBJECT: {
				TRCHeapObject trcHeapObject = (TRCHeapObject)theEObject;
				Object result = caseTRCHeapObject(trcHeapObject);
				if (result == null) result = caseTRCObject(trcHeapObject);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_FULL_TRACE_OBJECT: {
				TRCFullTraceObject trcFullTraceObject = (TRCFullTraceObject)theEObject;
				Object result = caseTRCFullTraceObject(trcFullTraceObject);
				if (result == null) result = caseTRCTraceObject(trcFullTraceObject);
				if (result == null) result = caseTRCObject(trcFullTraceObject);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_TRACE_OBJECT: {
				TRCTraceObject trcTraceObject = (TRCTraceObject)theEObject;
				Object result = caseTRCTraceObject(trcTraceObject);
				if (result == null) result = caseTRCObject(trcTraceObject);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_FULL_HEAP_OBJECT: {
				TRCFullHeapObject trcFullHeapObject = (TRCFullHeapObject)theEObject;
				Object result = caseTRCFullHeapObject(trcFullHeapObject);
				if (result == null) result = caseTRCHeapObject(trcFullHeapObject);
				if (result == null) result = caseTRCObject(trcFullHeapObject);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_OBJECT_REFERENCE: {
				TRCObjectReference trcObjectReference = (TRCObjectReference)theEObject;
				Object result = caseTRCObjectReference(trcObjectReference);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_HEAP_DUMP: {
				TRCHeapDump trcHeapDump = (TRCHeapDump)theEObject;
				Object result = caseTRCHeapDump(trcHeapDump);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_AGGREGATED_METHOD_INVOCATION: {
				TRCAggregatedMethodInvocation trcAggregatedMethodInvocation = (TRCAggregatedMethodInvocation)theEObject;
				Object result = caseTRCAggregatedMethodInvocation(trcAggregatedMethodInvocation);
				if (result == null) result = caseTRCMethodInvocation(trcAggregatedMethodInvocation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_FULL_METHOD_INVOCATION: {
				TRCFullMethodInvocation trcFullMethodInvocation = (TRCFullMethodInvocation)theEObject;
				Object result = caseTRCFullMethodInvocation(trcFullMethodInvocation);
				if (result == null) result = caseTRCMethodInvocation(trcFullMethodInvocation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_HEAP_ROOT: {
				TRCHeapRoot trcHeapRoot = (TRCHeapRoot)theEObject;
				Object result = caseTRCHeapRoot(trcHeapRoot);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_ARRAY_CLASS: {
				TRCArrayClass trcArrayClass = (TRCArrayClass)theEObject;
				Object result = caseTRCArrayClass(trcArrayClass);
				if (result == null) result = caseTRCClass(trcArrayClass);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_AGGREGATED_OBJECT_REFERENCE: {
				TRCAggregatedObjectReference trcAggregatedObjectReference = (TRCAggregatedObjectReference)theEObject;
				Object result = caseTRCAggregatedObjectReference(trcAggregatedObjectReference);
				if (result == null) result = caseTRCObjectReference(trcAggregatedObjectReference);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_THREAD_EVENT: {
				TRCThreadEvent trcThreadEvent = (TRCThreadEvent)theEObject;
				Object result = caseTRCThreadEvent(trcThreadEvent);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_THREAD_SLEEPING_EVENT: {
				TRCThreadSleepingEvent trcThreadSleepingEvent = (TRCThreadSleepingEvent)theEObject;
				Object result = caseTRCThreadSleepingEvent(trcThreadSleepingEvent);
				if (result == null) result = caseTRCThreadEvent(trcThreadSleepingEvent);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_THREAD_WAITING_FOR_OBJECT_EVENT: {
				TRCThreadWaitingForObjectEvent trcThreadWaitingForObjectEvent = (TRCThreadWaitingForObjectEvent)theEObject;
				Object result = caseTRCThreadWaitingForObjectEvent(trcThreadWaitingForObjectEvent);
				if (result == null) result = caseTRCThreadEvent(trcThreadWaitingForObjectEvent);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_THREAD_WAITING_FOR_LOCK_EVENT: {
				TRCThreadWaitingForLockEvent trcThreadWaitingForLockEvent = (TRCThreadWaitingForLockEvent)theEObject;
				Object result = caseTRCThreadWaitingForLockEvent(trcThreadWaitingForLockEvent);
				if (result == null) result = caseTRCThreadEvent(trcThreadWaitingForLockEvent);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_THREAD_RUNNING_EVENT: {
				TRCThreadRunningEvent trcThreadRunningEvent = (TRCThreadRunningEvent)theEObject;
				Object result = caseTRCThreadRunningEvent(trcThreadRunningEvent);
				if (result == null) result = caseTRCThreadEvent(trcThreadRunningEvent);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_THREAD_DEAD_EVENT: {
				TRCThreadDeadEvent trcThreadDeadEvent = (TRCThreadDeadEvent)theEObject;
				Object result = caseTRCThreadDeadEvent(trcThreadDeadEvent);
				if (result == null) result = caseTRCThreadEvent(trcThreadDeadEvent);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_METHOD_WITH_LL_DATA: {
				TRCMethodWithLLData trcMethodWithLLData = (TRCMethodWithLLData)theEObject;
				Object result = caseTRCMethodWithLLData(trcMethodWithLLData);
				if (result == null) result = caseTRCMethod(trcMethodWithLLData);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_SOURCE_INFO_WITH_LL_DATA: {
				TRCSourceInfoWithLLData trcSourceInfoWithLLData = (TRCSourceInfoWithLLData)theEObject;
				Object result = caseTRCSourceInfoWithLLData(trcSourceInfoWithLLData);
				if (result == null) result = caseTRCSourceInfo(trcSourceInfoWithLLData);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_LINE_COVERAGE_DATA: {
				TRCLineCoverageData trcLineCoverageData = (TRCLineCoverageData)theEObject;
				Object result = caseTRCLineCoverageData(trcLineCoverageData);
				if (result == null) result = caseTRCLLData(trcLineCoverageData);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_OBJECT_VALUE: {
				TRCObjectValue trcObjectValue = (TRCObjectValue)theEObject;
				Object result = caseTRCObjectValue(trcObjectValue);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_INPUT_OUTPUT_ENTRY: {
				Map.Entry trcInputOutputEntry = (Map.Entry)theEObject;
				Object result = caseTRCInputOutputEntry(trcInputOutputEntry);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_INPUT_OUTPUT_CONTAINER: {
				TRCInputOutputContainer trcInputOutputContainer = (TRCInputOutputContainer)theEObject;
				Object result = caseTRCInputOutputContainer(trcInputOutputContainer);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_CALLER_CALLEE_INVOCATION_INFO: {
				TRCCallerCalleeInvocationInfo trcCallerCalleeInvocationInfo = (TRCCallerCalleeInvocationInfo)theEObject;
				Object result = caseTRCCallerCalleeInvocationInfo(trcCallerCalleeInvocationInfo);
				if (result == null) result = caseTRCFullMethodInvocation(trcCallerCalleeInvocationInfo);
				if (result == null) result = caseTRCMethodInvocation(trcCallerCalleeInvocationInfo);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_TYPED_OBJECT_VALUE: {
				TRCTypedObjectValue trcTypedObjectValue = (TRCTypedObjectValue)theEObject;
				Object result = caseTRCTypedObjectValue(trcTypedObjectValue);
				if (result == null) result = caseTRCObjectValue(trcTypedObjectValue);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_MTHD_LCK_ACC_ENTRY: {
				Map.Entry trcMthdLckAccEntry = (Map.Entry)theEObject;
				Object result = caseTRCMthdLckAccEntry(trcMthdLckAccEntry);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_LOCK_ACCESS: {
				TRCLockAccess trcLockAccess = (TRCLockAccess)theEObject;
				Object result = caseTRCLockAccess(trcLockAccess);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_LINE_PERFORMANCE_DATA: {
				TRCLinePerformanceData trcLinePerformanceData = (TRCLinePerformanceData)theEObject;
				Object result = caseTRCLinePerformanceData(trcLinePerformanceData);
				if (result == null) result = caseTRCLineCoverageData(trcLinePerformanceData);
				if (result == null) result = caseTRCLLData(trcLinePerformanceData);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_OBJECT_ALLOCATION_SITES_ENTRY: {
				Map.Entry trcObjectAllocationSitesEntry = (Map.Entry)theEObject;
				Object result = caseTRCObjectAllocationSitesEntry(trcObjectAllocationSitesEntry);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_OBJECT_ALLOCATION_SITE: {
				TRCObjectAllocationSite trcObjectAllocationSite = (TRCObjectAllocationSite)theEObject;
				Object result = caseTRCObjectAllocationSite(trcObjectAllocationSite);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TracePackage.TRC_THREAD_DEAD_LOCK_EVENT: {
				TRCThreadDeadLockEvent trcThreadDeadLockEvent = (TRCThreadDeadLockEvent)theEObject;
				Object result = caseTRCThreadDeadLockEvent(trcThreadDeadLockEvent);
				if (result == null) result = caseTRCThreadWaitingForLockEvent(trcThreadDeadLockEvent);
				if (result == null) result = caseTRCThreadEvent(trcThreadDeadLockEvent);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Object</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Object</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCObject(TRCObject object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Class</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Class</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCClass(TRCClass object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Method Invocation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Method Invocation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCMethodInvocation(TRCMethodInvocation object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Process</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Process</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCProcess(TRCProcess object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Thread</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Thread</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCThread(TRCThread object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Method</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Method</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCMethod(TRCMethod object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Package</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Package</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCPackage(TRCPackage object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Collection Boundary</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Collection Boundary</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCCollectionBoundary(TRCCollectionBoundary object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Class Loader</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Class Loader</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCClassLoader(TRCClassLoader object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Source Info</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Source Info</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCSourceInfo(TRCSourceInfo object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Heap Object</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Heap Object</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCHeapObject(TRCHeapObject object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Full Trace Object</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Full Trace Object</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCFullTraceObject(TRCFullTraceObject object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Trace Object</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Trace Object</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCTraceObject(TRCTraceObject object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Full Heap Object</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Full Heap Object</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCFullHeapObject(TRCFullHeapObject object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Object Reference</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Object Reference</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCObjectReference(TRCObjectReference object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Heap Dump</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Heap Dump</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCHeapDump(TRCHeapDump object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Aggregated Method Invocation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Aggregated Method Invocation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCAggregatedMethodInvocation(TRCAggregatedMethodInvocation object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Full Method Invocation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Full Method Invocation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCFullMethodInvocation(TRCFullMethodInvocation object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Heap Root</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Heap Root</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCHeapRoot(TRCHeapRoot object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Array Class</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Array Class</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCArrayClass(TRCArrayClass object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Aggregated Object Reference</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Aggregated Object Reference</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCAggregatedObjectReference(TRCAggregatedObjectReference object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Thread Event</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Thread Event</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCThreadEvent(TRCThreadEvent object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Thread Sleeping Event</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Thread Sleeping Event</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCThreadSleepingEvent(TRCThreadSleepingEvent object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Thread Waiting For Object Event</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Thread Waiting For Object Event</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCThreadWaitingForObjectEvent(TRCThreadWaitingForObjectEvent object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Thread Waiting For Lock Event</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Thread Waiting For Lock Event</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCThreadWaitingForLockEvent(TRCThreadWaitingForLockEvent object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Thread Running Event</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Thread Running Event</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCThreadRunningEvent(TRCThreadRunningEvent object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Thread Dead Event</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Thread Dead Event</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCThreadDeadEvent(TRCThreadDeadEvent object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Method With LL Data</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Method With LL Data</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCMethodWithLLData(TRCMethodWithLLData object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRCLL Data</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRCLL Data</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCLLData(TRCLLData object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Source Info With LL Data</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Source Info With LL Data</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCSourceInfoWithLLData(TRCSourceInfoWithLLData object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Line Coverage Data</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Line Coverage Data</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCLineCoverageData(TRCLineCoverageData object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Object Value</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Object Value</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCObjectValue(TRCObjectValue object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Input Output Entry</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Input Output Entry</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCInputOutputEntry(Map.Entry object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Input Output Container</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Input Output Container</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCInputOutputContainer(TRCInputOutputContainer object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Caller Callee Invocation Info</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Caller Callee Invocation Info</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCCallerCalleeInvocationInfo(TRCCallerCalleeInvocationInfo object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Typed Object Value</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Typed Object Value</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCTypedObjectValue(TRCTypedObjectValue object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Mthd Lck Acc Entry</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Mthd Lck Acc Entry</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCMthdLckAccEntry(Map.Entry object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Lock Access</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Lock Access</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCLockAccess(TRCLockAccess object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Line Performance Data</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Line Performance Data</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCLinePerformanceData(TRCLinePerformanceData object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Object Allocation Sites Entry</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Object Allocation Sites Entry</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCObjectAllocationSitesEntry(Map.Entry object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Object Allocation Site</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Object Allocation Site</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCObjectAllocationSite(TRCObjectAllocationSite object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>TRC Thread Dead Lock Event</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>TRC Thread Dead Lock Event</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseTRCThreadDeadLockEvent(TRCThreadDeadLockEvent object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Abstract TRC Process</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Abstract TRC Process</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseAbstractTRCProcess(AbstractTRCProcess object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Abstract TRC Collection Boundary</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Abstract TRC Collection Boundary</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseAbstractTRCCollectionBoundary(AbstractTRCCollectionBoundary object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	public Object defaultCase(EObject object) {
		return null;
	}

} //TraceSwitch
