/*******************************************************************************
 * Copyright (c) 2000, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.execution.runtime.datapool;

/**
 * Each variable in a datapool contains a specific type data and this
 * class represents the types that can be readily handled.  The type 
 * information is primarily advisory, variables by definition are <b>not</b>
 * strongly typed.  The type information allows the datapool editor the 
 * ability to flag data that may have been incorrectly specified and 
 * improves the ease of editing values in the datapool.  For instance 
 * specifying a {@link #TYPE_ENUMERATION} allows the editor to use an
 * editable combobox for manually changing a value rather then requiring
 * the user to get the spelling correct for each value in the available
 * value set.
 */
public interface IDatapoolSuggestedType
{
	
	/** The type of a simple <code>String</code> object. */
	public static final int TYPE_STRING = 0;
	/** The type of a scalar value. */
	public static final int TYPE_NUMBER = 1;
	/** The type of a boolean value. */
	public static final int TYPE_BOOLEAN = 2;
	/** The type of an enumeration type value. */
	public static final int TYPE_ENUMERATION = 3;
	/** The type specification for a complex object, must be a serializable class. */
	public static final int TYPE_COMPLEX = 4;
	
	/**
	 * One of the predefined type formats:
	 * <ul>
	 * <li>{@link #TYPE_STRING}
	 * <li>{@link #TYPE_NUMBER}
	 * <li>{@link #TYPE_BOOLEAN}
	 * <li>{@link #TYPE_ENUMERATION}
	 * <li>{@link #TYPE_COMPLEX}
	 * </ul>
	 * 
	 * @return	One of the predefined type values.
	 * 
	 * @see #TYPE_STRING
	 * @see #TYPE_NUMBER
	 * @see #TYPE_BOOLEAN
	 * @see #TYPE_ENUMERATION
	 * @see #TYPE_COMPLEX
	 */
	public int getSuggestedType();
	
	/**
	 * The set of enumerations literals associated with a
	 * {@link #TYPE_ENUMERATION enumeration} type.  If the
	 * {@link #getSuggestedType() type} is not set to 
	 * {@link #TYPE_ENUMERATION enumeration} type then an 
	 * appropriate <code>DatapoolException</code> is thrown.
	 * 
	 * @return	The set of enumerations literals associated with a
	 *			{@link #TYPE_ENUMERATION enumeration} type.
	 * 
	 * @see #TYPE_ENUMERATION
	 */
	public String[] getEnumerationLiterals();
	
	/**
	 * The value class name associated with a variable.
	 * 
	 * @return	The value class name associated with a
	 *			variable.
	 * 
	 */
	public String getSuggestedClassName();
	
}
