/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.actions.internal;

import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.views.adapter.internal.PatternViewer;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

/**
*
*/
public class OpenPatternViewAction extends OpenTraceViewAction
{
/**
 * OpenReferencePatternView constructor comment.
 * @param label java.lang.String
 */
public OpenPatternViewAction() {
	super("");
}
/**
 * OpenReferencePatternView constructor comment.
 * @param label java.lang.String
 */
public OpenPatternViewAction(String label) {
	super(label);
}
/**
 * OpenReferencePatternView constructor comment.
 * @param label java.lang.String
 * @param image com.ibm.jface.parts.IImage
 */
public OpenPatternViewAction(String label, ImageDescriptor image) {
	super(label, image);
}

/**
 * Insert the method's description here.
 * Creation date: (12/4/2000 2:21:48 PM)
 * @return boolean
 */ 
public void run()
{
	IWorkbenchWindow window = UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
			
	try
	{
		IWorkbenchPage persp = UIPlugin.getActivePage();
		PatternViewer view = (PatternViewer)persp.showView("org.eclipse.hyades.trace.views.adapter.internal.PatternViewer");
		   
		if(view != null)
			 view.addViewPage(getMofObject(), true);                       
	}
	catch(Exception e)
	{
		String msg = TraceUIPlugin.getString("STR_OPEN_PATTERN_ERROR_");                   

		Status err = new Status(Status.WARNING, ResourcesPlugin.PI_RESOURCES, IResourceStatus.INTERNAL_ERROR, msg, null );  

		ErrorDialog.openError(window.getShell(),
				msg,
				e.toString(),   // no special message
				err); 
		
		e.printStackTrace(); 
	}                               	
}


/*
 * 
 */
public void run(IAction action)
{
	run();
}

}

