/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.adapter.internal;

import org.eclipse.hyades.trace.ui.*;

import org.eclipse.swt.widgets.*;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.hyades.trace.views.internal.CoverageStatisticView;
import org.eclipse.hyades.trace.views.internal.MultiLevelStatisticView;
import org.eclipse.hyades.trace.views.util.internal.CoverageAnalysis;


public class CoverageStatisticPage extends MultiLevelStatisticMethodPage {

	protected CoverageAnalysis _covAnalysis;

	public CoverageStatisticPage(EObject mofObject, TraceViewer _viewer) {
		super(mofObject, _viewer);
	}
	
	public void createControl(Composite parent) {
		computeMethodCoverage();
		super.createControl(parent);
	}

	/**
	 * refresh the content of the page when the "RefreshViews"
	 * command is activated
	 */
	public void refreshPage() {
		computeMethodCoverage();
		super.refreshPage();
	}

	/**
	 * compute the method coverage by creating an instance of
	 * the CoverageAnalysis class
	 */
	private void computeMethodCoverage() {
		setCovAnalysis(new CoverageAnalysis(getMOFObject()));
	}

	/**
	 * display the coverage data by creating an instance
	 * of the CoverageStatistic class
	 */
	protected MultiLevelStatisticView displayData(Composite parent) {
		// Let's save the level and load it in the new instance
		CoverageStatisticView view = new CoverageStatisticView(parent, this);
		return view;
	}

	/**
	 * @return the CoverageAnalysis instance
	 */
	public CoverageAnalysis getCovAnalysis() {
		return _covAnalysis;
	}

	/**
	 * @param the CoverageAnalysis instance
	 */
	public void setCovAnalysis(CoverageAnalysis analysis) {
		_covAnalysis = analysis;
	}
}
