/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.internal;

import java.util.ArrayList;

// LinearClassification:  Simple quantitative data classification scheme,
//                        mapping values linearly into buckets based on value.
public class LinearClassification extends QuantitativeClassification
{
	public int bucket(long value) {
		if (value < _rangeLow)
			return Classification.NULL_BUCKET;
		else if (value >= _rangeHigh)
			return _numBuckets - 1;
		else
			// Note that _rangeHigh > _rangeLow by the time we are in this case
			return
			  (int)(((value-_rangeLow)*(_numBuckets-1))/(_rangeHigh-_rangeLow));
	}
	public void classify(ArrayList values) {
		 // No-op for this type of classification
	}
	// The string which will appear in legends, labeling the nth bucket
	public String label(int n) {
		if (n == NULL_BUCKET)
			return (_nullBucketLabel == null) ? ("< " + _rangeLow)
											  : _nullBucketLabel;

		else if (n == _numBuckets-1)
			// Intentionally checking this case first, to get the right label for the
			// case where there is only one bucket.
			return _rangeHigh + "+";

		else if (n == 0)
			return _rangeLow + "";

		else
		  return new Long( _rangeLow + ( ( ( _rangeHigh - _rangeLow ) * (long)n ) / ( _numBuckets - 1 ) ) ).toString();
	}
}
