/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.internal;

import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.views.adapter.internal.SinglePatternPage;
import org.eclipse.hyades.trace.views.adapter.internal.TraceConstants;
import org.eclipse.hyades.trace.views.util.internal.*;
import org.eclipse.jface.action.*;
import org.eclipse.jface.viewers.*;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.*;

/*
* CONTEXT_ID osrc0000 for open java source action
*/

public class SinglePattern
	implements ITimeChangedListener, ControlListener, ISelectionProvider
			   , IViewSelectionChangedListener
	
{
	protected final float MAG_STEP = 2;
	private Label _status;
	private JCanvas _canvas;
	private SinglePatternDrawStrategy _curDS;
	private SinglePatternDrawStrategy _singlePatDS;
	private boolean _initialized = false;
	protected SinglePatternPage _page;
	protected Composite viewContainer;
	protected ViewForm dataPane;
	protected Composite viewComp;
	private Action _showNextAction;
	private Action _showPrevAction;
	private Action _showCallerAction;
	private Action _showCalleeAction;
	private Action _updateAction;
	private Action _openColorDialog;
	protected Separator fSeparator;

	class UpdateAction extends Action {
		public UpdateAction(String name) {
			super(name);
			PDPluginImages.setImageDescriptors(
				this,
				PDPluginImages.T_LCL,
				PDPluginImages.IMG_UPDATEVIEWS);
		}

		/**
		 * Invoked when an action occurs.
			* Argument context is the Window which contains the UI from which this action was fired.
		 * This default implementation prints the name of this class and its label.
		 */
		public void run() {
			ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
			event.setSource(_page.getMOFObject());
			event.setType(ProfileEvent.UPDATE_MODEL);
			
			UIPlugin.getDefault().notifyProfileEventListener(event);
			
		}
	}

	//-------------------------------
	// Open Color Dialog popup action
	//-------------------------------
	class OpenColorDialog extends Action {
		public OpenColorDialog(String name) {
			super(name);
			TracePluginImages.setImageDescriptors(
				this,
				TracePluginImages.T_TOOL,
				TracePluginImages.IMG_COLORS);

		}

		/**
		 * Invoked when an action occurs.
		* Argument context is the Window which contains the UI from which this action was fired.
		 * This default implementation prints the name of this class and its label.
		 */
		public void run() {
			GraphColorDialog dialog =
				new GraphColorDialog(
					viewContainer.getShell(),
					TraceUIPlugin.getString("STR_GRAPH_COLOR_DLG"),
					null);
			dialog.open();
		}
	}

	//-------------------------------
	// ShowCallerAction popup action
	//-------------------------------	
	class ShowCallerAction extends Action {
		public ShowCallerAction(String name) {
			super(name);
		}

		/**
		 * Invoked when an action occurs.
			* Argument context is the Window which contains the UI from which this action was fired.
		 * This default implementation prints the name of this class and its label.
		 */
		public void run() {
			showCaller();
		}
	}

	//-------------------------------
	// ShowCalleeAction popup action
	//-------------------------------	
	class ShowCalleeAction extends Action {
		public ShowCalleeAction(String name) {
			super(name);
		}

		/**
		 * Invoked when an action occurs.
			* Argument context is the Window which contains the UI from which this action was fired.
		 * This default implementation prints the name of this class and its label.
		 */
		public void run() {
			showCallee();
		}
	}

	//-------------------------------
	// ShowNextAction popup action
	//-------------------------------	
	class ShowNextAction extends Action {
		public ShowNextAction(String name) {
			super(name);
		}

		/**
		 * Invoked when an action occurs.
			* Argument context is the Window which contains the UI from which this action was fired.
		 * This default implementation prints the name of this class and its label.
		 */
		public void run() {
			next();
		}
	}

	//-------------------------------
	// ShowPreviousAction popup action
	//-------------------------------	
	class ShowPreviousAction extends Action {
		public ShowPreviousAction(String name) {
			super(name);
		}

		/**
		 * Invoked when an action occurs.
			* Argument context is the Window which contains the UI from which this action was fired.
		 * This default implementation prints the name of this class and its label.
		 */
		public void run() {
			previous();
		}
	}

	public SinglePattern(Composite parent, SinglePatternPage page) {
		_page = page;

		createControl(parent);
		_showNextAction = new ShowNextAction(TraceUIPlugin.getString("STR_NEXT"));
		_showPrevAction =
			new ShowPreviousAction(TraceUIPlugin.getString("STR_PREVIOUS"));
		_showCallerAction =
			new ShowCallerAction(TraceUIPlugin.getString("STR_CALLER"));
		_showCalleeAction =
			new ShowCalleeAction(TraceUIPlugin.getString("STR_CALLEE"));
		_updateAction = new UpdateAction(UIPlugin.getResourceString("REFRESH_VIEWS"));
		_openColorDialog =
			new OpenColorDialog(TraceUIPlugin.getString("OPEN_COLOR_DLG"));

		TraceUIPlugin.getDefault().addTimeChangedEventListener(this);
		UIPlugin.getDefault().addViewSelectionChangedListener(this);

	}
	public void controlMoved(org.eclipse.swt.events.ControlEvent e) {
	}
	public void controlResized(org.eclipse.swt.events.ControlEvent event) {
		resizeContent();
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (06/14/2000 3:36:09 PM)
	 * @return com.ibm.swt.widgets.Control
	 * @param parent com.ibm.swt.widgets.Composite
	 */
	public void createControl(Composite parent) {
		GridLayout layout;

		viewContainer = new Composite(parent, SWT.NULL);
		layout = new GridLayout();
		layout.numColumns = 1;
		viewContainer.setLayout(layout);
		viewContainer.setLayoutData(GridUtil.createFill());

		viewComp = new Composite(viewContainer, SWT.NULL);
		layout = new GridLayout();
		layout.numColumns = 1;
		viewComp.setLayout(layout);
		viewComp.setLayoutData(GridUtil.createFill());

		dataPane = new ViewForm(viewComp, SWT.NULL);
		dataPane.setLayoutData(GridUtil.createFill());

		_canvas = new JCanvas(dataPane, SWT.H_SCROLL | SWT.V_SCROLL, 10);
		dataPane.setContent(_canvas.canvas());
		viewContainer.addControlListener(this);

		_status = new Label(viewContainer, SWT.BORDER);
		_status.setLayoutData(GridUtil.createHorizontalFill());

		dataPane.setTopLeft(new CLabel(dataPane, SWT.NONE));

	}
	public void dispose() {
		TraceUIPlugin.getDefault().removeTimeChangedEventListener(this);
		UIPlugin.getDefault().removeViewSelectionChangedListener(this);

		if (_singlePatDS != null)
			_singlePatDS.shutdown();
		
		if(_canvas != null)
		  _canvas.dispose();
		  
		_canvas = null;

		if(dataPane != null)
			dataPane.dispose();
		dataPane = null;

		if(viewComp != null)
			viewComp.dispose();
		viewComp = null;	

		if(viewContainer != null)
			viewContainer.dispose();
		viewContainer = null;	

		_page = null;
		_singlePatDS = null;
		_curDS = null;
		
		if(_status != null)
			_status.dispose();
		_status = null;	
		
		_openColorDialog = null;
		_showCalleeAction = null;
		_showCallerAction = null;
		_showNextAction = null;
		_showPrevAction = null;
		_updateAction = null;			

	}
	/**
	 * This method should fill (or update) the given menu. It is called just before
	 * the menu opens.
	 */
	public void fillContextMenu(IMenuManager menu) {
		menu.add(fSeparator);
		menu.add(_updateAction);

		menu.add(_openColorDialog);
		menu.add(fSeparator);

		menu.add(_showCallerAction);
		menu.add(_showCalleeAction);
		menu.add(fSeparator);
		menu.add(_showNextAction);
		menu.add(_showPrevAction);
		menu.add(fSeparator);

		_showPrevAction.setEnabled(_curDS.hasLessElements());
		_showNextAction.setEnabled(_curDS.hasMoreElements());
		_showCallerAction.setEnabled(_curDS.hasCaller());
		_showCalleeAction.setEnabled(_curDS.hasCallee());

		_canvas.fillContextMenu(menu);
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (1/10/2001 2:33:22 PM)
	 * @return com.ibm.swt.widgets.Control
	 */
	public Control getControl() {
		return viewContainer;
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (06/15/2000 3:55:00 PM)
	 */
	public void initialize() {
		if (_initialized)
			return;

		_initialized = true;

		initStrategies();
		setDrawStrategy(_singlePatDS);
		fSeparator = new Separator();
	}
	private void initStrategies() {
		_singlePatDS = new SinglePatternDrawStrategy(this);
	}
	/**
	 * Called when the context menu is about to open.
	 * @see IFillMenuTarget#fillContextMenu
	 */
	public void menuAboutToShow(IMenuManager menu) {
		fillContextMenu(menu);
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (1/11/2001 5:07:13 PM)
	 */
	public void next() {
		initialize();
		if (_singlePatDS != null) {
			_singlePatDS.drawNextPattern();
			_singlePatDS.jcanvas().zoomToFill(1f, 1000f);
			_singlePatDS.jcanvas().redraw();
		}
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (8/21/2001 6:31:49 PM)
	 */
	public void openSource() {

		OpenSource.openSource(UIPlugin.getDefault().getSelectionModel(_page.getMOFObject()).getFirstElement());

	}
	/**
	 * Insert the method's description here.
	 * Creation date: (1/11/2001 5:07:13 PM)
	 */
	public void previous() {
		initialize();
		if (_singlePatDS != null) {
			_singlePatDS.drawPreviousPattern();
			_singlePatDS.jcanvas().zoomToFill(1f, 1000f);
			_singlePatDS.jcanvas().redraw();
		}
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (10/17/2000 2:08:36 PM)
	 */
	public void resizeContent() {
		/* Get the client area for the shell */
		Rectangle viewContainerBounds = viewComp.getClientArea();
		dataPane.setBounds(
			viewContainerBounds.x,
			viewContainerBounds.y,
			viewContainerBounds.width,
			viewContainerBounds.height);
	}
	private void setDrawStrategy(SinglePatternDrawStrategy ds) {
		if (ds != _curDS) {
			if (_curDS != null) {
				_curDS.jcanvas(null);
			}

			_curDS = ds;
			_curDS.jcanvas(_canvas);

			_canvas.zoomToFit();
			_canvas.setDrawStrategy(_curDS);
			_canvas.redraw();
			//			_curDS.bgRedraw();

		}
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (6/6/2001 5:21:34 PM)
	 */
	public void showCallee() {
		if (_curDS != null)
			_curDS.showCallee();

//		updateButtons();
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (6/6/2001 5:21:34 PM)
	 */
	public void showCaller() {
		if (_curDS != null)
			_curDS.showCaller();

//		updateButtons();
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (08/14/2000 5:45:18 PM)
	 */
	public void update() {
		update(true);
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (08/14/2000 5:45:18 PM)
	 */
	public void update(boolean redraw) {
		initialize();
		if (_singlePatDS != null) {
			_singlePatDS.searchPattern();

			/*
			if(redraw)
			{
				_singlePatDS.jcanvas().zoomToFill(1f, 1000f);			
				_singlePatDS.jcanvas().redraw();			
			}
			*/
			updateUI();
		}

	}
	public void updateButtons() {
		if (_curDS != null) {
			if (((SinglePatternPage) _page).previous() != null)
				((SinglePatternPage) _page).previous().setEnabled(
					_curDS.hasLessElements());

			if (((SinglePatternPage) _page).next() != null)
				((SinglePatternPage) _page).next().setEnabled(
					_curDS.hasMoreElements());

			if (((SinglePatternPage) _page).caller() != null)
				((SinglePatternPage) _page).caller().setEnabled(
					_curDS.hasCaller());

			if (((SinglePatternPage) _page).callee() != null)
				((SinglePatternPage) _page).callee().setEnabled(
					_curDS.hasCallee());

				if(((SinglePatternPage)_page).openSource() != null)				
					((SinglePatternPage)_page).openSource().setEnabled(UIPlugin.getDefault().getSelectionModel(_page.getMOFObject()).getFirstElement() != null);				

		}
	}
	public void updateStatus(String status) {
		_status.setText(status);
	}
	public void updateTitle(String title) {
		((CLabel) dataPane.getTopLeft()).setText(title);
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (1/11/2001 5:07:13 PM)
	 */
	public void updateUI() {
		if (_curDS.jcanvas() != null) {
			_curDS.jcanvas().zoomToFill(1f, 1000f);
			_curDS.jcanvas().redraw();
		}

	}
	/**
	 * Insert the method's description here.
	 * Creation date: (1/11/2001 5:07:13 PM)
	 */
	public void zoomIn(boolean zoom) {
		initialize();

		_canvas.isZoomIn(zoom);
		_canvas.zoomIn();

	}
	/**
	 * Insert the method's description here.
	 * Creation date: (1/11/2001 5:07:13 PM)
	 */
	public void zoomOut(boolean zoom) {
		initialize();

		_canvas.isZoomOut(zoom);
		_canvas.zoomOut();
	}

	public void handleTimeChangedEvent() {
		Action base = ((SinglePatternPage) _page).baseTime();
		Action raw = ((SinglePatternPage) _page).rawTime();
		int ref =
			TraceUIPlugin.getDefault().getPreferenceStore().getInt(
				TraceConstants.TIME_OPTION);
		if (base != null)
			base.setChecked(ref == TraceConstants.COMPENSATED_TIME);
		if (raw != null)
			raw.setChecked(ref == TraceConstants.RAW_TIME);

		if (_curDS != null)
			_curDS.setDrawMode(ref);
	}

	public SinglePatternPage getPage() {
		return _page;
	}
	
	/*
	 * This method handles a selection event
	 */
	public void refresh() {
		if (_canvas != null && !_canvas.canvas().isDisposed() && _canvas.canvas().isVisible()) {
			_canvas.redraw();
		}
	}
	
	/*
	 * This method handles a selection event
	 */
	public void selectionChanged() {
		
		if (_canvas != null && !_canvas.canvas().isDisposed() && _canvas.canvas().isVisible() && !_canvas.canvas().isFocusControl()) {

			update();			
//			_canvas.redraw();
		}
	}

	/**
	 * Adds a listener for selection changes in this selection provider.
	 * Has no effect if an identical listener is already registered.
	 *
	 * @param listener a selection changed listener
	 */
	public void addSelectionChangedListener(ISelectionChangedListener listener)
	{
	}
	/**
	 * Returns the current selection for this provider.
	 * 
	 * @return the current selection
	 */
	public ISelection getSelection()
	{
		if(_page == null)
		  return new StructuredSelection();
		  
		Object selection = UIPlugin.getDefault().getSelectionModel(_page.getMOFObject()).getFirstElement();
		
		if(selection != null)		
			return new StructuredSelection(selection);
			
		return new StructuredSelection();
	}
	/**
	 * Removes the given selection change listener from this selection provider.
	 * Has no affect if an identical listener is not registered.
	 *
	 * @param listener a selection changed listener
	 */
	public void removeSelectionChangedListener(ISelectionChangedListener listener)
	{
	}
	/**
	 * Sets the current selection for this selection provider.
	 *
	 * @param selection the new selection
	 */
	public void setSelection(ISelection selection)
	{
	}
	
	/**
	 * @return
	 */
	public JCanvas getCanvas() {
		return _canvas;
	}

	public void handleViewSelectionChangedEvent(ViewSelectionChangedEvent event)
	{
		if(!getPage().getTraceViewer().isProcessRefreshEvents()		
		|| getCanvas().canvas().isFocusControl())
		  return;
		
		selectionChanged();  
	}
	
	

	
	


}
