/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.views.util.internal;

import java.util.ArrayList;

// extracts repetitive patterns (words) from a series of objects.
// the series of objects is constructed by: LinearPattern.add(Object)
// the result of the pattern extraction is given as follows:
//   LinearPattern.length(int position) returns the length of the (repetitive) word at
//     this position
//   LinearPattern.repetition(int position) returns how often the word at this
//     position will be repeated
//
// example:
//    series:      a b c b c b c b c d e f
//    length:      1 2 0 0 0 0 0 0 0 1 1 1
//    repetition:  1 4 0 0 0 0 0 0 0 1 1 1


public class LinearPattern
{
	private ArrayList _repet, _length;
	private ArrayList _series;

	public LinearPattern () {
		_length = new ArrayList();
		_repet = new ArrayList();
		_series = new ArrayList();
	}
	public void add (Object a) {
		_series.add(a);
		_length.add(new Integer(1));
		_repet.add(new Integer(1));
	}
	public void compute () {
		int start = 0;
		int cursym = 0;
		int cnt = size();

		for (int curpos = 1 ; curpos < cnt ; ++curpos) {
			for (int samestart = start; samestart < curpos; ++samestart) {
				//search first occurence of same word from start position
				int len = curpos-samestart;
				if (wordCompare(curpos, samestart, len) &&
					wordCompare(curpos, curpos+len, len)       ) {
					int oldrepet = ((Integer)_repet.get(samestart)).intValue();
					_repet.set(samestart, new Integer(oldrepet+1));
					_length.set(samestart, new Integer(len));
					curpos += len;
					start = curpos;

					while (wordCompare(samestart,start,len)) {
						oldrepet = ((Integer)_repet.get(samestart)).intValue();
						_repet.set(samestart, new Integer(oldrepet+1));
						curpos += len;
						start = curpos;
					}
					for (int i=samestart+1; i<start; ++i) {
						_repet.set(i, new Integer(0));
						_length.set(i, new Integer(0));
					}
					break;
				}
			}
		}
	}
	public boolean hasRepetition () {
		int size = size();
		for (int i=0; i<size; ++i) {
			if (((Integer)_repet.get(i)).intValue()>1)
				return true;
		}
		return false;
	}
	public int length (int position) { return ((Integer)_length.get(position)).intValue(); }
	public int repetition (int position) { return ((Integer)_repet.get(position)).intValue(); }
	public int size () { return _series.size(); }
	public String toString () {
		int max = size() - 1;
		StringBuffer buf = new StringBuffer();
		buf.append("[ i, element, length, repetition \n");

		for (int i = 0 ; i <= max ; i++) {
			String s = _series.get(i).toString();
			buf.append(i+" ");
		    buf.append(s);
		    buf.append(", ");
		    buf.append(Integer.toString(length(i)));
		    buf.append(", ");
		    buf.append(Integer.toString(repetition(i)));
			if (i < max)
			    buf.append(", ");
			buf.append("\n");
		}
		buf.append("]");
		return buf.toString();
	}
	protected boolean wordCompare (int pos1, int pos2, int length) {
		if (pos1 < 0 || pos2 < 0 || length < 0)
			return false;
		if (pos1+length > size() || pos2+length > size())
			return false;
		for (int i=0; i<length; ++i)
			if (!_series.get(pos1+i).equals(_series.get(pos2+i)))
				return false;

		return true;
	}
}
