/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.util.internal;

import java.util.*;

import org.eclipse.hyades.trace.views.internal.*;
import org.eclipse.hyades.trace.views.adapter.internal.*;
import org.eclipse.hyades.trace.views.preferences.internal.*;
import org.eclipse.jface.preference.*;
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;

public class SpectrumColorMap
{
	private static ArrayList _colors = new ArrayList();
	private static int _position = 0;
	private static HashMap spectrum = new HashMap();
	
	private static boolean _useOneColor = true;	
	private static Color _backgroundColor;
	private static FontData _fontData = GraphColorPreferencePage.getConsoleFontData();
		
	private static Color _selectionColor = new Color(Display.getDefault(), PreferenceConverter.getColor(TraceUIPlugin.getDefault().getPreferenceStore(), TraceConstants.SELECTION_RGB));
	private static Color _unknownColor = new Color(Display.getDefault(), PreferenceConverter.getColor(TraceUIPlugin.getDefault().getPreferenceStore(), TraceConstants.UNKNOWN_RGB));
	private static Color _classColor = new Color(Display.getDefault(), PreferenceConverter.getColor(TraceUIPlugin.getDefault().getPreferenceStore(), TraceConstants.CLASSES_RGB));
	  
	public static Color color (int i) {
		
		if(_useOneColor)
		  return _classColor;
		  
		int col = Math.abs(i)%512;		
		return getNextColor(col);
	}
	
	/*
	 * Return next color to be used from the initial palette
	 */
	private static Color getNextColor(int col)
	{
		String key = String.valueOf(col);
		Object color = spectrum.get(key);
		if(color != null)
		  return (Color)color;
		  			
		//try to get a color from the palette list
		if(_position < _colors.size())
		{
			RGB rgb = (RGB)_colors.get(_position++);
			color = new Color(Display.getDefault(), rgb);
			spectrum.put(key, color);
			
			return (Color)color;
		}

        //get a randomly generated color
		int i1 = (col%8)*32;
		int i2 = ((col/8)%8)*32;
		int i3 = ((col/64)%8)*32;
		color = new Color(null, i1,i2,i3);
		spectrum.put(key, color);
		return (Color)color;
		
	}
	
	public static Color color (String s)
	{
		if (s == null)
			return color(0);
		else if(s.equals("_Unknown"))
		{
			return _unknownColor;
		}		
		else
			return color(s.hashCode());
	}
/**
 * Insert the method's description here.
 * Creation date: (07/11/2000 10:45:00 AM)
 */
public static void shutdown()
{
	Iterator values = spectrum.values().iterator();
	
	int idx=0;
	while(values.hasNext())
		((Color)values.next()).dispose();
	
 	if(_backgroundColor != null)
 	    _backgroundColor.dispose();
 	if(_classColor != null)
 	    _classColor.dispose();
 	if(_unknownColor != null)
 	    _unknownColor.dispose();
 	if(_selectionColor != null)
 	    _selectionColor.dispose();
	
}

/*
 * 
 */
 private static void setSelectionColor(RGB rgb)
 {
 	if(_selectionColor != null)
 	    _selectionColor.dispose();
 	    
 	_selectionColor = new Color(Display.getDefault(), rgb);  
 }
   
/*
 * 
 */
 private static void setClassColor(RGB rgb)
 {
	_useOneColor = TraceUIPlugin.getDefault().getPreferenceStore().getString(TraceConstants.CLASSES_OPTION).equals(TraceConstants.CLASS_ONE_COLOR);	
 	
 	if(_classColor != null)
 	    _classColor.dispose();
 	    
 	_classColor = new Color(Display.getDefault(), rgb);  
 }
 
/*
 * 
 */
 private static void setUnknownColor(RGB rgb)
 {
 	if(_unknownColor != null)
 	    _unknownColor.dispose();
 	    
 	_unknownColor = new Color(Display.getDefault(), rgb);  
 }
 
/*
 * 
 */
 private static void setBackgroundColor(RGB rgb)
 { 	
 	if(_backgroundColor != null)
 	    _backgroundColor.dispose();
 
	if(TraceUIPlugin.getDefault().getPreferenceStore().getString(TraceConstants.BACKGROUND_OPTION).equals(TraceConstants.BACKGROUND_DEFAULT))
		_backgroundColor = new Color(Display.getDefault(), Display.getDefault().getSystemColor(SWT.COLOR_LIST_BACKGROUND).getRGB());		
	else	
		_backgroundColor = new Color(Display.getDefault(), rgb);			
 }
 
  /*
  * 
  */
  public static Color getSelectionColor()
  {
  	return _selectionColor;
  }

 /*
  * 
  */
  public static Color getBackgroundColor()
  {
  	return _backgroundColor;
  }
  
 /*
  * 
  */
  public static FontData getFontData()
  {
  	return _fontData;
  }
  
 
  /*
   * Called by the GraphColor preference page
   */
  public static void updateColors()
  {
	setBackgroundColor(PreferenceConverter.getColor(TraceUIPlugin.getDefault().getPreferenceStore(), TraceConstants.BACKGROUND_RGB));	  	
	setSelectionColor(PreferenceConverter.getColor(TraceUIPlugin.getDefault().getPreferenceStore(), TraceConstants.SELECTION_RGB));
	setUnknownColor(PreferenceConverter.getColor(TraceUIPlugin.getDefault().getPreferenceStore(), TraceConstants.UNKNOWN_RGB));
	setClassColor(PreferenceConverter.getColor(TraceUIPlugin.getDefault().getPreferenceStore(), TraceConstants.CLASSES_RGB));  	
	_fontData = GraphColorPreferencePage.getConsoleFontData();

	TraceUIPlugin.getDefault().notifyColorChangedEventListener();
  }
  
	public static Color getColor(RGB rgb) {
		Color color= (Color) spectrum.get(rgb);
		if (color == null) {
			color= new Color(Display.getCurrent(), rgb);
			spectrum.put(rgb, color);
		}
		return color;
	}
	
	/*
	 * Initialize colors with a list of predefined RGB colors
	 */	 
	public static void startup()
	{
		if(TraceUIPlugin.getDefault().getPreferenceStore().getString(TraceConstants.BACKGROUND_OPTION).equals(TraceConstants.BACKGROUND_DEFAULT))
			_backgroundColor = new Color(Display.getDefault(), Display.getDefault().getSystemColor(SWT.COLOR_LIST_BACKGROUND).getRGB());		
		else	
			_backgroundColor = new Color(Display.getDefault(), PreferenceConverter.getColor(TraceUIPlugin.getDefault().getPreferenceStore(), TraceConstants.BACKGROUND_RGB));			
			
		_useOneColor = TraceUIPlugin.getDefault().getPreferenceStore().getString(TraceConstants.CLASSES_OPTION).equals(TraceConstants.CLASS_ONE_COLOR);	
		
		_colors.add(new RGB(127,127,191));
		_colors.add(new RGB(63,63,127));
//		_colors.add(new RGB(223,223,127)); yellow
		
//		_colors.add(new RGB(95,95,95)); gray
		_colors.add(new RGB(127,127,63));
//		_colors.add(new RGB(255,255,95)); yellow
			
//		_colors.add(new RGB(127,95,191));
		_colors.add(new RGB(191,159,191));
//		_colors.add(new RGB(255,95,191)); pink
		_colors.add(new RGB(95,63,159));
		_colors.add(new RGB(159,63,159));
			
		_colors.add(new RGB(159,127,159));
		_colors.add(new RGB(255,127,159));
		_colors.add(new RGB(223,191,159));
		_colors.add(new RGB(223,63,127));
			
		_colors.add(new RGB(127,95,127));
		_colors.add(new RGB(191,95,127));
		_colors.add(new RGB(255,127,127));
		_colors.add(new RGB(191,159,127));
		_colors.add(new RGB(95,63,95));

		_colors.add(new RGB(223,63,159));
			
		_colors.add(new RGB(127,63,95));
		_colors.add(new RGB(191,127,95));
		_colors.add(new RGB(223,191,95));
		_colors.add(new RGB(127,63,63));
		_colors.add(new RGB(255,63,63));
		
		_colors.add(new RGB(223,127,63));
		_colors.add(new RGB(95,191,63));
		_colors.add(new RGB(159,223,63));
		_colors.add(new RGB(63,223,95));
		_colors.add(new RGB(63,159,95));
					
		_colors.add(new RGB(127,255,95));
		_colors.add(new RGB(63,127,127));
		_colors.add(new RGB(95,223,127));
		_colors.add(new RGB(159,223,127));
		_colors.add(new RGB(63,159,159));
				
		_colors.add(new RGB(95,191,159));
		_colors.add(new RGB(159,223,223));
		_colors.add(new RGB(63,191,191));
		_colors.add(new RGB(95,159,191));
		_colors.add(new RGB(127,191,191));
	
		_colors.add(new RGB(191,191,95)); 
	
		_colors.add(new RGB(63,63,191));
//		_colors.add(new RGB(127,63,191)); purple
				
//		_colors.add(new RGB(255,255,159));
	}
	
}
