/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.actions.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.hyades.uml2sd.trace.TraceSDPlugin;
import org.eclipse.hyades.uml2sd.trace.loaders.TraceInteractions;
import org.eclipse.hyades.uml2sd.ui.SDViewerPlugin;
import org.eclipse.jface.action.Action;

/**
 * Base class for all the actions that just change the trace loader (ILifelineLoader) currently in use.
 */
public class ChangeLifelineLoaderAction extends Action {
	
	private String loaderClassName;
	
	public ChangeLifelineLoaderAction(String loaderClassName_) {
		loaderClassName = loaderClassName_;
	}
	
	public String getLoaderClassName() {
		return loaderClassName;
	}
	
	public void run() {
		TraceInteractions.getInstance().setLifelineLoader(loaderClassName);
	}
	
	private static List actionList;

	public static List getChangeLifelineLoaderActions(String viewId) {
		if (actionList == null) {
			actionList = new ArrayList();
			List confs = SDViewerPlugin.getLoaders(viewId);
			for (Iterator i = confs.iterator(); i.hasNext(); ) {
				IConfigurationElement c = (IConfigurationElement)i.next();
				ChangeLifelineLoaderAction a = new ChangeLifelineLoaderAction(c.getAttribute("class")); //$NON-NLS-1$
				a.setText(c.getAttribute("name")); //$NON-NLS-1$
				a.setToolTipText(TraceSDPlugin.getResourceString("SHOW_EXEC_STAT")); //$NON-NLS-1$
				a.setId(a.loaderClassName);
				a.setImageDescriptor(TraceSDPlugin.getResourceImageDescriptor("sequencediagram_obj.gif")); //$NON-NLS-1$
				actionList.add(a);
			}
		}
		return actionList;
	}

}
