/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.actions.internal;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.uml2sd.trace.TraceSDPlugin;
import org.eclipse.hyades.uml2sd.trace.loaders.TraceInteractions;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceInteractionUtils;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceProcess;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceProcesses;
import org.eclipse.hyades.uml2sd.trace.selection.IDateSelection;
import org.eclipse.hyades.uml2sd.ui.load.BackgroundLoader;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;

/**
 * Example action to show the use of 'open-and-scroll-to-time' capability of the Trace Interactions.
 * Uncomment this action in plugin.xml 
 */
public class OpenObjectInteractionsAndScrollToTime extends Action {

	/**
	 * This class implements IDateSelection that is used as a parameter when calling
	 * TraceInteractions.setExternalDateSelection(ts) 
	 */
	private class TimeSelection implements IDateSelection {
		
		private double targetTime;
		
		public TimeSelection(double targetTime_) {
			targetTime = targetTime_;
		}

		public int getMeaning() {
			return IDateSelection.NOW;
		}

		public double getStartDate() {
			return targetTime;
		}

		public double getEndDate() {
			return getStartDate();
		}

		public EObject getEObject() {
			return null;
		}

		public String toString() {
			return getClass().getName()+":"+hashCode()+"["+targetTime+"]"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		}
	}
	
	/**
	 * HERE STARTS EXAMPLE CODE
	 * @param agent the agent that must be selected in the Profiling Navigator and that will cause
	 * 	the Trace Interactions to load from the right trace model part
	 * @param targetTime the time onto which we would like to scroll, once the model is read and the
	 * 	Trace Interactions view is filled in
	 */
	private void showTimeInTrace(TRCAgent agent, final double targetTime) {
        // Is using the PDExplorer the right thing to do ?
        // Yes, definitely
        PDProjectExplorer pdExplorer = PDProjectExplorer.getFromActivePerspective();

        // Set the agent selected in the navigator, and open it
		pdExplorer.selectObject(agent.getAgentProxy());

        // Now push the nominated trace into the SD view
		// Same as "Open With ... UML2 Object Interactions" action
        OpenObjectInteractions ooi = new OpenObjectInteractions();
        ooi.run();
        // This is causing the Trace Interactions background loader to load from the trace model,
        // especially showing interactions corresponding to the agent that has just been selected above
        // This task is running concurrently to the present code

        // Now let's require a scroll action
        // Using newSubsequentTask(), this scroll action is recorded and will be executed just after the
        // background loader will have finished with the previous action
    	BackgroundLoader.getInstance().newSubsequentTask(new IRunnableWithProgress() {
			public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
				Display.getDefault().syncExec(new Runnable() {
					// This code is executed in the SWT-main-loop thread
					public void run() {
						// Simple absolute time selection
				        TimeSelection ts = new TimeSelection(targetTime);
				        TraceInteractions.setExternalDateSelection(ts);
					}}
				);
			}
    	});
	}

	private void runTheExampleAction() {
		
		// TEST ONLY: just to get a time and an agent to synchronize on
        TraceProcesses processes = TraceProcesses.getTraceProcesses(HyadesUtil.getMofObject(), new IProgressMonitor() {
			public void beginTask(String name, int totalWork) {}
			public void done() {}
			public void internalWorked(double work) {}
			public boolean isCanceled() {return false;}
			public void setCanceled(boolean value) {}
			public void setTaskName(String name) {}
			public void subTask(String name) {}
			public void worked(int work) {}});
        if (processes.size() < 1) {
        	System.err.println("No processes here"); //$NON-NLS-1$
        	return;
        }
        TraceProcess tp = (TraceProcess)processes.get(0);
        final TRCProcess process = tp.getProcess();
        TRCAgent agent = process.getAgent();
        final double targetTime =
        	TraceInteractionUtils.getAbsoluteEntryTime(process)+
				(process.getStartTime()+process.getStopTime())/2;

        showTimeInTrace(agent, targetTime);
    	
    	// TEST ONLY: check the existence of the view
        IWorkbenchPage persp = UIPlugin.getActivePage();
        SDView sdView = (SDView) persp.findView(TraceSDPlugin.UML2SD_TRACE_VIEW_ID);
        if (sdView == null) {
            System.err.println("View not found"); //$NON-NLS-1$
        }
    }
	
	public void run() {
		runTheExampleAction();
	}

}
