/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.loaders.internal;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.uml2sd.trace.TraceSDPlugin;
import org.eclipse.hyades.uml2sd.trace.loaders.TraceInteractions;
import org.eclipse.hyades.uml2sd.trace.selection.IEObjectSelection;
import org.eclipse.hyades.uml2sd.ui.core.Lifeline;
import org.eclipse.ui.IActionFilter;


/**
 * Here is an helper to maintain correct execution occurences (overlay is not supported by the API)
 */
public class TraceLifeline extends Lifeline implements IEObjectSelection, IActionFilter, IPropertiesMiner {
	
	private EObject eObject;

	/**
	 * @see org.eclipse.hyades.uml2sd.trace.selection.IEObjectSelection#getEObject()
	 */
	public EObject getEObject() {
		return eObject;
	}
	
	public void setEObject(EObject eObject_) {
		eObject = eObject_;
	}

	/**
	 * @see org.eclipse.ui.IActionFilter#testAttribute(java.lang.Object, java.lang.String, java.lang.String)
	 * 	property drillDownEnabled: true if the currentloader allows drill down
	 */
	public boolean testAttribute(Object target, String name, String value) {
		if (name.equals("drillDownEnabled")) { //$NON-NLS-1$
			return TraceInteractions.getInstance().getLifelineLoader().drillDownEnabled(value);
		}
		// Any other property is ignored
		return true;
	}

	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.internal.IPropertiesMiner#getDescription(java.lang.String)
	 */
	public String getDescription(String propertyName) {
		if (propertyName.equals(TraceRootProperty.STR_TYPE)) {
			return TraceSDPlugin.getResourceString("STR_TYPE_DESCRIPTION"); //$NON-NLS-1$
		} else if (propertyName.equals(TraceRootProperty.STR_NAME)) {
			return TraceSDPlugin.getResourceString("STR_NAME_DESCRIPTION"); //$NON-NLS-1$
		} else if (propertyName.equals(TraceRootProperty.STR_TIME)) {
			return ""; //$NON-NLS-1$
		}
		return propertyName;
	}

	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.internal.IPropertiesMiner#getDisplayName(java.lang.String)
	 */
	public String getDisplayName(String propertyName) {
		if (propertyName.equals(TraceRootProperty.STR_TYPE)) {
			return TraceSDPlugin.getResourceString("STR_TYPE_DISPLAY_NAME"); //$NON-NLS-1$
		} else if (propertyName.equals(TraceRootProperty.STR_NAME)) {
			return TraceSDPlugin.getResourceString("STR_NAME_DISPLAY_NAME"); //$NON-NLS-1$
		} else if (propertyName.equals(TraceRootProperty.STR_TIME)) {
			return ""; //$NON-NLS-1$
		}
		return propertyName;
	}

	/**
	 * @see org.eclipse.hyades.uml2sd.trace.loaders.internal.IPropertiesMiner#getValueAsString(java.lang.String)
	 */
	public String getValueAsString(String propertyName) {
		if (propertyName.equals(TraceRootProperty.STR_TYPE)) {
			return TraceInteractions.getInstance().getLifelineLoader().getLifelineType(eObject);
		} else if (propertyName.equals(TraceRootProperty.STR_NAME)) {
			return getName();
		} else if (propertyName.equals(TraceRootProperty.STR_TIME)) {
			return ""; //$NON-NLS-1$
		}
		// Unknown property
		return ""; //$NON-NLS-1$
	}
}