/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.uml2sd.trace.preferences;

import java.text.MessageFormat;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.uml2sd.trace.TraceSDPlugin;
import org.eclipse.hyades.uml2sd.trace.loaders.TraceInteractions;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.ContextIds;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

/**
 * Trace interaction preference page.
 */

public class TraceInteractionPreferencePage extends PreferencePage
										implements IWorkbenchPreferencePage, ModifyListener
{
	
	private Text txtPageSize;

	public TraceInteractionPreferencePage() {
		super();
	}
	protected Control createContents(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);

		WorkbenchHelp.setHelp(parent, ContextIds.TRACE_INTERACTION_PREF);

		GridLayout layout = new GridLayout();
		layout.marginWidth = 10;
		layout.marginHeight = 5;
		layout.numColumns = 2;
		composite.setLayout(layout);
		
		Label note = new Label(composite, SWT.WRAP);
		note.setText(TraceSDPlugin.getResourceString(TraceSDPlugin.getResourceString("PAGE_SIZE_NOTE"))); //$NON-NLS-1$
		GridData data = new GridData();
		data.horizontalSpan=2;
		data.widthHint = 375;
		note.setLayoutData(data);
		
		Label dummy = new Label(composite, SWT.NULL);
		data = new GridData();
		data.horizontalSpan=2;
		data.grabExcessHorizontalSpace=true;
		dummy.setLayoutData(data);
		
		Label label = new Label(composite, SWT.NULL);
		label.setText(TraceSDPlugin.getResourceString(TraceSDPlugin.getResourceString("STR_PAGE_SIZE"))); //$NON-NLS-1$
		txtPageSize = new Text(composite, SWT.BORDER);
		txtPageSize.setTextLimit(8);
		data = new GridData();
		data.widthHint = convertWidthInCharsToPixels(10);
		txtPageSize.setLayoutData(data);
		txtPageSize.setText(getPreferenceStore().getString(ITraceInteractionPreferenceListener.PAGE_SIZE));
		txtPageSize.addModifyListener(this);
					    		
		return composite;
	}

	public IPreferenceStore getPreferenceStore() {
		return TraceSDPlugin.getDefault().getPreferenceStore(); 
	}
	public void init(IWorkbench workbench) {
	}
	/**
	 * Initializes states of the controls using default values
	 * in the preference store.
	 */
	private void initializeDefaults() {
		txtPageSize.setText(
			getPreferenceStore().getDefaultString(ITraceInteractionPreferenceListener.PAGE_SIZE));
	}
	/**
	 * Restore defaults.
	 */
	protected void performDefaults() {
		initializeDefaults();
	}
	/**
	 * Do anything necessary because the OK button has been pressed.
	 *
	 * @return whether it is okay to close the preference page
	 */
	public boolean performOk() {
		storeValues();
		TraceInteractions.getInstance().applyPreferences();
		return true;
	}
	/**
	 * Stores the values of the controls back to the preference store.
	 */
	private void storeValues() {
		getPreferenceStore().setValue(
			ITraceInteractionPreferenceListener.PAGE_SIZE,
			txtPageSize.getText());
	}
	/**
	 * @see org.eclipse.swt.events.ModifyListener#modifyText(org.eclipse.swt.events.ModifyEvent)
	 */
	public void modifyText(ModifyEvent e) {
		IStatus status = validateInput();
		setValid(status.getSeverity()==IStatus.OK);
		if(status.getSeverity()==IStatus.ERROR)	
			setErrorMessage(status.getMessage());
		else
			setErrorMessage(null);
	}
	
	private IStatus validateInput(){
		
		String nrOfPages = txtPageSize.getText();
		
		PreferenceStatus status = new PreferenceStatus();
		
		if (nrOfPages.length() == 0) {			
			status.setMessage(TraceSDPlugin.getResourceString(TraceSDPlugin.getResourceString("EMPTY_FIELD_MSG"))); //$NON-NLS-1$
			status.setSeverity(IStatus.ERROR);
		} else {
			try {
				int value= Integer.parseInt(nrOfPages);
				if (value < 100 || value > 10*1024*1024) {
					status.setMessage(MessageFormat.format(TraceSDPlugin.getResourceString(TraceSDPlugin.getResourceString("INVALID_PAGE_SIZE")),  //$NON-NLS-1$
							new String[] {nrOfPages, "100", "10*1024*1024"})); //$NON-NLS-1$ //$NON-NLS-2$
					status.setSeverity(IStatus.ERROR);
				}
			} catch (NumberFormatException e) {
				status.setMessage(MessageFormat.format(TraceSDPlugin.getResourceString(TraceSDPlugin.getResourceString("INVALID_PAGE_SIZE")),  new String[] {nrOfPages})); //$NON-NLS-1$
				status.setSeverity(IStatus.ERROR);
			}
		}
		
		return status;

	}
	
	class PreferenceStatus extends Status  {
		
		public PreferenceStatus(){
			super(OK, "hyades.uml2sd.trace", 0, "", null); //$NON-NLS-1$ //$NON-NLS-2$
		}
		
		/**
		 * @see org.eclipse.core.runtime.Status#setMessage(java.lang.String)
		 */
		protected void setMessage(String message) {
			super.setMessage(message);
		}

		/**
		 * @see org.eclipse.core.runtime.Status#setSeverity(int)
		 */
		protected void setSeverity(int severity) {
			super.setSeverity(severity);
		}

	}

}
