/*******************************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.datapool.internal.action;

import org.eclipse.hyades.test.ui.datapool.DatapoolPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.control.DatapoolTable;
import org.eclipse.hyades.test.ui.datapool.internal.util.ContextIds;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.help.WorkbenchHelp;

/**
 * @author psun
 *
 */
public class EditRowGroupAction extends SelectionProviderAction {
	private DatapoolTable table;

	public EditRowGroupAction(ISelectionProvider viewer, DatapoolTable table)
	{
		super(viewer, DatapoolPlugin.getResourceString("EDIT_ROW_GRP_TEXT")); //$NON-NLS-1$
		setDescription(DatapoolPlugin.getResourceString("EDIT_ROW_GRP_LDESC")); //$NON-NLS-1$
		WorkbenchHelp.setHelp(this, DatapoolPlugin.getID() + ContextIds.EDIT_ROW_GRP_ACT);
		this.table = table;
	}

	public void run()
	{
		if (table != null)
			table.editRowGroup();
	}

	public void aboutToShow(boolean bShow)
	{
		setEnabled(bShow);
	}
	
}
