/*******************************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.datapool.internal.interfaces;

import org.eclipse.swt.widgets.Composite;

/**
 * @author psun
 *
 */
public interface IDisplayValueClass {

	/**
	 * This method returns the description of the object used in the
	 * initial property display.  When selected for editing this text
	 * will be replaced by the <i>property display</i> if it is not
	 * <b>null</b>.
	 * 
	 * @param	theObject	An instance of the class represented by
	 *						the associated value class.
	 * @return	A description of the supplied object.
	 */
	public String getPropertyDescription(Object theObject);
	
	/**
	 * This method returns the control that is placed in the property
	 * editor to allow access to data.  This method may return a
	 * <b>null</b> value and a standard control will be used that 
	 * displays the {@link #getValueDisplay(Object,Composite,boolean) value display}
	 * control.  Either this method or {@link #getValueDisplay(Object,Composite,boolean)
	 * getValueDisplay} must return a non-<b>null</b> Control.
	 * <br><br>
	 * The types of Controls this method might return are ComboBox,
	 * CheckBox, Text or Dialog.  The Control must be able to be cleanly 
	 * resized to fit into a cell of a property style sheet type display.
	 * 
	 * @param	theObject	An instance of the class represented by
	 *						this value class.
	 * @return	A Control that can be used in a property sheet
	 *			style display.
	 */
	public Object getPropertyDisplay(Object theObject, Composite parent,
									  boolean editable);
	
	/**
	 * This method returns an Object(widgets.Dialog or jface.Dialog) that is used to display 
	 * a detailed view of the specified data.  This method may return
	 * a <b>null</b> value, however either this method or {@link 
	 * #getPropertyDisplay(Object,Composite, boolean) getPropertyDisplay} must return a 
	 * non-<b>null</b> component.  If the nature of this data is 
	 * complex (such as a grid, tree or property set) then this 
	 * method should be supported instead of the {@link 
	 * #getPropertyDisplay(Object,Composite, boolean) getPropertyDisplay} counterpart.
	 * <br><br>
	 * This control will return dialog contains of classes such as tree,
	 * table, ColorDialog and the like.  If a Window class object
	 * is returned it will be positioned and displayed directly.
	 * Otherwise an appropriate wrapper will be placed around the
	 * control.
	 * 
	 * @param	theObject	An instance of the class represented by
	 *						this value class.
	 * @param	editable	<b>true</b> if the display should allow
	 *						modifications to the specified data.
	 * @return	A component that can be used to display a detailed 
	 *			view of the specified data.
	 */
	public Object getValueDisplay(Object theObject, 
								  Composite parent,
								  boolean editable);
	
	/**
	 * This method takes the property, value  or difference display 
	 * and the asssociated object and returns an updated instance of 
	 * the original object.  If no changes were made to the original 
	 * object then the orignal object should be returned unmodified.
	 * If a difference display is passed in then the instance will be
	 * for the left side of the comparison.
	 * 
	 * @param	theObject	The object the display represents.
	 * @param	display		A Control returned from {@link
	 *						#getPropertyDisplay(Object,Composite, boolean) getPropertyDisplay},
	 *						{@link #getValueDisplay(Object,Composite, boolean)
	 *						getValueDisplay}.
	 * @return	An updated instance of <i>theObject</i>.
	 */
	public Object getUpdatedObject(Object theObject, Object display);

}
