/**********************************************************************
 * Copyright (c) 2003,2004 Scapa Technologies Limited and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui;

import org.eclipse.hyades.statistical.ui.widgets.internal.*;

public class ImageManager extends BaseImageManager {

	public static final String FOLDER_ETOOL = "etool16";

	public static final String IMG_NEW_STATCON_LOGO = "new_statcon_obj.gif";
	
	public static final String FOLDER_IMG = "obj16";

	public static final String IMG_ALERT = "alert_obj.gif";
	public static final String IMG_ERROR = "error_st_obj.gif";
	public static final String IMG_RUN_EXEC = "run_exec.gif";

	public static final String IMG_LOCK = "lock.gif";
	public static final String IMG_SAVE = "save.gif";
	public static final String IMG_CLEAR = "clear.gif";

	public static final String IMG_UP = "up.gif";
	public static final String IMG_DOWN = "down.gif";
	public static final String IMG_LEFT = "left.gif";
	public static final String IMG_RIGHT = "right.gif";
	
	public static final String FOLDER_EVENTS = "obj16";
	
	public static final String IMG_EVENT_UNKNOWN = "event_unknown.gif";
	public static final String IMG_EVENT_TYPED_START = "event_typed_start.gif";
	public static final String IMG_EVENT_TYPED_STOP = "event_typed_stop.gif";
	public static final String IMG_EVENT_MESSAGE = "event_message.gif";
	public static final String IMG_EVENT_MESSAGEINFO = "event_messageinfo.gif";
	public static final String IMG_EVENT_MESSAGEWARNING = "event_messagewarning.gif";
	public static final String IMG_EVENT_MESSAGEERROR = "event_messageerror.gif";
	public static final String IMG_EVENT_VERDICT = "event_verdict.gif";
	public static final String IMG_EVENT_INVOCATION = "event_invocation.gif";
	public static final String IMG_HISTORY_ENTITY = "history_entity.gif";

	public static final String FOLDER_SMODEL = "obj16";

//	public static final String IMG_SMODEL_DESCRIPTOR = "smodel_descriptor.gif";
	public static final String IMG_SMODEL_DESCRIPTOR = "smodel_descriptor2.gif";
	public static final String IMG_SMODEL_COUNTERDESCRIPTOR = "smodel_counterdescriptor.gif";
	public static final String IMG_SMODEL_COUNTERDESCRIPTOR_LIVE = "smodel_counterdescriptor_live.gif";

	public static final String IMG_SMODEL_COUNTER = "smodel_counter.gif";
	public static final String IMG_SMODEL_MODIFIABLEREP = "smodel_modifiablerep.gif";
	public static final String IMG_SMODEL_TRCAGENT = "smodel_trcagent.gif";
	public static final String IMG_SMODEL_CBEMESSAGE = "smodel_cbemessage.gif";
	public static final String IMG_SMODEL_CBESOURCE = "smodel_cbemessage.gif";
	public static final String IMG_SMODEL_CBESEVERITY = "smodel_cbemessage.gif";
	public static final String IMG_SMODEL_CBEINFO = "event_messageinfo.gif";
	public static final String IMG_SMODEL_CBEWARNING = "event_messagewarning.gif";
	public static final String IMG_SMODEL_CBEERROR = "event_messageerror.gif";
	public static final String IMG_SMODEL_REMOVE = "smodel_remove.gif";

	public static final String FOLDER_MISC = "obj16";
	public static final String IMG_MISC_HSLIDER = "slider_h.gif";
	public static final String IMG_MISC_VSLIDER = "slider_v.gif";
	public static final String IMG_MISC_SAVE = "save.gif";

	public static final String IMG_NEW_STATCON = "new_statcon_wiz.gif";
	
	public ImageManager() {
	}
	
	public void addImages() {
		
//		ImageRegistry reg = plugin.getImageRegistry();

		add(FOLDER_ETOOL,IMG_NEW_STATCON_LOGO);
		
		add(FOLDER_IMG,IMG_ALERT);
		add(FOLDER_IMG,IMG_ERROR);
		add(FOLDER_IMG,IMG_LOCK);
		add(FOLDER_IMG,IMG_SAVE);
		add(FOLDER_IMG,IMG_CLEAR);
		add(FOLDER_IMG,IMG_RUN_EXEC);

		add(FOLDER_IMG,IMG_UP);
		add(FOLDER_IMG,IMG_DOWN);
		add(FOLDER_IMG,IMG_LEFT);
		add(FOLDER_IMG,IMG_RIGHT);


		add(FOLDER_EVENTS,IMG_EVENT_UNKNOWN);
		add(FOLDER_EVENTS,IMG_EVENT_TYPED_START);
		add(FOLDER_EVENTS,IMG_EVENT_TYPED_STOP);
		add(FOLDER_EVENTS,IMG_EVENT_MESSAGEINFO);
		add(FOLDER_EVENTS,IMG_EVENT_MESSAGEWARNING);
		add(FOLDER_EVENTS,IMG_EVENT_MESSAGEERROR);
		add(FOLDER_EVENTS,IMG_EVENT_MESSAGE);
		add(FOLDER_EVENTS,IMG_EVENT_VERDICT);
		add(FOLDER_EVENTS,IMG_EVENT_INVOCATION);
		add(FOLDER_EVENTS,IMG_HISTORY_ENTITY);

		add(FOLDER_SMODEL,IMG_SMODEL_DESCRIPTOR);
		add(FOLDER_IMG,IMG_SMODEL_COUNTERDESCRIPTOR);
		add(FOLDER_IMG,IMG_SMODEL_COUNTERDESCRIPTOR_LIVE);

		add(FOLDER_SMODEL,IMG_SMODEL_COUNTER);
		add(FOLDER_SMODEL,IMG_SMODEL_MODIFIABLEREP);
		add(FOLDER_SMODEL,IMG_SMODEL_TRCAGENT);
		add(FOLDER_SMODEL,IMG_SMODEL_CBEMESSAGE);
		add(FOLDER_SMODEL,IMG_SMODEL_REMOVE);

		add(FOLDER_MISC,IMG_MISC_HSLIDER);
		add(FOLDER_MISC,IMG_MISC_VSLIDER);
		add(FOLDER_MISC,IMG_MISC_SAVE);

		add(FOLDER_MISC,IMG_NEW_STATCON);
	}
	
}