/**********************************************************************
 * Copyright (c) 2003,2004 Scapa Technologies Limited and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.editor.internal;

import org.eclipse.hyades.statistical.ui.*;
import org.eclipse.swt.widgets.*;

/**
 * This recursive StatCon Tree operation frees subtrees in statcon
 * It basically deletes part of a statcon tree
 */
public class OpFreeSubTree implements StatConTreeOp {
	public static OpFreeSubTree INSTANCE = new OpFreeSubTree();

	static ImageManager img = EditorPlugin.img;

	public static void launch(StatisticalModelGraphViewer statcon, TreeItem item, TreeItem root) {
		StatConOpState state = new StatConOpState(null);
		statcon.applyStatConTreeOp( new OpFreeSubTree(), state, item, root);
	}
	
	public StatConOpState preapply(StatConOpState state, StatisticalModelGraphViewer statcon, TreeItem sd, TreeItem root_parent, boolean parents_checked, boolean parents_enabled) {
		return state;
	}
	public void postapply(StatConOpState state, StatisticalModelGraphViewer statcon, TreeItem sd, TreeItem root_parent, boolean parents_checked, boolean parents_enabled) {
		statcon.freeTreeItem(sd);
	}

}