/**********************************************************************
 * Copyright (c) 2003,2004 Scapa Technologies Limited and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.editor.internal;

import org.eclipse.hyades.model.statistical.*;

import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.*;

import org.eclipse.hyades.statistical.ui.*;
import java.util.*;

public class SDTextObservationGraphSource implements EnumerationGraphSource {

SDTextObservation sdc;
List times;
List values;

	public SDTextObservationGraphSource(SDTextObservation sdc) {
		this.sdc = sdc;
		times = sdc.getCreationTime();
		values = sdc.getTextValue();
	}

	public int bchopGetIndex(double t) {

		int lower = 0;
		int higher = times.size()-1;

		double t1 = ((Number)times.get(lower)).doubleValue();
		double t2 = ((Number)times.get(higher)).doubleValue();

		if (t >= t2) {
			return times.size()-1;
		} else if (t <= t1) {
			return 0;
		} else {
			return bchopGetIndex(lower,higher,t);
		}//end if
	}
	
	private int bchopGetIndex(int lower, int higher, double t) {
		
		while (true) {
			
			if (higher-lower < 10) {
				for (int i = lower; i <= higher; i++) {
					Number T = (Number)times.get(i);
					if (T.doubleValue() > t) {
						i--;
						if (i < 0) return 0;
						if (i >= times.size()) return times.size()-1;
						
						return i;
					}
				}	
				return higher;
			}
	
			double t1 = ((Number)times.get(lower)).doubleValue();
			double t2 = ((Number)times.get(higher)).doubleValue();
	
//weighted heuristic
			double chop = (t - t1) / (t2 - t1);
			chop = chop * (double)((higher-lower)-2);
			chop = chop + ((double)lower) + 1.0d;

//centre-chop heuristic
//			double chop = lower + ((higher-lower)/2);

//			EditorPlugin.DBG.info("loop "+lower+" "+higher+" "+chop);
			
			double chop_t = ((Number)times.get((int)chop)).doubleValue();
			if (chop_t == t) {
				return (int)chop;
			} else if (chop_t > t) {
				higher = (int)chop;
			} else {
				lower = (int)chop;
			}

		}

//replaced this recursion with a simple loop - faster and more efficient
//		return bchopGetIndex(lower,higher,t);				
	}	
	
	public Object getValueAt(double t) {

//		times = sdc.getCreationTime();
//		values = sdc.getTextValue();
		if (times == null) return null;
		if (times.size() == 0) return null;	

		int index = bchopGetIndex(t);

		if (times.size() != values.size()) {
			EditorPlugin.DBG.warning("Text Observation times list size different to values list size - something is out of sync here - "+times.size()+" "+values.size());
		}

		String D = (String)values.get(index);		

		return D;
	}

	public double getMin() {
		if (times == null) return Double.NEGATIVE_INFINITY;
		if (times.size() == 0) return Double.NEGATIVE_INFINITY;
		Number L = (Number)times.get(0);
		return L.doubleValue();
	}
	public double getMax() {
		if (times == null) return Double.POSITIVE_INFINITY;
		if (times.size() == 0) return Double.POSITIVE_INFINITY;
		Number L = (Number)times.get(times.size()-1);
		return L.doubleValue();
	}
}