/**********************************************************************
 * Copyright (c) 2003,2004 Scapa Technologies Limited and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.monitoractions.internal.sound;

import org.eclipse.hyades.statistical.ui.widgets.alert.internal.*;
import org.eclipse.hyades.statistical.ui.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.hyades.model.statistical.*;

import java.text.*;

import java.applet.Applet;
import java.applet.AudioClip;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class SoundAlertAction implements AlertAction {

boolean trigger;
String name;
double value;
double time;

String path = "newsound.wav";
static SimpleDateFormat sdf = new SimpleDateFormat();

AudioClip player;

	public AlertActionControl getControl(Composite c) {
		return new SoundControl(c,this);
	}
	
	public String getDescription() {
		return EditorPlugin.getString("ALERT_ACTION_NAME_SOUND")+" ("+path+")";
	}
	
	public String getProviderName() {
		return EditorPlugin.getString("ALERT_ACTION_NAME_SOUND");
	}
	public void setInformation(String name, SDSnapshotObservation obs, double value, double time, boolean trigger) {
		this.name = name;
		this.value = value;
		this.time = time;
		this.trigger = trigger;
	}
	public void run() {
		SoundThread st = new SoundThread();
		st.start();
	}
	public Object clone() {
		SoundAlertAction action = new SoundAlertAction();
		action.name = name;
		action.value = value;
		action.time = time;
		action.trigger = trigger;
		action.path = path;
		return action;
	}
	
	class SoundThread extends Thread {
		public SoundThread() {
			setDaemon(true);
		}
		public void run() {
			long sleepFor = 1;
	        try {
	            player = Applet.newAudioClip(new URL("file:///"+path));
	            FileInputStream fin = new FileInputStream(path);
	            sleepFor = Math.max(1,fin.available());
	            fin.close();
	        } catch (MalformedURLException e) {
	        	EditorPlugin.DBG.warning("bad URL for sound "+path);
	        } catch (IOException e) {
	        	EditorPlugin.DBG.warning("couldnt get file length for sound "+path);
	        	sleepFor = 20000;
	        }//end try catch
	        player.play();
//	        EditorPlugin.DBG.info("sound thread sleeping for "+sleepFor+"ms");
//	        try {
//	        	Thread.sleep(sleepFor);
//	        } catch (Exception e) {
//	        }
	        EditorPlugin.DBG.info("sound thread exiting");
		}
	}
}

