/**********************************************************************
 * Copyright (c) 2003,2004 Scapa Technologies Limited and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.variableloader.internal;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.hyades.model.statistical.*;
import org.eclipse.swt.graphics.Image;
import org.eclipse.hyades.statistical.ui.EditorPlugin;

/**
 * Does this really need get? NO
 * 
 * This variable representation will make all the necessary modifications to the 
 * variable in the statistical model and then proxy the modifications to the
 * VariableModifierRepresentation passed in in the constructor
 */
public class SDMeasuredVariable extends SDGenericVariable implements SDMeasuredVariableRepresentation {

Object value = null;

int type = NONE;

StatisticalFactory factory = StatisticalFactory.eINSTANCE;

SDDescriptor descriptor;
SDVariableModifierProxy modifier;

SDCounterDescriptor measured_desc;
SDSnapshotObservation measured;

Object last_measured;
long last_time;

	public int getMeasuredType() {
		return type;	
	}

	SDMeasuredVariable(String unique_id, String name, String description, Image image, boolean has_bar, int type, SDDescriptor descriptor, SDSampleWindow window) {
		super(unique_id,name,description,image,has_bar);
		this.type = type;
		this.descriptor = descriptor;
		
		if (type == STRING) {
			measured = factory.createSDTextObservation();
			last_measured = null;
		} else {
			measured = factory.createSDContiguousObservation();
			last_measured = null;
		}
		measured.setWindow(window);
		
		measured_desc = factory.createSDCounterDescriptor();
		measured_desc.setParent(descriptor);
		measured_desc.setName(name+" - "+EditorPlugin.getString("MEASURED"));
		measured_desc.setDescription(description);
		
		measured.setMemberDescriptor(measured_desc);
		
	//	descriptor.setRepresentation(this);
	}
	
	public SDSnapshotObservation getMeasuredObservation() {
		return measured;
	}
	
	public Object getLastMeasuredValue() {
		return last_measured;	
	}

	public long getLastMeasuredTime() {
		return last_time;	
	}
	
	private void addMeasuredValue(long t, Double d) {
		SDContiguousObservation obs = (SDContiguousObservation)measured;		

		BasicEList times = (BasicEList)obs.getCreationTime();
		BasicEList values = (BasicEList)obs.getValue();

		addValue(times,values, t, d);
		
		last_measured = d;
		last_time = t;
	}
	
	private void addMeasuredValue(long t, String s) {
		SDTextObservation obs = (SDTextObservation)measured;		

		BasicEList times = (BasicEList)obs.getCreationTime();
		BasicEList values = (BasicEList)obs.getTextValue();

		addValue(times,values, t, s);

		last_measured = s;
		last_time = t;
	}
	
	public void setMeasuredValue(long t, int i) throws ClassCastException {
		addMeasuredValue(t,new Double(i));
	}
	public void setMeasuredValue(long t, long i) throws ClassCastException {
		addMeasuredValue(t,new Double(i));
	}
	public void setMeasuredValue(long t, float i) throws ClassCastException {
		addMeasuredValue(t,new Double(i));
	}
	public void setMeasuredValue(long t, double i) throws ClassCastException {
		addMeasuredValue(t,new Double(i));
	}
	public void setMeasuredValue(long t, Object newval) throws ClassCastException {
		if (type == STRING) {
			addMeasuredValue(t,(String)newval);
		} else {
			addMeasuredValue(t,new Double(((Number)newval).doubleValue()));
		}
	}
}