/**********************************************************************
 * Copyright (c) 2003,2004 Scapa Technologies Limited and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.statistical.ui.widgets.alert.internal;

import java.util.*;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class AlertRegistry {
	
public static final String EXTENSION_POINT_ALERTACTION = "org.eclipse.hyades.statistical.ui.StatConAlertAction";
	
static Object LOCK = new Object();
static StatConAlertActionProvider[] providers;
static String[] provider_names;

	private static void loadProviders() {
		synchronized(LOCK) {
			if (providers == null) {
				
				ArrayList clazzes = getExtensionPointClasses(EXTENSION_POINT_ALERTACTION);
				providers = new StatConAlertActionProvider[clazzes.size()];
				for (int i = 0; i < providers.length; i++) {
					providers[i] = (StatConAlertActionProvider)clazzes.get(i);
					//System.out.println("Loaded alert action provider "+providers[i].getClass());
				}
		
				//System.out.println("Loaded "+providers.length+" alert action providers");
		
				provider_names = new String[providers.length];
				
				for (int i = 0; i < providers.length; i++) {
					provider_names[i] = providers[i].getName();
				}
			}
		}
	}
	
	public static StatConAlertActionProvider getProvider(String name) {
		loadProviders();
		for (int i = 0; i < provider_names.length; i++) {
			if (provider_names[i].equals(name)) {
				return providers[i];
			}
		}
		return null;
	}
	
	public static StatConAlertActionProvider[] getProviders() {
		loadProviders();
		return providers;
	}
	
	public static String[] getProviderNames() {
		loadProviders();
		return provider_names;
	}
	
	
	private static ArrayList getExtensionPointClasses(String extensionpointid) {
		
		ArrayList clazzes = new ArrayList();
		
		IExtensionRegistry registry = Platform.getExtensionRegistry();
//Print out all available extension points		
//		IExtensionPoint[] points = registry.getExtensionPoints();
//		for (int i = 0; i < points.length; i++) {
//			System.out.println("POINT:"+points[i].getUniqueIdentifier());
//		}
		
		IExtensionPoint point = registry.getExtensionPoint(extensionpointid);
		IExtension[] extensions = point.getExtensions();

		if (extensions != null) {
		
			for (int i = 0; i < extensions.length; i++) {
				IConfigurationElement[] configs = extensions[i].getConfigurationElements();
				
				for (int k = 0; k < configs.length; k++) {
					try {
						clazzes.add(configs[k].createExecutableExtension("class"));
					} catch (Throwable e) {
					}
				}
			}
		}
		
		return clazzes;
	}		
	
}