/**********************************************************************
 * Copyright (c) 2003,2004 Scapa Technologies Limited and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.widgets.grapher.internal;

import org.eclipse.hyades.statistical.ui.widgets.zoomslider.internal.*;
import org.eclipse.swt.graphics.*;

public class HistogramGraph implements Graph {
	
GraphSource source;
ZoomSlider yslider;
TimeZoomSlider xslider;

Color fg_col;
int line_width = 1;
int line_style = 1;

double scaling = 1.0;


double xoffset = 0;
double yoffset = 0;
	public HistogramGraph(GraphSource source, TimeZoomSlider xslider, ZoomSlider yslider, Color col) {
		this.source = source;
		this.fg_col = col;
		this.xslider = xslider;
		this.yslider = yslider;
	}

	public BasicGraphSource getGraphSource() {
		return source;	
	}

	public void setIndicatorSource(IndicatorSource isource) {
	}

	public double getXMin() {
		return source.getMin();		
	}

	public double getXMax() {
		return source.getMax();
	}

	public double getYMin() {
		return source.getValueMin();		
	}

	public double getYMax() {
		return source.getValueMax();		
	}
	
	public void setForeground(Color col) {
		fg_col = col;
	}
	
	public Color getForeground() {
		return fg_col;
	}
	

	public void setLineWidth(int w) {
		line_width = w;
	}
	
	public int getLineWidth() {
		return line_width;
	}
	
	public void setLineStyle(int swt_line_style) {
		line_style = swt_line_style;
	}
	
	public int getLineStyle() {
		return line_style;	
	}
	
	public void setUseIndicator(boolean b) {
	}

	public void paintGraph(GC gc, int x, int y, int w, int h) {

		gc.setForeground(fg_col);
		gc.setLineWidth(line_width);	
		gc.setLineStyle(line_style);

		double start = xslider.getMinVisible();
		double end = xslider.getMaxVisible();
		double res = xslider.getIncrement();

		int yzero = (int)yslider.value2Pixel(0);

		for (double i = start; i <= end; i+= res) {
			
			double cx = i;
			double cy = source.getValueAt(cx);
			if (Double.isNaN(cy) || Double.isInfinite(cy)) {
				cy = 0.0;	
			}
			//apply static scaling
			cy = cy * scaling;

			double pixel_x = xslider.value2Pixel(cx);
			double pixel_y = yslider.value2Pixel(cy);
			
			gc.drawLine((int)pixel_x,yzero,(int)pixel_x,(int)pixel_y);		
			
		}
	}

	public TimeZoomSlider getXSlider() {
		return xslider;	
	}

	public ZoomSlider getYSlider() {
		return yslider;	
	}

	public void setXSlider(TimeZoomSlider slider) {
		xslider = slider;
	}
	
	public void setYSlider(ZoomSlider slider) {
		yslider = slider;
	}

	public void setStaticScaling(double mult) {
		scaling = mult;
	}
	public double getStaticScaling() {
		return scaling;	
	} 
	
	public int getPlottingType() {
		return Graph.PLOTTING_TYPE_AVERAGE;
	}
	public void setPlottingType(int type) {
	}
	
	public void setPlottingPeriod(int type, double value) {
	}
	public int getPlottingPeriodType() {
		return Graph.PERIOD_TYPE_TICKS;
	}
	public double getPlottingPeriodValue() {
		return 1.0;
	}
	
	public void setXOffset(double millis) {
		xoffset = millis;
	}
	public double getXOffset() {
		return xoffset;
	}
	
	public void setYOffset(double millis) {
		yoffset = millis;
	}
	public double getYOffset() {
		return yoffset;
	}		
	public int getNoDataBehaviour() {
		return Graph.NODATA_DO_NOTHING;
	}
	public void setNoDataBehaviour(int i) {
	}

}