/**********************************************************************
 * Copyright (c) 2003,2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sdb.internal;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.LogUtil;
import org.eclipse.hyades.models.internal.sdb.impl.SDBFactoryImpl;
import org.eclipse.hyades.models.internal.sdb.impl.SDBPackageImpl;
import org.eclipse.hyades.models.internal.sdb.impl.SDBResourceSetImpl;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class SDbPlugin extends AbstractUIPlugin
{
	private static SDbPlugin inst;
	private static ResourceBundle fResourceBundle;
	private SDBFactoryImpl factory;
	private ResourceSet resourceSet;
	private IPreferenceStore preferenceStore;
	public static final String PLUGIN_ID = "org.eclipse.hyades.sdb"; //$NON-NLS-1$

	public SDbPlugin() {

		if (inst == null)
			inst = this;
		
	}
	public static SDbPlugin getDefault() {
		return inst;
	}

	public static String getPluginId() {
		return PLUGIN_ID;
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (2/16/2001 4:57:29 PM)
	 * @return com.ibm.jface.resource.ImageDescriptor
	 * @param name java.lang.String
	 */
	public static ImageDescriptor getImageDescriptor(String name) {
		return SDbPluginImages.getImageDescriptor(name);
	}
	public static ResourceBundle getResourceBundle() {
	
		if(fResourceBundle == null)
		{
			try {
				fResourceBundle = Platform.getResourceBundle(Platform.getBundle(PLUGIN_ID));
			} catch (MissingResourceException e) {
				e.printStackTrace();
				fResourceBundle = null;
			}
		}
				
		return fResourceBundle;
	}
	
	public static String getResourceString(String key) {
		ResourceBundle bundle = SDbPlugin.getResourceBundle();
		try {
			return bundle.getString(key);
		} catch (MissingResourceException e) {
			return key;
		}
	}
	
	/* (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		
		super.stop(context);
		
		savePluginPreferences();
		SDbPluginImages.shutdown();
		
	}
	
	/* (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		
		SDBPackageImpl.init();
		factory = new SDBFactoryImpl();

		// init resourceSet
		resourceSet = SDBResourceSetImpl.getInstance();

		super.start(context);
	}

	public SDBFactoryImpl getSDBFactory() {
		if (factory == null)
			factory = new SDBFactoryImpl();
		return factory;
	}

	/*
	 * 
	 */
	public ResourceSet getResourceSet() {
		return resourceSet;
	}

	/**
	 * Sets default preference values. These values will be used
	 * until some preferences are actually set using Preference dialog.
	 */
	protected void initializeDefaultPreferences(IPreferenceStore store) {
		LogUtil.initializePreferenceStore(store);
	}

	public void log(IStatus status) {
		getLog().log(status);
	}
	
	public void log(Throwable e) {
		log(new Status(IStatus.ERROR, PLUGIN_ID, IStatus.ERROR, "Error", e)); //$NON-NLS-1$
	}
	
	public IPreferenceStore getPreferenceStore(){
		if (preferenceStore == null)
			preferenceStore = LogUtil.doGetPreferenceStore();
		return preferenceStore;
	}
	
	public void savePreferences(){
		LogUIPlugin.getDefault().savePluginPreferences();
	}

}
