/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sdb.internal.editors;

import org.eclipse.hyades.sdb.internal.*;
import org.eclipse.hyades.sdb.internal.util.*;
import org.eclipse.jface.resource.*;
import org.eclipse.swt.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;

public class EditorPage implements PaintListener{
	private String title = "";
	private Font titleFont;
	private int TITLE_HMARGIN = 10;
	private int TITLE_VMARGIN = 5;

	private Composite control;
	protected RASWidgetFactory factory;
	private int readOnly;
	private org.eclipse.swt.graphics.Color headingBackground;
	private Color headingForeground;
	private Image headingImage;
	private boolean headingVisible=true;

    
	class PageLayout extends Layout {
		protected Point computeSize(
			Composite composite,
			int wHint,
			int hHint,
			boolean flushCache) {
			if (wHint != SWT.DEFAULT && hHint != SWT.DEFAULT)
				return new Point(wHint, hHint);
			int x = 0;
			Control client = composite.getChildren()[0];
			Point csize = client.computeSize(SWT.DEFAULT, SWT.DEFAULT, flushCache);
			if (headingVisible) csize.y += getTitleHeight();
			return csize;
		}
		protected void layout(Composite composite, boolean flushCache) {
			Rectangle clientArea = composite.getClientArea();
			Control client = composite.getChildren()[0];
			int theight = headingVisible?getTitleHeight() : 0;
			client.setBounds(
				clientArea.x,
				clientArea.y + theight,
				clientArea.width,
				clientArea.height - theight);
				
		}
	}

public EditorPage(RASWidgetFactory factory) {
	this.factory = factory;
   	titleFont = JFaceResources.getHeaderFont();
}


public Control getContent(Composite parent) {

	if(isWhiteBackground())
		setHeadingImage(SDbPluginImages.getImage(SDbPluginImages.IMG_DB_EDITOR_BAN));
	Canvas canvas = new Canvas(parent, SWT.NONE);
	canvas.setBackground(factory.getBackgroundColor());
	canvas.setForeground(factory.getForegroundColor());
	canvas.addPaintListener(this);
	canvas.setLayout(new PageLayout());

    Composite formParent = factory.createComposite(canvas);
	GridLayout layout = new GridLayout();	
	layout.numColumns = 1;
	formParent.setLayout(layout);
	formParent.setLayoutData(new GridData(GridData.FILL_BOTH));

	createContent(formParent);
	this.control = canvas;
	return canvas;

}

public Control getContent(){
	return control;
}

protected void createContent(Composite parent){

};

public org.eclipse.swt.graphics.Color getHeadingBackground() {
	return headingBackground;
}
public org.eclipse.swt.graphics.Color getHeadingForeground() {
	return headingForeground;
}
public Image getHeadingImage() {
	return headingImage;
}

public boolean isHeadingVisible() {
	return headingVisible;
}

public final void paintControl(PaintEvent event) {
	if (!headingVisible) return;
	GC gc = event.gc;
	Control page = (Control)event.widget;
	paint(page, gc);
}

private void paint(Control form, GC gc) {
	Rectangle bounds = form.getBounds();
	int height = getTitleHeight();
	if (headingImage != null) {
		Rectangle imageBounds = headingImage.getBounds();

		if (headingBackground != null) {
			gc.setBackground(headingBackground);
			gc.fillRectangle(0, 0, bounds.width, height);
		}
		if (SWT.getPlatform().equals("motif")==false) {
	       gc.drawImage(headingImage, 0, 0);
		}
		if (headingForeground != null)
			gc.setForeground(headingForeground);
		else
			gc.setForeground(factory.getForegroundColor());
		gc.setFont(titleFont);
		gc.drawText(getTitle(), TITLE_HMARGIN, TITLE_VMARGIN, true);
	} else {
		gc.setFont(titleFont);
		gc.setBackground(factory.getColor(RASWidgetFactory.DEFAULT_HEADER_COLOR));
		gc.setForeground(factory.getForegroundColor());
		gc.drawText(getTitle(), TITLE_HMARGIN, TITLE_VMARGIN, true);
	}
}


public void setHeadingBackground(org.eclipse.swt.graphics.Color newHeadingBackground) {
	headingBackground = newHeadingBackground;
}

public void setHeadingForeground(org.eclipse.swt.graphics.Color newHeadingForeground) {
	headingForeground = newHeadingForeground;
}

public void setHeadingImage(Image headingImage) {
	this.headingImage = headingImage;
}

public void setHeadingVisible(boolean newHeadingVisible) {
	if (newHeadingVisible != headingVisible) {
		headingVisible = newHeadingVisible;
		if (control != null)
			control.layout(true);
	}
}

public String getTitle() {
	return title;
}

private int getTitleHeight() {
	int imageHeight = 0;
	if (headingImage!=null && SWT.getPlatform().equals("motif")==false) {
		imageHeight = headingImage.getBounds().height;
	}
	GC gc = new GC(control);
	gc.setFont(titleFont);
	FontMetrics fm = gc.getFontMetrics();
	int fontHeight = fm.getHeight();
	gc.dispose();

	int height =  fontHeight + TITLE_VMARGIN + TITLE_VMARGIN;
	return Math.max(height, imageHeight);
}

private boolean isWhiteBackground() {	
	Color bg = factory.getBackgroundColor();
	return (bg.getRed() == 255 && bg.getGreen() == 255 && bg.getBlue() == 255);

}

public void setTitle(java.lang.String newTitle) {
	title = newTitle;
	if (control!=null) control.redraw();
}



}
