/**********************************************************************
 * Copyright (c) 2003,2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sdb.internal.preferences;

import java.util.ArrayList;

import org.eclipse.hyades.log.ui.internal.util.LogUIConstants;
import org.eclipse.hyades.sdb.internal.SDbPlugin;
import org.eclipse.hyades.sdb.internal.SDbPluginImages;
import org.eclipse.hyades.sdb.internal.help.ContextIds;
import org.eclipse.hyades.sdb.internal.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class SymptomDBurl implements SelectionListener {

	class EditDialog extends Dialog implements ModifyListener {
		private String _name;
		private String _value;
		private Text _nameText;
		private Text _valueText;
		private String _title;

		public EditDialog(Shell shell, String title, String name, String value) {
			super(shell);

			_name = name;
			_value = value;
			_title = title;
		}

		protected void configureShell(Shell shell) {
			super.configureShell(shell);
			shell.setText(_title);
		}

		public void name(String name) {
			_name = name;
		}

		public String name() {
			return _name;
		}

		public void value(String value) {
			_value = value;
		}

		public String value() {
			return _value;
		}

		protected Control createDialogArea(Composite parent) {
			Composite result = (Composite) super.createDialogArea(parent);

			GridLayout layout;
			GridData data;
			Label label;

			layout = new GridLayout();
			layout.numColumns = 2;
			result.setLayout(layout);
			data = GridUtil.createFill();
			//data.heightHint = 50; Fix for Linux - 221790
			data.widthHint = 400;
			result.setLayoutData(data);

			label = new Label(result, SWT.NULL);
			label.setText(SDbPlugin.getResourceString("STR_URL_DB_NAME"));
			_nameText = new Text(result, SWT.BORDER);
			_nameText.setLayoutData(GridUtil.createHorizontalFill());

			label = new Label(result, SWT.NULL);
			label.setText(SDbPlugin.getResourceString("STR_URL_DB_URL"));
			_valueText = new Text(result, SWT.BORDER);
			_valueText.setLayoutData(GridUtil.createHorizontalFill());

			_nameText.addModifyListener(this);
			_valueText.addModifyListener(this);

			if (_name != null)
				_nameText.setText(_name);
			if (_value != null)
				_valueText.setText(_value);

			if (_title.equals(SDbPlugin.getResourceString("STR_URL_LOCATION_DLG"))) {
				WorkbenchHelp.setHelp(_nameText, ContextIds.SYMDB_PREF_URL_ADD_DIALOG_NAME);
				WorkbenchHelp.setHelp(_valueText, ContextIds.SYMDB_PREF_URL_ADD_DIALOG_URL);
			}
			else if (_title.equals(SDbPlugin.getResourceString("STR_EURL_LOCATION_DLG"))) {
				WorkbenchHelp.setHelp(_nameText, ContextIds.SYMDB_PREF_URL_EDIT_DIALOG_NAME);
				WorkbenchHelp.setHelp(_valueText, ContextIds.SYMDB_PREF_URL_EDIT_DIALOG_URL);
			}

			return result;
		}

		public void modifyText(ModifyEvent e) {
			if (e.widget == _nameText || e.widget == _valueText) {
				if (getButton(IDialogConstants.OK_ID) != null)
					getButton(IDialogConstants.OK_ID).setEnabled(_nameText.getText().trim() != "");
			}
		}

		protected void okPressed() {

			_name = _nameText.getText().trim();
			_value = _valueText.getText().trim();
			super.okPressed();
		}

	}

	class ColumnData {
		private String _name;
		private String _url;

		public ColumnData(String name, String url) {
			_name = name;
			_url = url;
		}

		public String name() {
			return _name;
		}
		public String url() {
			return _url;
		}

		public void name(String name) {
			_name = name;
		}

		public void url(String url) {
			_url = url;
		}
	}

	private Composite result;
	private Table _list;
	private Button _moveUp;
	private Button _moveDown;
	private Button _restoreDefaults;
	private ArrayList _data = new ArrayList();
	private Item _oldSelection;
	private Button _add;
	private Button _edit;
	private Button _delete;
	private static final int _restoreDefaultsButtonId =
		IDialogConstants.CLIENT_ID + 1;

	public SymptomDBurl() {
		super();
	}

	/**
	 */
	public Composite createControl(Composite parent) {
		result = new Composite(parent, SWT.NONE);

		GridLayout layout;
		GridData data;

		layout = new GridLayout();
		layout.numColumns = 3;
		layout.verticalSpacing = 15;
		result.setLayout(layout);
		data = GridUtil.createFill();
		data.heightHint = 400;
		data.widthHint = 400;
		result.setLayoutData(data);

		Label label = new Label(result, SWT.NULL);
		data = GridUtil.createHorizontalFill();
		data.horizontalSpan = 3;
		data.heightHint = 10;
		label.setLayoutData(data);

		Label description = new Label(result, SWT.NONE);
		description.setText(SDbPlugin.getResourceString("STR_DB_URL_LOCATIONS"));

		Composite dataComp = new Composite(result, SWT.NULL);
		layout = new GridLayout();
		layout.numColumns = 2;
		dataComp.setLayout(layout);
		data = GridUtil.createFill();
		data.heightHint = 250;
		data.horizontalSpan = 3;
		dataComp.setLayoutData(data);

		_list = new Table(dataComp, SWT.BORDER | SWT.H_SCROLL);
		data = GridUtil.createFill();
		_list.setLayoutData(data);

		Composite buttonWidget = new Composite(dataComp, SWT.NONE);
		data = new GridData();
		data.grabExcessVerticalSpace = true;
		data.verticalAlignment = GridData.FILL;
		buttonWidget.setLayoutData(data);
		GridLayout blayout = new GridLayout();
		blayout.numColumns = 1;
		buttonWidget.setLayout(blayout);

		_moveUp = new Button(buttonWidget, SWT.NULL);
		data = new GridData();
		data.grabExcessHorizontalSpace = true;
		data.horizontalAlignment = GridData.FILL;
		_moveUp.setLayoutData(data);
		_moveUp.setText(SDbPlugin.getResourceString("STR_COL_DLG_UP"));

		_moveDown = new Button(buttonWidget, SWT.NULL);
		data = new GridData();
		data.grabExcessHorizontalSpace = true;
		data.horizontalAlignment = GridData.FILL;
		_moveDown.setLayoutData(data);
		_moveDown.setText(SDbPlugin.getResourceString("STR_COL_DLG_DOWN"));

		label = new Label(buttonWidget, SWT.NULL);

		_edit = new Button(buttonWidget, SWT.NULL);
		data = GridUtil.createHorizontalFill();
		data.horizontalAlignment = GridData.FILL;
		data.verticalAlignment = GridData.CENTER;
		_edit.setLayoutData(data);
		_edit.setText(
			SDbPlugin.getResourceString(SDbPlugin.getResourceString("STR_EDIT_LOCATION")));

		_add = new Button(buttonWidget, SWT.NULL);
		data = GridUtil.createHorizontalFill();
		data.horizontalAlignment = GridData.FILL;
		data.verticalAlignment = GridData.CENTER;
		_add.setLayoutData(data);
		_add.setText(
			SDbPlugin.getResourceString(SDbPlugin.getResourceString("STR_ADD_LOCATION")));

		_delete = new Button(buttonWidget, SWT.NULL);
		data = GridUtil.createHorizontalFill();
		data.horizontalAlignment = GridData.FILL;
		data.verticalAlignment = GridData.CENTER;
		_delete.setLayoutData(data);
		_delete.setText(
			SDbPlugin.getResourceString(SDbPlugin.getResourceString("STR_DEL_LOCATION")));

		_list.addSelectionListener(this);
		_moveUp.addSelectionListener(this);
		_moveDown.addSelectionListener(this);
		_add.addSelectionListener(this);
		_edit.addSelectionListener(this);
		_delete.addSelectionListener(this);

		_moveUp.setEnabled(false);
		_moveDown.setEnabled(false);

		WorkbenchHelp.setHelp(_list, ContextIds.SYMDB_PREF_URL);

		return result;
	}

	/**
	 * Insert the method's description here.
	 * Creation date: (3/8/2001 4:13:01 PM)
	 * @return java.util.ArrayList
	 */
	public ArrayList getData() {
		return _data;
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (3/7/2001 3:30:47 PM)
	 * @param idx int
	 */
	protected void moveDown(int idx) {
		TableItem item = _list.getItem(idx);
		ColumnData data = (ColumnData) item.getData();
		TableItem newitem = new TableItem(_list, SWT.CHECK, idx + 2);
		newitem.setImage(SDbPluginImages.getImage(SDbPluginImages.IMG_SYMPTOM_DESC));
		newitem.setChecked(item.getChecked());
		newitem.setText(item.getText());

		newitem.setData(data);

		newitem.setGrayed(item.getGrayed());

		_list.remove(idx);

		_list.select(idx + 1);

	}
	/**
	 * Insert the method's description here.
	 * Creation date: (3/7/2001 3:30:47 PM)
	 * @param idx int
	 */
	protected void moveUp(int idx) {
		TableItem item = _list.getItem(idx);

		ColumnData data = (ColumnData) item.getData();

		if (idx > 0) {
			TableItem previousItem = _list.getItem(idx - 1);
			ColumnData previousItemData = (ColumnData) previousItem.getData();
		}

		TableItem newitem = new TableItem(_list, SWT.CHECK, idx - 1);
		newitem.setChecked(item.getChecked());
		newitem.setText(item.getText());
		newitem.setImage(SDbPluginImages.getImage(SDbPluginImages.IMG_SYMPTOM_DESC));

		newitem.setData(data);
		newitem.setGrayed(item.getGrayed());

		_list.remove(idx + 1);

		_list.select(idx - 1);
	}

	/*
	 * 
	 */

	public void widgetDefaultSelected(SelectionEvent e) {
		widgetSelected(e);
	}
	public void widgetSelected(SelectionEvent e) {
		if (e.widget == _moveUp) {
			int idx = _list.getSelectionIndex();

			if (idx > 0)
				moveUp(idx);

		} else if (e.widget == _moveDown) {
			int idx = _list.getSelectionIndex();

			if (idx != -1 && (idx < _list.getItemCount() - 1))
				moveDown(idx);

		} else if (e.widget == _add) {
			showUrlDialog(SDbPlugin.getResourceString("STR_URL_LOCATION_DLG"), null, null);
		} else if (e.widget == _edit) {

			int idx = _list.getSelectionIndex();
			if (idx != -1) {
				ColumnData data = (ColumnData) _list.getItem(idx).getData();
				if (data != null)
					showUrlDialog(SDbPlugin.getResourceString("STR_EURL_LOCATION_DLG"), data.name(), data.url());
			}

		} else if (e.widget == _delete) {
			int idx = _list.getSelectionIndex();
			if (idx != -1) {
				_list.getItem(idx).dispose();
			}
		}

		int idx = _list.getSelectionIndex();

		ColumnData data = null;
		ColumnData previousData = null;
		if (idx > 0) {
			previousData = (ColumnData) _list.getItem(idx - 1).getData();
		}
		if (idx != -1) {
			data = (ColumnData) _list.getItem(idx).getData();
		}

		_moveUp.setEnabled(data != null && previousData != null);
		_moveDown.setEnabled(data != null && (idx < _list.getItemCount() - 1));
		_delete.setEnabled(idx != -1);
		_edit.setEnabled(idx != -1);

	}

	/**
	 * Stores the values of the controls back to the preference store.
	 */
	public void storeValues(IPreferenceStore store) {
		String str = "";
		for (int idx = 0; idx < _list.getItemCount(); idx++) {
			TableItem item = _list.getItem(idx);
			ColumnData data = (ColumnData) item.getData();

			if (str != null)
				str += "\n" + data.name() + "\t" + data.url();
		}

		if (str.startsWith("\n") && str.length() > 1)
			str = str.substring(1);

		store.setValue(LogUIConstants.SYMPTOM_DB_URL_32, str);
	}

	/**
	 * Insert the method's description here.
	 * Creation date: (8/8/2001 3:43:13 PM)
	 */
	private void showUrlDialog(String title, String name, String value) {

		EditDialog dialog = new EditDialog(result.getShell(), title, name, value);
		dialog.open();

		if (dialog.getReturnCode() == Window.OK) {

			if (name == null) {
				ColumnData data = new ColumnData(dialog.name(), dialog.value());

				TableItem item = new TableItem(_list, SWT.NONE);
				item.setText(data.name() + "[" + data.url() + "]");
				item.setImage(SDbPluginImages.getImage(SDbPluginImages.IMG_SYMPTOM_DESC));

				item.setData(data);
			} else {
				int idx = _list.getSelectionIndex();
				if (idx != -1) {
					TableItem item = _list.getItem(idx);
					ColumnData data = (ColumnData) item.getData();
					if (data != null) {
						data.name(dialog.name());
						data.url(dialog.value());
						item.setText(data.name() + " [ " + data.url() + " ] ");
					}
				}
			}
		}
	}

	/*
	 * 
	 */
	public void initializeValues(String urls) {

		while (_list.getItemCount() > 0)
			_list.getItem(0).dispose();

		//urls = name\tvalue\nname\tvalue
		if (urls != null && !urls.equals("")) {
			int idx = urls.indexOf("\n");
			while (idx != -1) {
				String value = urls.substring(0, idx);
				int i = value.indexOf("\t");
				if (i != -1) {
					ColumnData data = new ColumnData(value.substring(0, i), value.substring(i + 1));
					TableItem item = new TableItem(_list, SWT.NONE);
					item.setText(data.name() + " [ " + data.url() + " ] ");
					item.setImage(SDbPluginImages.getImage(SDbPluginImages.IMG_SYMPTOM_DESC));

					item.setData(data);

				}

				urls = urls.substring(idx + 1);
				idx = urls.indexOf("\n");
			}

			int i = urls.indexOf("\t");
			if (i != -1) {
				ColumnData data = new ColumnData(urls.substring(0, i), urls.substring(i + 1));
				TableItem item = new TableItem(_list, SWT.NONE);
				item.setText(data.name() + " [ " + data.url() + " ] ");
				item.setImage(SDbPluginImages.getImage(SDbPluginImages.IMG_SYMPTOM_DESC));

				item.setData(data);

			}
		}

		int idx = _list.getSelectionIndex();
		_delete.setEnabled(idx != -1);
		_edit.setEnabled(idx != -1);

	}

}
