/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sdb.internal.util;

import java.text.*;
import java.util.*;

import org.eclipse.core.runtime.*;
import org.eclipse.emf.common.util.*;
import org.eclipse.hyades.models.internal.sdb.*;

public class SymptomDBExportToV4Util
{
 
  protected final String NL = System.getProperties().getProperty("line.separator");
  protected final String TEXT_1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + NL + "" + NL + "<!DOCTYPE symfile [" + NL + "<!-- ../dtd/symlog.dtd -->" + NL + "<!ELEMENT symrec ( matchsymptomv | nomatchsymptomv | symptominfov )* >" + NL + "<!ATTLIST symrec" + NL + "       recordid CDATA #REQUIRED" + NL + "       symptomtype CDATA #IMPLIED" + NL + "       symptomstatus CDATA #IMPLIED>" + NL + "" + NL + "<!ELEMENT symfile ( filterrecv | symrecv )* >" + NL + "<!ATTLIST symfile" + NL + "       totalrecords CDATA #IMPLIED" + NL + "       filtername CDATA #REQUIRED>" + NL + "" + NL + "<!ELEMENT symrecv ( symrec )* >" + NL + "" + NL + "<!ELEMENT nomatchsymptomv ( #PCDATA )* >" + NL + "" + NL + "<!ELEMENT symfilterrec ( symrecv | symfilterrecv )* >" + NL + "<!ATTLIST symfilterrec" + NL + "       filtername CDATA #REQUIRED" + NL + "       filtervalue CDATA #IMPLIED" + NL + "       sortfield CDATA #IMPLIED" + NL + "       severity CDATA #REQUIRED>" + NL + "" + NL + "<!ELEMENT filterrecv ( symfilterrec )* >" + NL + "" + NL + "<!ELEMENT matchsymptomv ( #PCDATA )* >" + NL + "" + NL + "<!ELEMENT symptominfov ( #PCDATA )* >" + NL + "" + NL + "<!ELEMENT symfilterrecv ( symfilterrec )* >" + NL + "" + NL + "]>" + NL + "" + NL + "<!--  Created on " + new SimpleDateFormat("EEEE, MMMMM dd, yyyy 'at' h:mm:ss:SSSS a z").format(new Date()) + " -->" + NL;
  protected final String TEXT_2 = NL + "<symfile totalrecords=\"";
  protected final String TEXT_3 = "\" filtername=\"None\">" + NL + "  <symrecv>";
  protected final String TEXT_4 = NL + "    <symrec recordid=\"Symptom_";
  protected final String TEXT_5 = "\" symptomtype=\"\" symptomstatus=\"diagnosed\">" + NL + "      <matchsymptomv>";
  protected final String TEXT_6 = NL;
  protected final String TEXT_7 = NL + "      </matchsymptomv>" + NL + "      <symptominfov>";
  protected final String TEXT_8 = NL;
  protected final String TEXT_9 = NL;
  protected final String TEXT_10 = NL + "      </symptominfov>" + NL + "    </symrec>";
  protected final String TEXT_11 = NL + "  </symrecv>" + NL + "</symfile>";

 	public String normalize(String string) {

		if (string == null)
			return "null";

		StringBuffer normalizedString = new StringBuffer();
		char character;

		//Check all characters 
		for (int counter = 0; counter < string.length(); counter++) {

			character = string.charAt(counter);

			if (character == '<')
				normalizedString.append("&lt;");

			else if (character == '>')
				normalizedString.append("&gt;");

			else if (character == '&')
				normalizedString.append("&amp;");

			else if (character == '"')
				normalizedString.append("&quot;");

			else if (character == '\'')
				normalizedString.append("&apos;");

			else
				normalizedString.append(character);
		}

		return (normalizedString.toString());
	}
 
  /**
   * Generate symtom db xml v4 from a SDBRuntime object
   */
  public String generate(SDBRuntime root, IProgressMonitor monitor)
  {
    StringBuffer stringBuffer = new StringBuffer();
    stringBuffer.append(TEXT_1);
      EList symptList = root.getSymptoms();
    int units = symptList.size();

    stringBuffer.append(TEXT_2);
    stringBuffer.append(units);
    stringBuffer.append(TEXT_3);
    
    for(int i=0;i<symptList.size();i++){
       SDBSymptom current = (SDBSymptom)symptList.get(i);
       EList solList = current.getSolutions();
       EList matchPatterns = current.getPatterns();
    stringBuffer.append(TEXT_4);
    stringBuffer.append(i);
    stringBuffer.append(TEXT_5);
    
          for(int j =0;j<matchPatterns.size();j++){
    stringBuffer.append(TEXT_6);
    stringBuffer.append(normalize(((SDBMatchPattern)matchPatterns.get(j)).getValue()));
         }
    stringBuffer.append(TEXT_7);
    
         for(int j =0;j<solList.size();j++){
         SDBSolution sol = (SDBSolution)solList.get(j);
         EList dirList = sol.getDirectives();
         if(sol.getDescription().length()>0){
		    stringBuffer.append(TEXT_8);
		    stringBuffer.append(normalize(sol.getDescription()));
		 }
         
         for(int k=0;k<dirList.size();k++){
           SDBDirective dir = (SDBDirective)dirList.get(k);
           if(dir.getDescription().length()>0){
			    stringBuffer.append(TEXT_8);
			    stringBuffer.append(normalize(dir.getDescription()));
			}
            if(dir.getDirectiveString().length()>0){
			    stringBuffer.append(TEXT_9);
			    stringBuffer.append(normalize(dir.getDirectiveString()));
			}
           }
         }
    stringBuffer.append(TEXT_10);
    
       monitor.worked(8000/units);
    }
    stringBuffer.append(TEXT_11);
    return stringBuffer.toString();
  }
}
