/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.cbe;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.util.Date;

import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;


/**
 * @author slavescu
 */
public class CBEUtils {
    //~ Methods ------------------------------------------------------------------------------------

    public static double computeAdjustedCreationTime(CBECommonBaseEvent event) {
        double creationTime = event.getCreationTime();

        try {
            return creationTime + event.getAgent().getAgentProxy().getProcessProxy().getNode().getDeltaTime();
        } catch (Exception e) {
        }

        return creationTime;
    }
    
	/**
	 * Method formatCreationTime.
	 * @param element
	 * @return String
	 */
	public static String formatCreationTime(CBECommonBaseEvent event, DateFormat dateFormat) {

		// If time is not specified, use "0".
		if (event.getCreationTime() != 0)
		{
			try {
				short value = event.getTimeZone();				
				double ct = computeAdjustedCreationTime(event);
				Double l2 = new Double(ct);

				String microseconds = ""+(((Double)l2).longValue() % 1000000);
				String ms = "."+"000000".substring(0,6-microseconds.length()) + microseconds;
				ms = ms + (value>0?"+00":"-00").substring(0,3-(""+Math.abs(value/60)).length())+Math.abs(value/60);
				ms = ms + ":00".substring(0,3-(""+Math.abs(value%60)).length())+Math.abs(value%60);
				
				StringBuffer toAppendTo = new StringBuffer();
				FieldPosition fieldPosition = new FieldPosition(DateFormat.SECOND_FIELD);
				dateFormat.format(new Date(((Double)l2).longValue()/1000 + value*60*1000), toAppendTo, fieldPosition);

				if (fieldPosition.getEndIndex() > 0) {
					toAppendTo.insert(fieldPosition.getEndIndex(), ms);
				}

				return toAppendTo.toString();

			} catch (Exception e) {
			}
		}
		
		return "0";

	}
}
