package org.eclipse.hyades.logging.events.cbe;

/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Exception thrown by the <code>EventFormatter</code> methods to indicate that 
 * a serialization or de-serialization error has occurred.
 *
 * @author Paul E. Slauenwhite
 * @version 1.0.1
 * @since 1.0.1
 */
public class FormattingException extends EventException {
    
    /**
     * Simple constructor.
     */
    public FormattingException() {
        super();
    }

    /**
     * Constructs a <code>FormattingException</code> with the specified detail
     * message.
     *
     * @param msg            the detail message
     */
    public FormattingException(String msg) {
        super(msg);
    }

    /**
     * Constructs a <code>FormattingException</code> with the specified detail
     * message and a nested exception.
     *
     * @param msg            the detail message
     * @param cause The nested exception, or <code>null</code>, if a nested
     *        exception is not appropriate.
     */
    public FormattingException(String msg, Throwable cause) {
        super(msg,cause);
    }
    /**
     * Creates a <code>FormattingException</code> with a detail message, message
     * translation information (resource bundle, message key and message
     * substitutions).
     *
     * @param key The message key.
     * @param file The name of the message file to use.
     */
    public FormattingException(String key, String file) {
        super(key, file, null);
    }

    /**
     * Creates a <code>FormattingException</code> with a detail message, message
     * translation information (resource bundle, message key and message
     * substitutions).
     *
     * @param key The message key.
     * @param file The name of the message file to use.
     * @param parms An array of elements to be inserted into the message.
     */
    public FormattingException(String key, String file, Object[] parms) {
        super(key, file, parms);
    }

    /**
     * Creates a <code>FormattingException</code> with a detail message, message
     * translation information (resource bundle, message key and message
     * substitutions) and a nested exception.
     *
     * @param key The message key.
     * @param file The name of the message file to use.
     * @param parms An array of elements to be inserted into the message.
     * @param cause The nested exception, or <code>null</code>, if a nested
     *        exception is not appropriate.
     */
    public FormattingException(String key, String file, Object[] parms, Throwable cause) {
        super(key, file, parms, cause);
    }

    /**
     * Construct a new <code>FormattingException</code> with
     * a null detail message and a cause field set to the specified
     * Throwable. Subsequent calls to the {@link #initCause} method
     * on this instance will result in an exception. The value of
     * the cause field may be retrieved at any time via the {@link
     * #getCause()} method.
     *
     * @param cause the Throwable that was caught and is considered
     *        the root cause of this exception. Null is tolerated.
     */
    public FormattingException(Exception cause) {
        super(cause);
    }
}
