package org.eclipse.hyades.logging.events.cbe.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.logging.events.cbe.DependencySituation;
import org.eclipse.hyades.logging.events.cbe.EventPackage;
import org.eclipse.hyades.logging.events.cbe.ValidationException;
import org.eclipse.hyades.logging.events.cbe.util.EventHelpers;
import org.eclipse.hyades.logging.events.cbe.util.EventValidation;

/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Dependency Situation</b></em>'.
 * 
 * @author Denilson Nastacio
 * @version 1.0.1
 * @since 1.0.1
 * @implements Cloneable
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.DependencySituationImpl#getDependencyDisposition <em>Dependency Disposition</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class DependencySituationImpl extends SituationTypeImpl implements DependencySituation, Cloneable {

    /** Automatically generated javadoc for: serialVersionUID */
    private static final long serialVersionUID = -5050575227459575744L;

    /**
     * Classname for trace/log 
     */
    private static final String CLASS_NAME = DependencySituationImpl.class.getName();

    /**
     * The default value of the '{@link #getDependencyDisposition() <em>Dependency Disposition</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getDependencyDisposition()
     * @generated
     * @ordered
     */
    protected static final String DEPENDENCY_DISPOSITION_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getDependencyDisposition() <em>Dependency Disposition</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getDependencyDisposition()
     * @generated
     * @ordered
     */
    protected String dependencyDisposition = DEPENDENCY_DISPOSITION_EDEFAULT;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected DependencySituationImpl() {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EClass eStaticClass() {
        return EventPackage.eINSTANCE.getDependencySituation();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getDependencyDisposition() {
        return dependencyDisposition;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setDependencyDisposition(String newDependencyDisposition) {
        String oldDependencyDisposition = dependencyDisposition;
        dependencyDisposition = newDependencyDisposition;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.DEPENDENCY_SITUATION__DEPENDENCY_DISPOSITION, oldDependencyDisposition, dependencyDisposition));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.DEPENDENCY_SITUATION__REASONING_SCOPE :
                return getReasoningScope();
            case EventPackage.DEPENDENCY_SITUATION__DEPENDENCY_DISPOSITION :
                return getDependencyDisposition();
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.DEPENDENCY_SITUATION__REASONING_SCOPE :
                setReasoningScope((String) newValue);
                return;
            case EventPackage.DEPENDENCY_SITUATION__DEPENDENCY_DISPOSITION :
                setDependencyDisposition((String) newValue);
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eUnset(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.DEPENDENCY_SITUATION__REASONING_SCOPE :
                setReasoningScope(REASONING_SCOPE_EDEFAULT);
                return;
            case EventPackage.DEPENDENCY_SITUATION__DEPENDENCY_DISPOSITION :
                setDependencyDisposition(DEPENDENCY_DISPOSITION_EDEFAULT);
                return;
        }
        eDynamicUnset(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.DEPENDENCY_SITUATION__REASONING_SCOPE :
                return REASONING_SCOPE_EDEFAULT == null ? reasoningScope != null : !REASONING_SCOPE_EDEFAULT.equals(reasoningScope);
            case EventPackage.DEPENDENCY_SITUATION__DEPENDENCY_DISPOSITION :
                return DEPENDENCY_DISPOSITION_EDEFAULT == null ? dependencyDisposition != null : !DEPENDENCY_DISPOSITION_EDEFAULT.equals(dependencyDisposition);
        }
        return eDynamicIsSet(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String toString() {
        if (eIsProxy())
            return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (dependencyDisposition: ");
        result.append(dependencyDisposition);
        result.append(')');
        return result.toString();
    }

    /**
     * Checks whether the contents of the instance conform to the
     * CBE specification.
     *
     * @throws ValidationException 
     *                       if the event instance does not follow the 
     *                       CBE specification.
     */
    public void validate() throws ValidationException {

        synchronized(this){

	        // checking super class 
	        super.validate();
	
	        // parent class already checked for required attributes
	        //EventValidation.validateRequiredAttributes(this};
	
	        // checking for boundaries
	        EventPackage ePck = EventPackage.eINSTANCE;
	        EAttribute attr = ePck.getDependencySituation_DependencyDisposition();
	        EventValidation.validateLength(CLASS_NAME, this, attr, DISPOSITION_MAX_LENGTH);
        }
    }

	/**
	 * return a cloned (copy by value) object. This is a deep copy version, in which all the
	 * objects within this object will be copied by value.
	 *  
	 * @return Object
	 */
	public Object clone() throws CloneNotSupportedException {

        synchronized(this){
            return EcoreUtil.copy(this);
        }       
	}

	/**
	 * Overrides the <code>java.lang.Object</code>'s equals() API to 
	 * determine if the parameter <code>object</code> is equal to this object.
	 * 
	 * @param object The <code>java.lang.Object</code> to be compared to this object.
	 * @return true if this object is the same as the parameter <code>object</code>, false otherwise.
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object object) {

        synchronized(this){
            return EventHelpers.compareEObject(this, object);
        }
	}

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * All components are initialized to either zero or null.
     * 
     * @since 1.0
     */
    public void init() {

        super.init();

        setDependencyDisposition(DEPENDENCY_DISPOSITION_EDEFAULT);
    }
} //DependencySituationImpl
