package org.eclipse.hyades.logging.events;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * The DependencySituation deals with the situations that components produce to 
 * say that they cannot find some component or feature that they need. This 
 * category includes messages about not finding the version of the component 
 * that was expected. Messages that say a resource was not found, or that an 
 * application or subsystem that was unavailable, also fall into this category. 
 * Existing messages include words like could not find, and no such component, 
 * for example:
 * 
 * <code>
 * WSVR0017E: Error encountered binding the J2EE resource, Pet Store JMS Queue Connection Factory, as jms/queue/QueueConnectionFactory from resources.xml no resource binder found
 * </code>
 * 
 * 
 * @author Richard K. Duggan
 * @author Paul E. Slauenwhite
 * @version 1.0.1
 * @since 1.0.1
 * @see ISituationType
 * @deprecated This class is deprecated as of 2004-05-17. Use the corresponding class available in org.eclipse.hyades.logging.events.cbe*
 */
public interface IDependencySituation extends ISituationType {

    /**
     * Returns the dependencyDisposition.
     * 
     * This property specifies the dependency disposition of a feature 
     * of a component that caused the situation to be reported.  The 
     * featureDisposition is a string with the following set of values:
     * 
     * MET
     * NOT MET
     * 
     * This is a REQUIRED property and once it is set it MUST NOT change. 
     * The string length for this property MUST NOT exceed 64 characters.
     * 
     * @return String The returned dependencyDisposition.
     * @since 1.0.1
     */
    public String getDependencyDisposition();

    /**
     * Sets the dependencyDisposition.
     * 
     * This property specifies the dependency disposition of a feature 
     * of a component that caused the situation to be reported.  The 
     * featureDisposition is a string with the following set of values:
     * 
     * MET
     * NOT MET
     * 
     * This is a REQUIRED property and once it is set it MUST NOT change. 
     * The string length for this property MUST NOT exceed 64 characters.
     * 
     * @param dependencyDisposition The dependencyDisposition to be set.
     * @since 1.0.1
     */
    public void setDependencyDisposition(String dependencyDisposition);
}
