/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.actions;

import org.eclipse.core.runtime.*;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.views.LogViewer;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.jface.action.*;
import org.eclipse.jface.viewers.*;
import org.eclipse.ui.*;

public class OpenLogViewAction extends Action
									implements IExecutableExtension
											  , IWorkbenchWindowActionDelegate, IViewActionDelegate
											  
{
	//private ISelection selection = null;
	private IWorkbenchWindow window;
	
	public OpenLogViewAction() {
		super("");
	}
	
	private void openView() {
		try {

			IWorkbenchWindow window =
				LogUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
			IWorkbenchPage persp = UIPlugin.getActivePage();

            EObject mofObject = HyadesUtil.getObjectToView(HyadesUtil.getMofObject());
			TraceViewer view = (LogViewer) (persp.showView("org.eclipse.hyades.log.ui.internal.views.LogViewer"));
			if (view != null)	{				
				view.addViewPage(mofObject);
			}
			
			Object obj = UIPlugin.getDefault().getSelectionModel(mofObject).getFirstElement();
			if(obj!=null && obj instanceof EObject)
			   view.setRecordSelection((EObject)obj, mofObject);	            	
            
		} catch (Exception e) {
			
			e.printStackTrace();
		}
	}
	public void run() {
		openView();
	}
	public void run(IAction action) {
		run();
	}
	public void setInitializationData(
		IConfigurationElement configElement,
		String name,
		Object data) {
	}
	public void selectionChanged(IAction action, ISelection selection) {
		//this.selection = selection;		
	}

	public void dispose() {
		
	}
	public void init(IWorkbenchWindow window) {
		
	}
	
	

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
	 */
	public void init(IViewPart view) {

	}

}