/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.preferences;

import org.eclipse.hyades.log.ui.internal.*;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.hyades.log.ui.internal.util.StatusInfo;
import org.eclipse.hyades.log.ui.internal.util.StatusUtil;
import org.eclipse.swt.events.*;

public class LogAnalyzerBasePrefPage
	extends PreferencePage
	implements IWorkbenchPreferencePage {

	private LogAnalyzerFormatPrefPage _format;
	private LogAnalyzerSortPrefPage _sort;
	private LogAnalyzerFilterPrefPage _filter;
	private LogAnalyzerAdvanceFilterPrefPage _advfilter;

	public LogAnalyzerBasePrefPage() {
		super();
		setPreferenceStore(LogUIPlugin.getDefault().getPreferenceStore());
	}
	protected Control createContents(Composite parent) {
		
		org.eclipse.ui.help.WorkbenchHelp.setHelp(
		parent,
		LogUIPlugin.getPluginId()+".labp0000");
		
		Composite composite = new Composite(parent, SWT.NONE);

		GridData data = GridUtil.createFill();
		data.heightHint = 100;
		composite.setLayoutData(data);
		GridLayout layout = new GridLayout();
		layout.marginWidth = 10;
		layout.marginHeight = 5;
		layout.numColumns = 1;
		composite.setLayout(layout);

		TabFolder folder = new TabFolder(composite, SWT.NONE);
		data = GridUtil.createFill();
		data.heightHint = 350;
		folder.setLayoutData(data);

		TabItem item;

		item = new TabItem(folder, SWT.NONE);
		item.setText(LogUIPlugin.getResourceString("LOG_ANALYZER_FORMAT_PREF_PAGE"));
		item.setImage(LogUIPluginImages.getImage(LogUIPluginImages.IMG_DATE_TIME));
		_format = new LogAnalyzerFormatPrefPage(getPreferenceStore());
		item.setControl(_format.createContents(folder));

		item = new TabItem(folder, SWT.NONE);
		item.setText(LogUIPlugin.getResourceString("LOG_ANALYZER_SORT_PREF_PAGE"));
		item.setImage(LogUIPluginImages.getImage(LogUIPluginImages.IMG_SORT));
		_sort = new LogAnalyzerSortPrefPage(getPreferenceStore());
		item.setControl(_sort.createContents(folder));

		item = new TabItem(folder, SWT.NONE);
		item.setText(LogUIPlugin.getResourceString("LOG_ANALYZER_FILTER_PREF_PAGE")); //"STR_FILTER"));
		item.setImage(LogUIPluginImages.getImage(LogUIPluginImages.IMG_FILTER));
		_filter = new LogAnalyzerFilterPrefPage(getPreferenceStore());
		item.setControl(_filter.createContents(folder));
		
		item = new TabItem(folder, SWT.NONE);
		item.setText(LogUIPlugin.getResourceString("LOG_ANALYZER_ADVANCE_FILTER_PREF_PAGE")); //"STR_FILTER"));
		item.setImage(LogUIPluginImages.getImage(LogUIPluginImages.IMG_ADV_FILTER));
		_advfilter = new LogAnalyzerAdvanceFilterPrefPage(getPreferenceStore());
		item.setControl(_advfilter.createContents(folder));

		addSelectionListenerToWidgets();//add listener to widgets when create controls.
			
		return composite;
	}
	public void init(IWorkbench workbench) {
	}
	protected void performDefaults() {
		super.performDefaults();
		_format.performDefaults();
		_sort.performDefaults();
		_filter.performDefaults();
		_advfilter.performDefaults();
		
		resetMessageOnStatusLine();
		setValid(true);
	}
	/**
	 * Do anything necessary because the OK button has been pressed.
	 *
	 * @return whether it is okay to close the preference page
	 */
	public boolean performOk() {		
		return _format.performOk() && _sort.performOk() && _filter.performOk() && _advfilter.performOk();
	}
	
	
	/**
	 * @see org.eclipse.jface.preference.PreferencePage#performApply()
	 */
	protected void performApply() {
	
		_format.performOk();
		_sort.performApply();
		_filter.performApply();
		_advfilter.performApply();	
	}

	
	
	
	/**
	 * show message on Status Line of LogAnalyzerBasePrefPage
	 */
	protected void showMessageOnStatusLine(){
		StatusUtil.applyToStatusLine(this,
				new StatusInfo(IStatus.ERROR, LogUIPlugin.getResourceString("ERR_SELECT_COLS")));
	}
	/**
	 * reset message on Status Line of LogAnalyzerBasePrefPage
	 */
	protected void resetMessageOnStatusLine(){
		StatusUtil.applyToStatusLine(this, 
				new StatusInfo(IStatus.OK, LogUIPlugin.getResourceString("LOG_ANALYZER_BASE_PREF_PAGE"))); 
	}
	/**
	 * return true if all items in Table is unchecked
	 */
	protected boolean ifAllItemsIsUnchecked(){
		for(int idx=0; idx<_filter._options._pdList.getItemCount(); idx++){
			if(_filter._options._pdList.getItem(idx).getChecked()){	
				return false;
			}		
		}
		return true;
	}
	/**
	 * add SelectionListener to Button "Clear All" and "Select All"
	 * add SelectionListener to Table _pdList
	 */
	protected void addSelectionListenerToWidgets(){
		_filter._options._unselAll.addSelectionListener(new SelectionListener(){
			public void widgetSelected(SelectionEvent e){
				showMessageOnStatusLine();
				setValid(false);
			}
			public void widgetDefaultSelected(SelectionEvent e){
			}
		}); 
		_filter._options._selAll.addSelectionListener(new SelectionListener(){
			public void widgetSelected(SelectionEvent e){
				resetMessageOnStatusLine();
				setValid(true);
			}
			public void widgetDefaultSelected(SelectionEvent e){
			}
		}); 
		_filter._options._pdList.addSelectionListener(new SelectionListener(){
			public void widgetSelected(SelectionEvent e){
				if(ifAllItemsIsUnchecked())
				{ 
					showMessageOnStatusLine();
					setValid(false);					
				}else{
					resetMessageOnStatusLine();
					setValid(true);
				}			
			}
			public void widgetDefaultSelected(SelectionEvent e){
			}
		});	
	}
	
}
