/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.util;

import org.eclipse.hyades.log.ui.internal.*;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.dialogs.*;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.*;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.help.*;

/**
 * Insert the type's description here.
 * Creation date: (3/7/2001 1:44:48 PM)
 * @author: Administrator
 */
public class ColumnsDialog extends Dialog implements SelectionListener
{
	private CBEFilterUI _options;
	private static final int _restoreDefaultsButtonId = IDialogConstants.CLIENT_ID + 1;
	private boolean filterHasChanged = false;
	private boolean sevHasChanged = false;

	private java.lang.String _title;
	/**
	 * CoulmnsDialog constructor comment.
	 * @param windowTitle java.lang.String
	 * @param windowImage com.ibm.swt.graphics.Image
	 */
	public ColumnsDialog(Shell shell, String windowTitle, Image windowImage) {
		super(shell);
		_title = windowTitle;
		setDefaultImage(windowImage);	
	}
	/**
	 * Configures the given shell in prepartaion for opening this window
	 * in it.
	 * <p>
	 * The default implementation of this framework method
	 * sets the shell's image and gives it a grid layout. 
	 * Subclasses may extend or reimplement.
	 * </p>
	 * 
	 * @param newShell the shell
	 */
	protected void configureShell(Shell shell) {
		super.configureShell(shell);
		shell.setText(_title);
	}
	/**
	 * Creates and returns the contents of the upper part 
	 * of the dialog (above the button bar).
	 *
	 * Subclasses should overide.
	 *
	 * @param the parent composite to contain the dialog area
	 * @return the dialog area control
	 */
	protected Control createDialogArea(Composite parent) {
		Composite result = (Composite) super.createDialogArea(parent);

		GridLayout layout;
		GridData data;

		layout = new GridLayout();
		layout.numColumns = 3;
		layout.verticalSpacing = 15;
		result.setLayout(layout);
		data = GridUtil.createFill();
		data.heightHint = 400;
		data.widthHint = 370;
		result.setLayoutData(data);

		IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();
		_options =  new CBEFilterUI();
		_options.createControl(result);
		_options.initializeValues(false);
		_options.addListener(this); 
		
		WorkbenchHelp.setHelp(result, ContextIds.ACTLOG_VIEW_DIALOG_FILTER);
				
		return result;
	}

	protected void createButtonsForButtonBar(Composite parent) {
		createButton(
			parent,
			_restoreDefaultsButtonId,
			LogUIPlugin.getResourceString("STR_COL_DLG_RESTORE_DEFAULTS"),
			false);
		super.createButtonsForButtonBar(parent);		
	}
	protected void buttonPressed(int buttonId) {
		if (buttonId == _restoreDefaultsButtonId) {
			_options.initializeValues(true);
			/* remove message and enable "OK" button 
			 * when clicking on "Restore Defaults" button */
			removeMessageOnColumnsDialog();			
			getButton(IDialogConstants.OK_ID).setEnabled(true);

		} else {
			super.buttonPressed(buttonId);
		}

	}
	/**
	 * Notifies that the ok button of this dialog has been pressed.
	 * <p>
	 * The default implementation of this framework method sets
	 * this dialog's return code to <code>Window.OK</code>
	 * and closes the dialog. Subclasses may override.
	 * </p>
	 */
	protected void okPressed() {
		boolean flag = _options.storeValues(LogUIPlugin.getDefault().getPreferenceStore());
		if(flag){
			_options.removeListener(this);
		}
		
		if(filterHasChanged){	
			LogUIPlugin.getDefault().fireRecordChangeNotification(new RecordChangeEvent(RecordChangeEvent.FILTER_COL_CHANGE, this));
		}
		
		if(sevHasChanged){	
			LogUIPlugin.getDefault().fireRecordChangeNotification(new RecordChangeEvent(RecordChangeEvent.FILTER_SEV_CHANGE, this));
		}

		if (flag) {
			super.okPressed();
		}
	}
	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetDefaultSelected(SelectionEvent e) {
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetSelected(SelectionEvent e) {
		Widget widget = e.widget;
		if(widget instanceof Button && ((((Button)widget).getStyle() & SWT.CHECK) == SWT.CHECK)){
			sevHasChanged = true;		
		}
		else if (widget==_options.getControl()){
			sevHasChanged = true;
			filterHasChanged = true;						
		}
		/* handle Buttons and Table selection event */
		else if (widget==_options._unselAll){
			for (int idx = 0; idx < _options._pdList.getItemCount(); idx++) {
				TableItem item = _options._pdList.getItem(idx);
				item.setChecked(false);
			}
			showMessageOnColumnsDialog();		
			getButton(IDialogConstants.OK_ID).setEnabled(false);			
		}
		else if (widget==_options._selAll){
			for (int idx = 0; idx < _options._pdList.getItemCount(); idx++) {
				TableItem item = _options._pdList.getItem(idx);
				item.setChecked(true);
			}		
			removeMessageOnColumnsDialog();	
			getButton(IDialogConstants.OK_ID).setEnabled(true);
		}
		else if (widget==_options._pdList){
			if(ifAllItemsIsUncheckedOnColumnsDialog()){
				showMessageOnColumnsDialog();
				getButton(IDialogConstants.OK_ID).setEnabled(false);
			}else{
				removeMessageOnColumnsDialog();
				getButton(IDialogConstants.OK_ID).setEnabled(true);
			}					
		}						
		else{
			filterHasChanged = true;
		}						
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.Dialog#cancelPressed()
	 */
	protected void cancelPressed() {
		_options.removeListener(this);
		super.cancelPressed();
	}
	
	/**
	 * show message in the label on ColumnsDialog
	 */
	protected void showMessageOnColumnsDialog(){	
		Color RED=null;
		Display display = Display.getDefault();
		RED = new Color (display, new RGB(255,0,0));
		
		_options._labelMessage.setVisible(true);
		_options._labelMessage.setForeground(RED);
		_options._labelMessage.setText(LogUIPlugin.getResourceString("ERR_SELECT_COLS"));

	}
	/**
	 * remove message in the label on ColumnsDialog
	 */
	protected void removeMessageOnColumnsDialog(){	
		_options._labelMessage.setVisible(false);
	}
	/**
	 * return true if all items in the Table is unchecked on ColumnsDialog,
	 * return false otherwise.
	 */
	protected boolean ifAllItemsIsUncheckedOnColumnsDialog(){
		for(int idx=0; idx<_options._pdList.getItemCount(); idx++){
			if(_options._pdList.getItem(idx).getChecked()){	
				return false;
			}		
		}
		return true;
	}

}