/*******************************************************************************
 * Copyright (c) 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.log.ui.internal.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.navigator.LogNavigator;
import org.eclipse.hyades.models.cbe.CBEPackage;
import org.eclipse.hyades.trace.internal.ui.PDPerspective;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.ui.internal.navigator.Navigator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;

public class LogUtil {
	
	public static boolean selectInLogNavigator(EObject object) {
		if (object!=null) {
			Navigator nav = (Navigator)HyadesUtil.getActiveNavigator();
			IViewPart part = null;

			IWorkbench workbench = LogUIPlugin.getDefault().getWorkbench();
			IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
			
			if(!(nav instanceof LogNavigator)){
				try {
					if(page != null && !page.getPerspective().getId().equals(PDPerspective.ID_TRACE_PERSPECTIVE) ){
						IAdaptable element =
						ResourcesPlugin.getWorkspace().getRoot();
						if (element != null)
							page =
								workbench.showPerspective(
									PDPerspective.ID_TRACE_PERSPECTIVE,
									workbench.getActiveWorkbenchWindow(),
									element);
									
					}
					part = page.findView(PDPerspective.ID_LOG_NAVIGATOR_VIEW);

				} catch (Exception e) {
					
					e.printStackTrace();
				}
						
			}else{		
				part = nav;
			}
			
			final EObject selection = object;
			final IViewPart fPart = part;
			
			final IWorkbenchPage fPage = page;
			if(fPart!=null){

				Display.getDefault().asyncExec(new Runnable()
				{
					public void run()
					{						
						((LogNavigator)fPart).selectReveal(new StructuredSelection(selection));
						if(!((LogNavigator)fPart).isActiveNavigator()){
							try{	
								fPage.showView(PDPerspective.ID_LOG_NAVIGATOR_VIEW);
							}
							catch(Exception e){
								e.printStackTrace();
							}
						}
					}
				});						
			}
		}
		return false;
	}

	public static void notifyViewSelectionChanged(Object source, Object selection) {
		UIPlugin.getDefault().getSelectionModel(HyadesUtil.getMofObject()).add(selection);
			
		ViewSelectionChangedEvent event = UIPlugin.getDefault().getViewSelectionChangedEvent();
		event.setSource(source);
		UIPlugin.getDefault().notifyViewSelectionChangedListener(event);
	}
	
	public static IPreferenceStore doGetPreferenceStore() {
		IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();
		try{
			IPath path = Platform.getPluginStateLocation(ResourcesPlugin.getPlugin());
			File file = path.removeLastSegments(1).addTrailingSeparator().append("org.eclipse.core.runtime").addTrailingSeparator().append(".settings").addTrailingSeparator().append("org.eclipse.hyades.sdb.prefs").toFile();
			if (file.exists() == false) {
				// Eclipse 2.0
				// eclipse_install\runtime-workspace\.metadata\.plugins\org.eclipse.hyades.sdb\pref_store.ini
				file = path.removeLastSegments(1).addTrailingSeparator().append("org.eclipse.hyades.sdb").addTrailingSeparator().append("pref_store.ini").toFile();
			}

			if (file.exists()){
				PreferenceStore ps = new PreferenceStore(file.getAbsolutePath());
				ps.load();
				String[] prefNames = ps.preferenceNames();
				for (int i=0; i<prefNames.length; i++){
					if (!store.contains(prefNames[i]))
						store.putValue(prefNames[i], ps.getString(prefNames[i]));
					else{
						String psValue = ps.getString(prefNames[i]);
						String storeValue = store.getString(prefNames[i]);
						String updated = storeValue + updatePreferenceStore(storeValue, psValue);
						store.putValue(prefNames[i], updated);
					}
				}
				LogUIPlugin.getDefault().savePluginPreferences();
				file.delete();
			}
			
			path = Platform.getPluginStateLocation(ResourcesPlugin.getPlugin());
			file = path.removeLastSegments(1).addTrailingSeparator().append("org.eclipse.core.runtime").addTrailingSeparator().append(".settings").addTrailingSeparator().append("com.ibm.etools.symptom.editor.prefs").toFile();
			if (file.exists()){
				PreferenceStore ps = new PreferenceStore(file.getAbsolutePath());
				ps.load();
				String[] prefNames = ps.preferenceNames();
				for (int i=0; i<prefNames.length; i++){
					if (!store.contains(prefNames[i]))
						store.putValue(prefNames[i], ps.getString(prefNames[i]));
					else{
						String psValue = ps.getString(prefNames[i]);
						String storeValue = store.getString(prefNames[i]);
						String updated = storeValue + updatePreferenceStore(storeValue, psValue);
						store.putValue(prefNames[i], updated);
					}
				}
				LogUIPlugin.getDefault().savePluginPreferences();
				file.delete();
			}
		}catch(Exception e){
			System.out.println(e.toString());
		}
		return store;
	}
	
	public static void initializePreferenceStore(IPreferenceStore store){
	try {

		ArrayList sort = new ArrayList(40);
		ArrayList filter = new ArrayList(70);

		createSortAndFilterList(sort,filter,CBEPackage.eINSTANCE.getCBECommonBaseEvent());

		sort.remove("timeZone");
		StringBuffer pdSortKey = new StringBuffer();
		generatePreferenceString(pdSortKey, sort, new String[]{"creationTime", "sequenceNumber"});
		store.setDefault(LogUIConstants.PD_SORT_LOG_OPTIONS, pdSortKey.toString().trim());
		
		filter.remove("timeZone");
		StringBuffer pdKey = new StringBuffer();					
		Collections.sort(filter);
		generatePreferenceString(pdKey, filter, null);
		store.setDefault(LogUIConstants.PD_FILTER_OPTIONS, pdKey.toString().trim());
	
		store.setDefault(LogUIConstants.PD_ADV_FILTER_OPTIONS, "");
		store.setDefault(LogUIConstants.PD_SEARCH_FILTER_OPTIONS, "");
		store.setDefault(LogUIConstants.PD_SEARCH_DIRECTION_OPTIONS, "1");
		store.setDefault(LogUIConstants.PD_FILTER_SHOW_CORRELATION_ONLY, "1");
		
		String url =
			LogUIPlugin.getResourceString("STR_StdURL_NAME")
				+ "\t"
				+ LogUIConstants.StdURL
				+ "\n"
				+ LogUIPlugin.getResourceString("STR_AdvURL_NAME")
				+ "\t"
				+ LogUIConstants.AdvURL
				+ "\n"
				+ LogUIPlugin.getResourceString("STR_StdURL_NAME_V5")
				+ "\t"
				+ LogUIConstants.StdURL
				+ "\n"
				+ LogUIPlugin.getResourceString("STR_StdURL_NAME_V6")
				+ "\t"
				+ LogUIConstants.StdURL
				+ "\n"
				+ LogUIPlugin.getResourceString("STR_AdvURL_NAME_V5")
				+ "\t"
				+ LogUIConstants.AdvURL;

		store.setDefault(LogUIConstants.SYMPTOM_DB_URL, url);
		store.setDefault(LogUIConstants.SYMPTOM_DB_URL_32, url);
	
} catch (Exception exc) {
	exc.printStackTrace();
}

		
store.setDefault(LogUIConstants.LOG_ANALYZER_FORMAT_DATE, LogUIConstants.LOG_ANALYZER_FORMAT_DATE_DEFAULT);
store.setDefault(LogUIConstants.LOG_ANALYZER_FORMAT_TIME, LogUIConstants.LOG_ANALYZER_FORMAT_TIME_DEFAULT);

}
	
	/**
	 * Method generatePrefrenceString.
	 * @param key
	 * @param list
	 */
	private static void generatePreferenceString(StringBuffer key, ArrayList list, String[] pref) {
		
		String keyVal = "";
		if(pref==null){
			keyVal = ":1 ";
		}
		else{
			keyVal = ":1 ";
			int s = pref.length;
			for(int i=0; i<s; i++){
				key.append((String)pref[i]);
				key.append(keyVal);
				list.remove(pref[i]);
			}
			keyVal = ":0 ";
			
		}
		
		for (Iterator iter = list.iterator(); iter.hasNext();) {
			String element = (String) iter.next();
			key.append(element);
			key.append(keyVal);
			
		}
	}

	
	private static void createSortAndFilterList(List sort, List filter, EClassifier base){

		List list = new ArrayList(30);
			
		EList metaObj = CBEPackage.eINSTANCE.getEClassifiers();
		int size = metaObj.size();

		for (int i = 0; i < size; i++) {
			EClassifier elem = (EClassifier)metaObj.get(i);
			getEObjectAttributes((EClass)elem, list);
			int listSize = list.size();
			boolean isSort = ((EClass)elem).getEAllSuperTypes().contains(base) || elem == base;			
			for (int j = 0; j<listSize;j++) {
				String element = (String) list.get(j);
				if(isSort && !sort.contains(element)){
					sort.add(element);
				}
				if(!filter.contains(element)){
					filter.add(element);
				}
				
			}
			list.clear();

		}
				
	}
	
	
	private static void getEObjectAttributes(EClass eClass, List list){

		List attributes = eClass.getEAttributes();
		boolean isArrayOfObj = false;
		for (int k=0; k < attributes.size(); k++) {
			EAttribute attribute = (EAttribute) attributes.get(k);
			isArrayOfObj = attribute.isMany() &&  
							(attribute.getEType().getInstanceClass() != String.class) &&
							(!attribute.getEType().getInstanceClassName().equals("byte")) && 
							(!attribute.getEType().getInstanceClassName().equals("short"));
			if(!isArrayOfObj){
				list.add(attribute.getName());
			}
		}
					
	}
	
	private static String updatePreferenceStore(String str1, String str2){
		if (str1 == null || str1.trim().length() == 0)
			return "\n"+str2;
		
		if (str1.equalsIgnoreCase(str2))
			return "";
		
		String[] urls1 = str1.split("\n");
		Hashtable table = new Hashtable();
		for (int i=0; i<urls1.length; i++){
			String[] strs = urls1[i].split("\t");
			strs[0] = strs[0].trim();
			if (strs[0].length() != 0)
				table.put(strs[0], strs[1]);
		}
		
		String[] urls2 = str2.split("\n");
		String rc = "";
		for (int i=0; i<urls2.length; i++){
			String[] strs = urls2[i].split("\t");
			strs[0] = strs[0].trim();
			if (strs[0].length() != 0 && !table.containsKey(strs[0])){
				rc = rc + "\n" + urls2[i];
			}
		}
		return rc;
	}
}
