/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.util;

import org.eclipse.hyades.log.ui.internal.*;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.dialogs.*;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.help.*;

/**
 * 
 */
public class SortDialog extends Dialog implements SelectionListener{
	
	private CBESortUI _options;

	private static final int _restoreDefaultsButtonId =
		IDialogConstants.CLIENT_ID + 1;

	private java.lang.String _title;
	private boolean sortHasChanged = false;	
	/**
	 * CoulmnsDialog constructor comment.
	 * @param windowTitle java.lang.String
	 * @param windowImage com.ibm.swt.graphics.Image
	 */
	public SortDialog(Shell shell, String windowTitle, Image windowImage) {
		super(shell);
		_title = windowTitle;
		setDefaultImage(windowImage);
	}
	/**
	 * Configures the given shell in prepartaion for opening this window
	 * in it.
	 * <p>
	 * The default implementation of this framework method
	 * sets the shell's image and gives it a grid layout. 
	 * Subclasses may extend or reimplement.
	 * </p>
	 * 
	 * @param newShell the shell
	 */
	protected void configureShell(Shell shell) {
		super.configureShell(shell);
		shell.setText(_title);
	}
	/**
	 * Creates and returns the contents of the upper part 
	 * of the dialog (above the button bar).
	 *
	 * Subclasses should overide.
	 *
	 * @param the parent composite to contain the dialog area
	 * @return the dialog area control
	 */
	protected Control createDialogArea(Composite parent) {
		Composite composite = (Composite) super.createDialogArea(parent);

		GridLayout layout;
		GridData data;

		layout = new GridLayout();
		layout.numColumns = 1;
		layout.verticalSpacing = 15;
		composite.setLayout(layout);
		data = GridUtil.createFill();
		data.heightHint = 400;
		data.widthHint = 450;
		composite.setLayoutData(data);

		_options = new CBESortUI();
		_options.createControl(composite);
		_options.initializeValues(false);
		_options.addListener(this);		

		WorkbenchHelp.setHelp(composite, ContextIds.ACTLOG_VIEW_DIALOG_SORT);

		return composite;
	}

	protected void createButtonsForButtonBar(Composite parent) {
		createButton(
			parent,
			_restoreDefaultsButtonId,
			LogUIPlugin.getResourceString("STR_COL_DLG_RESTORE_DEFAULTS"),
			false);
		super.createButtonsForButtonBar(parent);
	}

	protected void buttonPressed(int buttonId) {
		if (buttonId == _restoreDefaultsButtonId) {
			_options.initializeValues(true);
		} else {
			_options.removeListener(this);			
			super.buttonPressed(buttonId);
		}
	}

	/**
	* Notifies that the ok button of this dialog has been pressed.
	* <p>
	* The default implementation of this framework method sets
	* this dialog's return code to <code>Window.OK</code>
	* and closes the dialog. Subclasses may override.
	* </p>
	*/
	protected void okPressed() {
		_options.storeValues(LogUIPlugin.getDefault().getPreferenceStore());
		_options.removeListener(this);		
		if(sortHasChanged){	
			LogUIPlugin.getDefault().fireRecordChangeNotification(new RecordChangeEvent(RecordChangeEvent.SORT_COL_CHANGE, this));
		}		
	
		super.okPressed();
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetDefaultSelected(SelectionEvent e) {
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetSelected(SelectionEvent e) {
		if(e.data!=null && e.data instanceof Integer && ((Integer)e.data).intValue()==RecordChangeEvent.SORT_COL_CHANGE ){
			sortHasChanged = true;
		}

	}
	
}