/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/*
 * Created on Aug 2, 2003
 *
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.LogUIConstants;
import org.eclipse.hyades.log.ui.internal.util.TraceMergeUI;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.internal.core.TraceLocationUI;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeItem;

/**
 * @author apnan
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class LogDestinationUI implements Listener {

	private TraceLocationUI locationUI;
	private TraceMergeUI mergeUI;
	private TRCAgentProxy currentAgentProxy;
	private ImportLogWizardPage page;
	private boolean bTextHasChanged = true;
		
	public LogDestinationUI(ImportLogWizardPage page){
		this.page = page;
	}
	public Composite createControl(Composite parent) {
		GridLayout layout;

		Composite btnGroup = new Composite(parent, SWT.NONE);
		layout = new GridLayout();
		layout.numColumns = 1;
		layout.verticalSpacing = 0;
		btnGroup.setLayout(layout);
		btnGroup.setLayoutData(GridUtil.createFill());

		locationUI = new TraceLocationUI();
		locationUI.createControl(btnGroup);

		locationUI.setLocation(LogUIConstants.LOG_ANALYZER_PRJ);

		locationUI.getLocationLabel().setText(LogUIPlugin.getResourceString("STR_IMPORT_LOG_FILE_DES_PROJECT"));

		locationUI.getLocation().addListener(SWT.Modify, this);
		locationUI.getMonitor().addListener(SWT.Modify, this);
		
		Label space = new Label(btnGroup, SWT.NONE);
		GridData data = new GridData(GridData.FILL_HORIZONTAL);

		mergeUI = new TraceMergeUI();
		mergeUI.createControl(btnGroup);
		mergeUI.getTree().addListener(SWT.Selection, this);
		
		mergeUI.getMergeButton().addListener(SWT.Selection, this);
		
		return btnGroup;        
	 }

	public void handleEvent(Event event) {
		LogFileElement element = page.getSelectedElement();
		if (event.type == SWT.Modify) {
			if(bTextHasChanged){				
				page.setPageComplete(isTabItemComplete());
			}
		}
		else
		if (event.widget == mergeUI.getMergeButton()) {
				mergeUI.getTree().setEnabled(mergeUI.getMergeButton().getSelection());
				if(mergeUI.getMergeButton().getSelection()){           
					TreeItem[] sel = mergeUI.getTree().getSelection();
					if(sel.length > 0){				
						TreeItem selection = (TreeItem)sel[0];
						if(selection!=null && selection.getData()!=null){				
							if(selection.getData() instanceof TRCAgentProxy){
								currentAgentProxy = (TRCAgentProxy)selection.getData();					
								return; 
														
							}
						}
					}										
				}
				currentAgentProxy = null;
		}
		else{
			
			TreeItem[] sel = mergeUI.getTree().getSelection();
			if(sel.length > 0){
				TreeItem selection = (TreeItem)sel[0];
				if(selection!=null && selection.getData()!=null){				
					if(selection.getData() instanceof TRCAgentProxy){
						TRCMonitor monitor = (TRCMonitor)((TRCAgentProxy)selection.getData()).getProcessProxy().getNode().getMonitor();
						locationUI.setMonitor(monitor.getName());
						String path = resourcePath(monitor.eResource().getURI());
						IWorkspace workbench = ResourcesPlugin.getWorkspace();				
						IPath filePath = new Path(path);
						IResource fres = workbench.getRoot().findMember(filePath);
						if (fres != null && fres.exists()) {
							locationUI.setLocation(fres.getProject().getName());

						}
						currentAgentProxy = (TRCAgentProxy)selection.getData();

						return;											
					}
				}
			}
			currentAgentProxy = null;			
			//element.setMergedAgent(currentAgentProxy);	
		}
		bTextHasChanged = true;
	}

	public void initialize(){

		locationUI.initialize();
		setMergedAgent(null);
		setUseLargeLogSupport(false);				
	}
	
	public void initializeUIFromLogElement(LogFileElement element){
			
		if(element.getProject()==null || element.getMonitor()==null){
			locationUI.initialize();
		}			
		else{
			setProject(element.getProject());
			setMonitor(element.getMonitor());		
		}
		setMergedAgent(page.getSelectedElement().getMergedAgent());		
		setUseLargeLogSupport(page.getSelectedElement().isUseLargeLogSupport());		
	}
	
	public String getProject() {
		return locationUI.getLocation().getText().trim();
	}
	public String getMonitor() {
		return locationUI.getMonitor().getText().trim();
	}

	public TRCAgentProxy getAgentProxy() {
		return currentAgentProxy;		
	}
    
	public boolean getSelection(){
		return mergeUI.getMergeButton().getSelection();
	}

	private String resourcePath(URI uri)
	{
	   String path = uri.path();
  
	   if(path.startsWith("/resource"))
		 return path.substring(9);
   	  
	   if(path.startsWith("platform:/resource"))
		 return path.substring(18);

	   return path;  
	}
		
	public void setProject(String project){
		bTextHasChanged = false;
		locationUI.setLocation(project);			
	}
	
	public void setMonitor(String monitor){
		bTextHasChanged = false;
		locationUI.setMonitor(monitor);			
	}

	
	public void setMergedAgent(TRCAgentProxy mergedAgent){
		if(mergedAgent==null){	
			mergeUI.getMergeButton().setSelection(false);
			mergeUI.getTree().setEnabled(false);
		}else{
			mergeUI.getMergeButton().setSelection(true);
			mergeUI.getTree().setEnabled(true);
			mergeUI.selectMergedAgent(mergedAgent);
			currentAgentProxy = mergedAgent;
			
		}
		
	}
	
	public boolean isTabItemComplete(){

		if(locationUI.getMonitor().getText().length()==0 || locationUI.getLocation().getText().length()==0){
			return false;
		}
		return true;
	}
	
	public boolean finish(){
		
		LogFileElement element = page.getSelectedElement();
		element.setMonitor(locationUI.getMonitor().getText());
		element.setProject(locationUI.getLocation().getText());
		element.setMergedAgent(currentAgentProxy);
		element.setUseLargeLogSupport(mergeUI.getLargeLogSupport());
		
		return locationUI.getMonitor().getText().length()>0 && locationUI.getLocation().getText().length()>0;

	}
	public void setUseLargeLogSupport(boolean b) {
		if(mergeUI!=null)
			mergeUI.setUseLargeLogSupport(b);
		
	}
	
}
