/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.recorder.local;

import java.io.IOException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Enumeration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.execution.core.DaemonConnectException;
import org.eclipse.hyades.execution.core.IControlMessage;
import org.eclipse.hyades.execution.core.IDataProcessor;
import org.eclipse.hyades.execution.core.IExecutableObject;
import org.eclipse.hyades.execution.core.IExecutionComponent;
import org.eclipse.hyades.execution.core.IExecutionComponentFactory;
import org.eclipse.hyades.execution.core.IExecutionEnvironment;
import org.eclipse.hyades.execution.core.IRemoteHyadesComponent;
import org.eclipse.hyades.execution.core.ISession;
import org.eclipse.hyades.execution.core.UnknownDaemonException;
import org.eclipse.hyades.execution.local.ExecutionComponentFactoryImpl;
import org.eclipse.hyades.execution.local.JavaProcessExecutableObjectStub;
import org.eclipse.hyades.execution.local.JavaProcessExecutorStub;
import org.eclipse.hyades.execution.local.NodeImpl;
import org.eclipse.hyades.execution.local.SessionStub;
import org.eclipse.hyades.execution.recorder.RecorderPlugin;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentControllerUnavailableException;
import org.eclipse.hyades.internal.execution.local.control.AgentListener;
import org.eclipse.hyades.internal.execution.local.control.InactiveAgentException;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NotConnectedException;
import org.eclipse.hyades.internal.execution.recorder.Recorder;
import org.eclipse.hyades.internal.execution.recorder.local.RecorderDataProcessorHelper;
import org.eclipse.hyades.internal.execution.recorder.local.RecorderStopper;
import org.eclipse.hyades.internal.execution.recorder.local.appadapters.IRecorderApplicationAdapter;
import org.eclipse.hyades.internal.execution.recorder.local.appadapters.RecorderAppAdapterFactory;
import org.eclipse.hyades.internal.execution.recorder.local.appadapters.RecorderApplicationAdapterException;
import org.eclipse.hyades.internal.execution.recorder.ui.dialogs.RecorderProgressDialog;
import org.eclipse.hyades.internal.execution.recorder.ui.views.RecorderControlView;
import org.eclipse.hyades.internal.execution.testgen.TestGenerator;
import org.eclipse.hyades.internal.execution.testgen.TestGeneratorFactory;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;

public class RecorderClient {
    private JavaProcessExecutorStub executor;
    private IExecutionEnvironment exeEnvironment = null;
    private IExecutionComponentFactory factory = null;
    private ISession session = null;
    private IRemoteHyadesComponent remoteHyadesComponent = null;
    private IExecutableObject executableObject = null;
    private Recorder theRecorder;
    private Agent controlAgent = null;
    private RecorderDataProcessorHelper dataProcessorHelper;
    private Display display = Display.getCurrent();
    private RecorderProgressDialog progressDlg = null;
    private int ticks = 0;
    final int RECORDER_MAX_TICKS = 15;
    public IRecorderApplicationAdapter appAdapter = null;
    private RecorderStopper recorderStopper = null;

    public void run(final Recorder recorder) throws IllegalAccessException, InstantiationException, IOException {
        new Thread(){

            public void run() {
                try {
                    RecorderClient.this.theRecorder = recorder;
                    RecorderClient.this.initProgressDialog();
                    RecorderClient.this.updateViewStatus(RecorderPlugin.getResourceString("RecorderClient.STATUS_INIT"));
                    RecorderClient.this.sendStatusMessageToControlView(RecorderPlugin.getResourceString("RecorderClient.RECORDING_STARTED_STATUS_MESSAGE"));
                    RecorderClient.this.session = RecorderClient.this.createSession();
                    RecorderClient.this.factory = ExecutionComponentFactoryImpl.getInstance((ISession)RecorderClient.this.session);
                    RecorderClient.this.tickProgressDialog(null);
                    RecorderClient.this.exeEnvironment = RecorderClient.this.setupJavaEnvironment();
                    RecorderClient.this.session.addChild((IExecutionComponent)RecorderClient.this.exeEnvironment);
                    RecorderClient.this.tickProgressDialog(null);
                    RecorderClient.this.executor = RecorderClient.this.setupExecutor();
                    RecorderClient.this.tickProgressDialog(null);
                    RecorderClient.this.remoteHyadesComponent = RecorderClient.this.setupAgent();
                    RecorderClient.this.dataProcessorHelper = new RecorderDataProcessorHelper(RecorderClient.this.theRecorder.getDataProcessor());
                    RecorderClient.this.remoteHyadesComponent.startMonitoring((IDataProcessor)RecorderClient.this.dataProcessorHelper);
                    RecorderClient.this.tickProgressDialog(null);
                    RecorderClient.this.executableObject = RecorderClient.this.setupHarnessAgentExecutableObject();
                    RecorderClient.this.tickProgressDialog(null);
                    RecorderClient.this.exeEnvironment.addChild((IExecutionComponent)RecorderClient.this.executor);
                    RecorderClient.this.tickProgressDialog(null);
                    RecorderClient.this.theRecorder.getDataProcessor().initialize();
                    RecorderClient.this.executor.setExecutableObject(RecorderClient.this.executableObject);
                    RecorderClient.this.executor.addChild((IExecutionComponent)RecorderClient.this.remoteHyadesComponent);
                    RecorderClient.this.tickProgressDialog(null);
                    RecorderClient.this.executor.launch();
                    RecorderClient.this.tickProgressDialog(null);
                    RecorderClient.this.startRecording();
                    RecorderClient.this.updateViewStatus(RecorderPlugin.getResourceString("RecorderClient.STATUS_RUNNING"));
                    new FinishCleanupAndGenTestThread().start();
                }
                catch (Exception exception) {
                    RecorderClient.this.sendStatusMessageToControlView(RecorderPlugin.getResourceString("RecorderClient.START_RECORDING_ABORTED_DUE_TO_EXCEPTION_STATUS_MESSAGE") + exception.getClass().getName());
                    RecorderClient.this.endProgressDialog();
                    RecorderClient.this.updateViewStatus(RecorderPlugin.getResourceString("RecorderClient.STATUS_STOPPED"));
                    String string = exception.getMessage();
                    if (string == null) {
                        string = exception.getClass().getName();
                    }
                    if (exception instanceof AgentControllerUnavailableException) {
                        String[] stringArray = new String[]{RecorderPlugin.getDefault().getRAServerHost(), RecorderPlugin.getDefault().getRAServerPort()};
                        string = RecorderPlugin.getDefault().getString("RecorderClient.RAC_UNAVAILABLE_MESSAGE", stringArray);
                        string = string + "\r\n";
                        string = string + RecorderPlugin.getResourceString("RecorderClient.RAC_UNAVAILABLE_MESSAGE_DESC1");
                        RecorderClient.this.sendStatusMessageToControlView(RecorderPlugin.getDefault().getString("RecorderClient.RAC_UNAVAILABLE_MESSAGE", stringArray));
                    }
                    RecorderPlugin.reportExceptionToUser(exception, RecorderPlugin.getResourceString("RecorderClient.START_RECORDING_ABORTED"), string, RecorderPlugin.getResourceString("RecorderClient.RECORDER_ERROR"));
                    if (RecorderClient.this.session != null) {
                        RecorderClient.this.session.release();
                    }
                    RecorderClient.this.theRecorder.setActive(false);
                }
            }
        }.start();
    }

    private void sendStatusMessageToControlView(String string) {
        RecorderControlView recorderControlView = RecorderControlView.getInstance();
        recorderControlView.addMessage(string);
        this.tickProgressDialog(string);
    }

    private void startRecording() throws InstantiationException, IllegalAccessException, ClassNotFoundException, RecorderApplicationAdapterException {
        String string = null;
        String string2 = "-1";
        String string3 = "Init " + this.theRecorder.getConfigParams();
        String string4 = "Init";
        this.sendStatusMessageToControlView(RecorderPlugin.getResourceString("RecorderClient.SENDING_COMMAND_STATUS_MESSAGE") + string4);
        this.sendMessage(string3);
        string3 = "StartRecording";
        string4 = "StartRecording";
        this.sendStatusMessageToControlView(RecorderPlugin.getResourceString("RecorderClient.SENDING_COMMAND_STATUS_MESSAGE") + string4);
        this.sendMessage(string3);
        String string5 = this.theRecorder.getApplicationAdapterID();
        if (!string5.equalsIgnoreCase("-1")) {
            string = RecorderAppAdapterFactory.getInstance().getAgentClasspath(this.theRecorder.getApplicationAdapterID());
            string2 = RecorderAppAdapterFactory.getInstance().getClient(this.theRecorder.getApplicationAdapterID()).getInitString();
        }
        if (string != null && !string.equals("-1")) {
            string3 = "StartApp " + string + ";" + string2;
            string4 = "StartApp " + RecorderAppAdapterFactory.getInstance().getAdapterName(string5);
            this.sendStatusMessageToControlView(RecorderPlugin.getResourceString("RecorderClient.SENDING_COMMAND_STATUS_MESSAGE") + string4);
            this.startApplication(string, string2);
        } else {
            this.sendStatusMessageToControlView(RecorderPlugin.getResourceString("RecorderClient.MANUAL_START_APP"));
        }
        this.endProgressDialog();
    }

    public void stopRecording() {
        try {
            this.stopApplication();
        }
        catch (Exception exception) {
            this.sendStatusMessageToControlView(RecorderPlugin.getResourceString("RecorderClient.STOP_RECORDING_ABORTED_DUE_TO_EXCEPTION_STATUS_MESSAGE") + exception.getClass().getName());
            this.endProgressDialog();
            RecorderPlugin.reportExceptionToUser(exception, RecorderPlugin.getResourceString("RecorderClient.STOP_RECORDING_ABORTED"), exception.getClass().getName(), RecorderPlugin.getResourceString("RecorderClient.RECORDER_ERROR"));
            if (this.session != null) {
                this.session.release();
            }
            this.theRecorder.setActive(false);
        }
        this.sendMessage("Stop");
    }

    private void sendMessage(String string) {
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.controlAgent == null) {
            this.initControlAgent();
        }
        CustomCommand customCommand = new CustomCommand();
        customCommand.setData(string);
        try {
            this.controlAgent.invokeCustomCommand(customCommand);
        }
        catch (InactiveAgentException inactiveAgentException) {
            inactiveAgentException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initControlAgent() {
        String string = this.executor.getPid();
        int n = 100;
        try {
            boolean bl = false;
            Node node = ((SessionStub)this.executor.getSessionContext()).getAgent().getProcess().getNode();
            block7: while (true) {
                if (bl) return;
                if (n <= 0) {
                    return;
                }
                Enumeration enumeration = node.listProcesses();
                while (true) {
                    if (!enumeration.hasMoreElements()) continue block7;
                    org.eclipse.hyades.internal.execution.local.control.Process process = (org.eclipse.hyades.internal.execution.local.control.Process)enumeration.nextElement();
                    if (process.getProcessId().equals(string)) {
                        bl = true;
                        org.eclipse.hyades.internal.execution.local.control.Process process2 = process;
                        synchronized (process2) {
                            Enumeration enumeration2 = process.getAgentsByType("tester");
                            while (enumeration2.hasMoreElements()) {
                                this.controlAgent = (Agent)enumeration2.nextElement();
                                try {
                                    this.controlAgent.addAgentListener((AgentListener)new RecorderAgentListener());
                                    this.controlAgent.attach();
                                    break;
                                }
                                catch (InactiveAgentException inactiveAgentException) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    --n;
                }
                break;
            }
        }
        catch (InactiveProcessException inactiveProcessException) {
            return;
        }
        catch (NotConnectedException notConnectedException) {
            return;
        }
    }

    private IExecutableObject setupHarnessAgentExecutableObject() throws ClassNotFoundException {
        this.factory.addExecutionComponent("JAVA_EXECUTABLE", "org.eclipse.hyades.execution.core.impl.JavaProcessExecutableObjectImpl");
        this.factory.addStub("JAVA_EXECUTABLE", "org.eclipse.hyades.execution.local.JavaProcessExecutableObjectStub");
        this.factory.addSkeleton("JAVA_EXECUTABLE", "org.eclipse.hyades.execution.remote.JavaProcessExecutableObjectSkeleton");
        IExecutableObject iExecutableObject = this.executor.getCompatibleExecutableObject("JAVA_EXECUTABLE");
        this.theRecorder.getExecutableObjectAdapter().setupExecutableObject((JavaProcessExecutableObjectStub)iExecutableObject);
        return iExecutableObject;
    }

    private IRemoteHyadesComponent setupAgent() throws ClassNotFoundException {
        this.factory.addExecutionComponent("AGENT", "org.eclipse.hyades.execution.core.impl.JavaTaskRemoteHyadesComponentImpl");
        this.factory.addStub("AGENT", "org.eclipse.hyades.execution.local.JavaTaskRemoteHyadesComponentStub");
        this.factory.addSkeleton("AGENT", "org.eclipse.hyades.execution.remote.JavaTaskRemoteHyadesComponentSkeleton");
        return (IRemoteHyadesComponent)this.factory.createExecutionComponentByType("AGENT");
    }

    private JavaProcessExecutorStub setupExecutor() throws ClassNotFoundException {
        this.factory.addExecutionComponent("EXECUTOR", "org.eclipse.hyades.execution.core.impl.ProcessExecutorImpl");
        this.factory.addStub("EXECUTOR", "org.eclipse.hyades.execution.local.JavaProcessExecutorStub");
        this.factory.addSkeleton("EXECUTOR", "org.eclipse.hyades.execution.remote.JavaProcessExecutorSkeleton");
        return (JavaProcessExecutorStub)this.factory.createExecutionComponentByType("EXECUTOR");
    }

    private ISession createSession() throws UnknownHostException, UnknownDaemonException, DaemonConnectException {
        String string = RecorderPlugin.getDefault().getRAServerHost();
        String string2 = RecorderPlugin.getDefault().getRAServerPort();
        this.sendStatusMessageToControlView(RecorderPlugin.getResourceString("RecorderClient.CONNECTING_TO_RASERVER_STATUS_MESSAGE") + string + RecorderPlugin.getResourceString("RecorderClient.PORT_LABEL") + string2);
        NodeImpl nodeImpl = new NodeImpl(string);
        ISession iSession = null;
        iSession = nodeImpl.connect(string2, null);
        return iSession;
    }

    private IExecutionEnvironment setupJavaEnvironment() throws ClassNotFoundException, IOException {
        IExecutionEnvironment iExecutionEnvironment = null;
        this.factory.addExecutionComponent("ENVIRONMENT", "org.eclipse.hyades.execution.core.impl.ExecutionEnvironmentImpl");
        this.factory.addStub("ENVIRONMENT", "org.eclipse.hyades.execution.local.ExecutionEnvironmentStub");
        this.factory.addSkeleton("ENVIRONMENT", "org.eclipse.hyades.execution.remote.ExecutionEnvironmentSkeleton");
        iExecutionEnvironment = (IExecutionEnvironment)this.factory.createExecutionComponentByType("ENVIRONMENT");
        this.theRecorder.getAgentEnvironmentAdapter().setupExecutionEnvironment(iExecutionEnvironment);
        return iExecutionEnvironment;
    }

    private void initProgressDialog() throws Exception {
        final RecorderClient recorderClient = this;
        this.display.syncExec(new Runnable(){

            public void run() {
                RecorderClient.this.progressDlg = new RecorderProgressDialog(recorderClient);
                RecorderClient.this.progressDlg.setBlockOnOpen(false);
                RecorderClient.this.progressDlg.open();
                RecorderClient.this.progressDlg.setMaxProgress(15);
            }
        });
    }

    private void tickProgressDialog(final String string) {
        if (this.progressDlg != null) {
            this.display.asyncExec(new Runnable(){

                public void run() {
                    RecorderClient.this.progressDlg.setProgress(++RecorderClient.this.ticks);
                    if (string != null) {
                        RecorderClient.this.progressDlg.setMessage(string);
                    }
                }
            });
        }
    }

    private void endProgressDialog() {
        if (this.progressDlg != null) {
            this.display.syncExec(new Runnable(){

                public void run() {
                    try {
                        RecorderClient.this.progressDlg.setProgress(15);
                        RecorderClient.this.progressDlg.complete();
                    }
                    catch (SWTException sWTException) {}
                }
            });
        }
    }

    private void startApplication(String string, String string2) throws InstantiationException, IllegalAccessException, ClassNotFoundException, RecorderApplicationAdapterException {
        this.appAdapter = (IRecorderApplicationAdapter)Class.forName(string).newInstance();
        this.appAdapter.init(string2);
        Process process = this.appAdapter.start();
        this.recorderStopper = new RecorderStopper(process, this);
        this.recorderStopper.start();
    }

    private void stopApplication() throws RecorderApplicationAdapterException {
        if (this.appAdapter != null) {
            if (this.recorderStopper.isActive()) {
                this.recorderStopper.interrupt();
            }
            this.appAdapter.stop();
            this.appAdapter.cleanup();
        }
    }

    private void updateViewStatus(final String string) {
        if (this.display != null) {
            this.display.asyncExec(new Runnable(){

                public void run() {
                    RecorderControlView.getInstance().setStatus(string);
                }
            });
        }
    }

    public RecorderProgressDialog getProgressDlg() {
        return this.progressDlg;
    }

    public void setProgressDlg(RecorderProgressDialog recorderProgressDialog) {
        this.progressDlg = recorderProgressDialog;
    }

    private class ControlMessage
    implements IControlMessage {
        private String messageData;

        public ControlMessage(String string) {
            this.messageData = string;
        }

        public String getMessageData() {
            return this.messageData;
        }

        public void setMessageData(String string) {
            this.messageData = string;
        }
    }

    private class RecorderAgentListener
    implements AgentListener {
        private RecorderAgentListener() {
        }

        public void agentActive(Agent agent) {
        }

        public void agentInactive(Agent agent) {
        }

        public void error(Agent agent, String string, String string2) {
        }

        public void handleCommand(Agent agent, CommandElement commandElement) {
            if (commandElement instanceof CustomCommand) {
                String string = ((CustomCommand)commandElement).getData();
                System.out.println("recieving message: " + string);
            }
        }
    }

    private class FinishCleanupAndGenTestThread
    extends Thread {
        public FinishCleanupAndGenTestThread() {
            this.setName("Recording completion listener");
        }

        public void run() {
            while (!RecorderClient.this.dataProcessorHelper.isRecordingComplete()) {
                this.delay(200);
            }
            try {
                RecorderClient.this.stopApplication();
            }
            catch (Exception exception) {
                // empty catch block
            }
            RecorderClient.this.theRecorder.setActive(false);
            RecorderControlView.getInstance().addMessage(RecorderPlugin.getResourceString("RecorderClient.RECORDING_COMPLETE_MESSAGE"));
            if (!RecorderClient.this.theRecorder.getScriptgenID().equalsIgnoreCase("-1")) {
                RecorderClient.this.display.asyncExec(new Runnable(){

                    public void run() {
                        block6: {
                            String string = RecorderClient.this.theRecorder.getScriptgenID();
                            String string2 = TestGeneratorFactory.getInstance().getGeneratorName(string);
                            IConfigurationElement iConfigurationElement = null;
                            String string3 = RecorderClient.this.theRecorder.getRecordingPath();
                            RecorderControlView.getInstance().addMessage(RecorderPlugin.getResourceString("RecorderClient.Test_generation_started_with_generator___4") + string2);
                            iConfigurationElement = TestGeneratorFactory.getInstance().getGeneratorConfigElement(string);
                            try {
                                TestGenerator testGenerator = (TestGenerator)iConfigurationElement.createExecutableExtension("class");
                                String string4 = null;
                                if (!string3.endsWith(".rec")) {
                                    Object[] objectArray = new String[]{string3, ".rec"};
                                    String string5 = RecorderPlugin.getResourceString("RecorderClient.RECORDING_PATH_NOT_CORRECT_FORMAT_STRING");
                                    RecorderClient.this.sendStatusMessageToControlView(MessageFormat.format(string5, objectArray));
                                    return;
                                }
                                string4 = string3.substring(0, string3.length() - 3);
                                IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(string4 + "recmodel"));
                                if (iFile.exists()) {
                                    RecorderControlView.getInstance().addMessage(RecorderPlugin.getResourceString("RecorderClient.TEST_TO_BE_GENERATED") + RecorderClient.this.theRecorder.getTestPath());
                                    testGenerator.initialize(iFile, RecorderClient.this.theRecorder.getTestPath());
                                    testGenerator.run();
                                    if (testGenerator.isSuccess()) {
                                        RecorderControlView.getInstance().addMessage(RecorderPlugin.getResourceString("RecorderClient.TEST_GENERATION_COMPLETE"));
                                    } else {
                                        RecorderControlView.getInstance().addMessage(RecorderPlugin.getResourceString("RecorderClient.TEST_GENERATION_ERRORS"));
                                    }
                                    break block6;
                                }
                                RecorderControlView.getInstance().addMessage(RecorderPlugin.getResourceString("RecorderClient.UNABLE_TO_GENERATE_NO_TRACE_FILE"));
                            }
                            catch (CoreException coreException) {
                                coreException.printStackTrace();
                            }
                        }
                    }
                });
            }
            RecorderClient.this.updateViewStatus(RecorderPlugin.getResourceString("RecorderClient.STATUS_STOPPED"));
            RecorderClient.this.session.release();
        }

        private void delay(int n) {
            try {
                Thread.sleep(n);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }
}

