/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.datapool.internal.control;

import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.test.ui.datapool.internal.action.CopyAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.CutAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.DeleteColumnAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.DeleteRowAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.DeleteRowGroupAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.EditColumnAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.EditRowAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.EditRowGroupAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.InsertColumnAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.InsertRowAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.InsertRowGroupAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.PasteAction;
import org.eclipse.hyades.test.ui.datapool.internal.control.DatapoolClipboard;
import org.eclipse.hyades.test.ui.datapool.internal.control.DatapoolTable;
import org.eclipse.hyades.test.ui.datapool.internal.interfaces.IDatapoolAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.ui.actions.ActionFactory;

public class DatapoolMenuManager {
    private InsertRowAction insertRowAction = null;
    private DeleteRowAction deleteRowAction = null;
    private EditRowAction editRowAction = null;
    private InsertColumnAction insertColumnAction = null;
    private DeleteColumnAction deleteColumnAction = null;
    private EditColumnAction editColumnAction = null;
    private InsertRowGroupAction insertRowGroupAction = null;
    private DeleteRowGroupAction deleteRowGroupAction = null;
    private EditRowGroupAction editRowGroupAction = null;
    private CutAction cutAction = null;
    private CopyAction copyAction = null;
    private PasteAction pasteAction = null;
    private DatapoolTable table = null;
    private Vector customActions = null;
    private String vendorID = null;
    private boolean showRowGroupActions = true;
    private boolean showColumnActions = true;
    private boolean showRowActions = true;
    private boolean showEditActions = true;

    public DatapoolMenuManager(DatapoolTable table, String vendorID, boolean showEquivalenceClassActions, boolean showVariableActions, boolean showRecordActions) {
        if (table == null) {
            return;
        }
        this.table = table;
        this.customActions = new Vector();
        this.vendorID = vendorID;
        this.showRowGroupActions = showEquivalenceClassActions;
        this.showColumnActions = showVariableActions;
        this.showRowActions = showRecordActions;
        this.makeActions();
    }

    private void makeActions() {
        block5: {
            TableViewer provider = this.table.getViewer();
            this.insertRowAction = new InsertRowAction((ISelectionProvider)provider, this.table);
            this.deleteRowAction = new DeleteRowAction((ISelectionProvider)provider, this.table);
            this.editRowAction = new EditRowAction((ISelectionProvider)provider, this.table);
            this.insertColumnAction = new InsertColumnAction((ISelectionProvider)provider, this.table);
            this.deleteColumnAction = new DeleteColumnAction((ISelectionProvider)provider, this.table);
            this.editColumnAction = new EditColumnAction((ISelectionProvider)provider, this.table);
            this.insertRowGroupAction = new InsertRowGroupAction((ISelectionProvider)provider, this.table);
            this.deleteRowGroupAction = new DeleteRowGroupAction((ISelectionProvider)provider, this.table);
            this.editRowGroupAction = new EditRowGroupAction((ISelectionProvider)provider, this.table);
            this.cutAction = new CutAction((ISelectionProvider)provider, this.table);
            this.copyAction = new CopyAction((ISelectionProvider)provider, this.table);
            this.pasteAction = new PasteAction((ISelectionProvider)provider, this.table);
            this.table.getIDatapoolPart().getActionBars().setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.cutAction);
            this.table.getIDatapoolPart().getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
            this.table.getIDatapoolPart().getActionBars().setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.pasteAction);
            if (this.vendorID == null) {
                return;
            }
            IExtensionPoint extensionPoint = Platform.getPluginRegistry().getExtensionPoint("org.eclipse.hyades.test.ui.datapool.menuExtension");
            if (extensionPoint == null) break block5;
            try {
                IConfigurationElement[] extensionPoints = extensionPoint.getConfigurationElements();
                int i = 0;
                while (i < extensionPoints.length) {
                    String extVendorID = extensionPoints[i].getAttribute("vendorID");
                    if (this.vendorID.equals(extVendorID)) {
                        String displayName = extensionPoints[i].getAttribute("displayName");
                        IDatapoolAction action = (IDatapoolAction)extensionPoints[i].createExecutableExtension("actionClass");
                        this.customActions.add(action);
                        action.setDatapoolTable(this.table);
                    }
                    ++i;
                }
            }
            catch (Exception e) {}
        }
    }

    public void addActions(IMenuManager imenuMgr) {
        MenuManager menuMgr = (MenuManager)imenuMgr;
        if (this.showRowGroupActions) {
            menuMgr.add((IAction)this.insertRowGroupAction);
            menuMgr.add((IAction)this.deleteRowGroupAction);
            menuMgr.add((IAction)this.editRowGroupAction);
        }
        if (this.showRowActions) {
            menuMgr.add((IAction)this.insertRowAction);
            menuMgr.add((IAction)this.deleteRowAction);
            menuMgr.add((IAction)this.editRowAction);
        }
        if (this.showColumnActions) {
            menuMgr.add((IAction)this.insertColumnAction);
            menuMgr.add((IAction)this.deleteColumnAction);
            menuMgr.add((IAction)this.editColumnAction);
        }
        if (this.showEditActions) {
            menuMgr.add((IAction)this.cutAction);
            menuMgr.add((IAction)this.copyAction);
            menuMgr.add((IAction)this.pasteAction);
        }
        int i = 0;
        while (i < this.customActions.size()) {
            IAction action = (IAction)this.customActions.get(i);
            menuMgr.add(action);
            ++i;
        }
    }

    public void setDisplayMode(int mode, boolean isCutCopyPasteable) {
        boolean showPaste = !DatapoolClipboard.getInstance().isEmpty();
        switch (mode) {
            case 0: {
                this.insertRowGroupAction.aboutToShow(true);
                this.deleteRowGroupAction.aboutToShow(true);
                this.editRowGroupAction.aboutToShow(true);
                this.insertRowAction.aboutToShow(true);
                this.deleteRowAction.aboutToShow(true);
                this.editRowAction.aboutToShow(true);
                this.insertColumnAction.aboutToShow(true);
                this.deleteColumnAction.aboutToShow(false);
                this.editColumnAction.aboutToShow(false);
                this.cutAction.aboutToShow(isCutCopyPasteable);
                this.copyAction.aboutToShow(isCutCopyPasteable);
                this.pasteAction.aboutToShow(showPaste && isCutCopyPasteable);
                break;
            }
            case 1: {
                this.insertRowGroupAction.aboutToShow(true);
                this.deleteRowGroupAction.aboutToShow(true);
                this.editRowGroupAction.aboutToShow(true);
                this.insertRowAction.aboutToShow(true);
                this.deleteRowAction.aboutToShow(true);
                this.editRowAction.aboutToShow(true);
                this.insertColumnAction.aboutToShow(true);
                this.deleteColumnAction.aboutToShow(true);
                this.editColumnAction.aboutToShow(true);
                this.cutAction.aboutToShow(isCutCopyPasteable);
                this.copyAction.aboutToShow(isCutCopyPasteable);
                this.pasteAction.aboutToShow(showPaste && isCutCopyPasteable);
                break;
            }
            case 2: 
            case 4: {
                this.insertRowGroupAction.aboutToShow(true);
                this.deleteRowGroupAction.aboutToShow(false);
                this.editRowGroupAction.aboutToShow(false);
                this.insertRowAction.aboutToShow(!this.showRowGroupActions);
                this.deleteRowAction.aboutToShow(false);
                this.editRowAction.aboutToShow(false);
                this.insertColumnAction.aboutToShow(true);
                this.deleteColumnAction.aboutToShow(false);
                this.editColumnAction.aboutToShow(false);
                this.cutAction.aboutToShow(false);
                this.copyAction.aboutToShow(false);
                this.pasteAction.aboutToShow(false);
                break;
            }
            case 3: {
                this.insertRowGroupAction.aboutToShow(true);
                this.deleteRowGroupAction.aboutToShow(false);
                this.editRowGroupAction.aboutToShow(false);
                this.insertRowAction.aboutToShow(!this.showRowGroupActions);
                this.deleteRowAction.aboutToShow(false);
                this.editRowAction.aboutToShow(false);
                this.insertColumnAction.aboutToShow(true);
                this.deleteColumnAction.aboutToShow(true);
                this.editColumnAction.aboutToShow(false);
                this.cutAction.aboutToShow(false);
                this.copyAction.aboutToShow(false);
                this.pasteAction.aboutToShow(false);
                break;
            }
            case 5: {
                this.insertRowGroupAction.aboutToShow(false);
                this.deleteRowGroupAction.aboutToShow(false);
                this.editRowGroupAction.aboutToShow(false);
                this.insertRowAction.aboutToShow(false);
                this.deleteRowAction.aboutToShow(false);
                this.editRowAction.aboutToShow(false);
                this.insertColumnAction.aboutToShow(false);
                this.deleteColumnAction.aboutToShow(false);
                this.editColumnAction.aboutToShow(false);
                this.cutAction.aboutToShow(false);
                this.copyAction.aboutToShow(isCutCopyPasteable);
                this.pasteAction.aboutToShow(false);
                break;
            }
            default: {
                this.insertRowAction.aboutToShow(true);
                this.deleteRowAction.aboutToShow(true);
                this.editRowAction.aboutToShow(true);
                this.insertRowGroupAction.aboutToShow(true);
                this.deleteRowGroupAction.aboutToShow(true);
                this.editRowGroupAction.aboutToShow(true);
                this.insertColumnAction.aboutToShow(true);
                this.deleteColumnAction.aboutToShow(true);
                this.editColumnAction.aboutToShow(true);
                this.cutAction.aboutToShow(isCutCopyPasteable);
                this.copyAction.aboutToShow(isCutCopyPasteable);
                this.pasteAction.aboutToShow(false);
            }
        }
    }
}

