/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.java.internal.junit.wizard;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.test.common.TestCommonImages;
import org.eclipse.hyades.test.common.TestCommonPlugin;
import org.eclipse.hyades.test.common.internal.codegen.Generator;
import org.eclipse.hyades.test.java.TestJavaPlugin;
import org.eclipse.hyades.test.java.internal.codegen.JUnitGenerator;
import org.eclipse.hyades.test.java.internal.junit.wizard.AdjustSourceInfoPage;
import org.eclipse.hyades.test.java.internal.junit.wizard.ProjectAndSourcePage;
import org.eclipse.hyades.test.java.internal.util.TestJavaUtil;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.navigator.ITestSuiteProxyNode;
import org.eclipse.hyades.ui.internal.wizard.HyadesWizard;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

public class GenerateWizard
extends HyadesWizard
implements IRunnableWithProgress {
    public static final String PLUGIN_ID_JUNIT = "org.junit";
    public static final String PLUGIN_ID_EXECUTION_CORE = "org.eclipse.hyades.execution.core";
    public static final String PLUGIN_ID_EXECUTION_REMOTE = "org.eclipse.hyades.execution.remote";
    private ITestSuite testSuite;
    private AdjustSourceInfoPage adjustSourceInfoPage;
    private ProjectAndSourcePage projectAndSourcePage;

    public GenerateWizard() {
        this.setWindowTitle(TestJavaPlugin.getString("GEN_WTITLE"));
        this.setDefaultPageImageDescriptor(TestCommonImages.INSTANCE.getImageDescriptor("generate_wiz.gif"));
        IDialogSettings iDialogSettings = TestJavaPlugin.getInstance().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection("junit.GenerateWizard");
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection("junit.GenerateWizard");
        }
        this.setDialogSettings(iDialogSettings2);
    }

    public ITestSuite getTestSuite() {
        return this.testSuite;
    }

    protected void initPages() {
        ITestSuiteProxyNode iTestSuiteProxyNode;
        Object object;
        IStructuredSelection iStructuredSelection = this.getSelection();
        if (iStructuredSelection.size() == 1) {
            object = iStructuredSelection.getFirstElement();
            if (object instanceof ITestSuite) {
                this.testSuite = (ITestSuite)object;
            } else if (object instanceof ITestSuiteProxyNode) {
                iTestSuiteProxyNode = (ITestSuiteProxyNode)object;
                this.testSuite = iTestSuiteProxyNode.getTestSuite();
            }
        }
        object = this.getTestSuite().getImplementor();
        iTestSuiteProxyNode = TestJavaUtil.getJavaProjects();
        this.projectAndSourcePage = new ProjectAndSourcePage((IImplementor)object, (IJavaProject[])iTestSuiteProxyNode);
        boolean bl = false;
        String string = null;
        String string2 = null;
        if (((ITestSuiteProxyNode)iTestSuiteProxyNode).length > 0) {
            if (object.getResource() != null) {
                String string3 = object.getResource();
                int n = string3.lastIndexOf(46);
                if (n > 0) {
                    string = string3.substring(0, n);
                    bl = JavaConventions.validatePackageName((String)string).isOK();
                }
                if (n < string3.length() - 1) {
                    string2 = string3.substring(n + 1);
                    bl = bl && JavaConventions.validateIdentifier((String)string2).isOK();
                }
                boolean bl2 = bl = bl && string != null && string2 != null;
            }
            if (!bl) {
                this.adjustSourceInfoPage = new AdjustSourceInfoPage((IImplementor)object);
            }
        }
    }

    public void addPages() {
        if (this.projectAndSourcePage.getJavaProjects().length > 0 && this.adjustSourceInfoPage != null) {
            this.addPage((IWizardPage)this.adjustSourceInfoPage);
        }
        this.addPage((IWizardPage)this.projectAndSourcePage);
    }

    public void run(IProgressMonitor iProgressMonitor) throws InterruptedException, InvocationTargetException {
        this.getDialogSettings().put("PROJECT_NAME", this.getJavaProject().getElementName());
        this.getDialogSettings().put("SOURCE_FOLDER_NAME", this.getSourceFolder());
        if (this.getTestSuite() != null) {
            MessageDialog messageDialog;
            String string;
            Resource resource = ((EObject)this.getTestSuite()).eResource();
            boolean bl = resource.isTrackingModification();
            resource.setTrackingModification(true);
            IProject iProject = this.getJavaProject().getProject();
            if (this.getSourceFolder() != null && this.getSourceFolder().length() > 0) {
                iProject = iProject.getFolder((IPath)new Path(this.getSourceFolder()));
            }
            if (!(string = iProject.getFullPath().toString()).equals(this.getTestSuite().getImplementor().getLocation())) {
                this.getTestSuite().getImplementor().setLocation(string);
            } else {
                resource.setModified(this.adjustSourceInfoPage != null);
            }
            Generator generator = this.createGenerator();
            if (generator.getFileHandle(this.getTestSuite()).exists() && (messageDialog = new MessageDialog(this.getShell(), TestJavaPlugin.getString("W_QUESTION"), null, TestJavaPlugin.getString("Q_OVR_FILE"), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1)).open() != 0) {
                iProgressMonitor.setCanceled(true);
                throw new InterruptedException();
            }
            this.addRequiredLibraries(generator);
            try {
                generator.generate(this.getTestSuite(), iProgressMonitor);
            }
            catch (Exception exception) {
                TestJavaPlugin.logError(exception);
                throw new InvocationTargetException(exception);
            }
            if (resource.isModified()) {
                try {
                    EMFUtil.save((Resource)resource);
                }
                catch (Exception exception) {
                    TestJavaPlugin.logError(exception);
                }
            }
            resource.setTrackingModification(bl);
        }
    }

    public boolean performFinish() {
        WorkspaceModifyDelegatingOperation workspaceModifyDelegatingOperation = new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)this);
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)workspaceModifyDelegatingOperation);
        }
        catch (InvocationTargetException invocationTargetException) {
            MessageDialog.openError((Shell)this.getShell(), (String)TestJavaPlugin.getString("W_ERROR"), (String)invocationTargetException.getTargetException().getMessage());
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    public IJavaProject getJavaProject() {
        return this.projectAndSourcePage.getJavaProject();
    }

    public String getSourceFolder() {
        return this.projectAndSourcePage.getSourceFolder();
    }

    protected Generator createGenerator() {
        return new JUnitGenerator();
    }

    protected void addRequiredLibraries(Generator generator) {
        JUnitGenerator jUnitGenerator = (JUnitGenerator)generator;
        jUnitGenerator.addAllLibraries(PLUGIN_ID_JUNIT);
        jUnitGenerator.addRequiredLibrary(TestCommonPlugin.getID(), "common.runner.jar");
        jUnitGenerator.addRequiredLibrary(TestJavaPlugin.getID(), "java.runner.jar");
    }
}

