/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.java.internal.junit.wizard;

import java.util.List;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.test.java.TestJavaPlugin;
import org.eclipse.hyades.test.java.internal.util.TestJavaUtil;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;

public class ProjectAndSourcePage
extends WizardPage
implements ModifyListener,
SelectionListener {
    protected static final String SET_PROJECT = "PROJECT_NAME";
    protected static final String SET_SOURCE = "SOURCE_FOLDER_NAME";
    private IImplementor implementor;
    private IJavaProject[] javaProjects;
    private Text javaProjectText;
    private Button selectJavaProjectButton;
    private Text sourceFolderText;
    private Button selectSourceFolderButton;

    public ProjectAndSourcePage(IImplementor iImplementor, IJavaProject[] iJavaProjectArray) {
        super("ProjectAndSourcePage");
        this.setTitle(TestJavaPlugin.getString("GEN_WTITLE"));
        this.setDescription(TestJavaPlugin.getString("GEN_LDESC"));
        this.implementor = iImplementor;
        this.javaProjects = iJavaProjectArray;
    }

    public void dispose() {
        this.implementor = null;
        super.dispose();
    }

    public IJavaProject[] getJavaProjects() {
        return this.javaProjects;
    }

    public void createControl(Composite composite) {
        WorkbenchHelp.setHelp((Control)composite, (String)(TestJavaPlugin.getID() + ".itdg0001"));
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        composite2.setLayoutData((Object)GridDataUtil.createFill());
        Label label = new Label(composite2, 0);
        label.setText(TestJavaPlugin.getString("STR_WB_PROJECT"));
        this.javaProjectText = new Text(composite2, 2052);
        this.javaProjectText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.selectJavaProjectButton = new Button(composite2, 8);
        GridData gridData = new GridData(128);
        gridData.horizontalSpan = 2;
        this.selectJavaProjectButton.setLayoutData((Object)gridData);
        this.selectJavaProjectButton.setText(TestJavaPlugin.getString("STR_WB_BROWSE_BTN"));
        this.selectJavaProjectButton.addSelectionListener((SelectionListener)this);
        this.selectJavaProjectButton.setEnabled(this.javaProjects.length > 0);
        label = new Label(composite2, 0);
        label.setText(TestJavaPlugin.getString("STR_WB_SRC_FOLDER"));
        this.sourceFolderText = new Text(composite2, 2052);
        this.sourceFolderText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        this.sourceFolderText.setEditable(false);
        this.selectSourceFolderButton = new Button(composite2, 8);
        gridData = new GridData(128);
        gridData.horizontalSpan = 2;
        this.selectSourceFolderButton.setLayoutData((Object)gridData);
        this.selectSourceFolderButton.setText(TestJavaPlugin.getString("STR_WB_SOURCE_BTN"));
        this.selectSourceFolderButton.addSelectionListener((SelectionListener)this);
        if (this.selectJavaProjectButton.isEnabled()) {
            Object object;
            if (this.implementor.getLocation() != null && (object = ResourcesPlugin.getWorkspace().getRoot().findMember(this.implementor.getLocation())) != null && object.exists()) {
                if (object.getType() == 4) {
                    this.javaProjectText.setText(object.getName());
                } else if (object.getType() == 2) {
                    this.javaProjectText.setText(object.getProject().getName());
                    this.sourceFolderText.setText(object.getFullPath().removeFirstSegments(1).toString());
                }
            }
            if (this.javaProjectText.getText().length() == 0) {
                object = this.getDialogSettings().get(SET_PROJECT);
                if (object != null && this.getJavaProject((String)object) != null) {
                    this.javaProjectText.setText((String)object);
                }
                if ((object = this.getDialogSettings().get(SET_SOURCE)) != null) {
                    this.sourceFolderText.setText((String)object);
                }
            }
            this.setPageComplete(this.validatePage());
            this.setErrorMessage(null);
            this.javaProjectText.addModifyListener((ModifyListener)this);
            this.sourceFolderText.addModifyListener((ModifyListener)this);
            this.javaProjectText.setFocus();
        } else {
            this.setPageComplete(false);
            this.selectSourceFolderButton.setEnabled(false);
            this.javaProjectText.setEditable(false);
            this.setErrorMessage(TestJavaPlugin.getString("NO_JAVA_PRJ"));
            composite2.setFocus();
        }
        this.setControl((Control)composite2);
    }

    public void modifyText(ModifyEvent modifyEvent) {
        this.setPageComplete(this.validatePage());
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.selectJavaProjectButton) {
            IJavaProject iJavaProject = this.chooseJavaProject();
            if (iJavaProject != null) {
                this.javaProjectText.setText(iJavaProject.getElementName());
            }
        } else if (selectionEvent.widget == this.selectSourceFolderButton) {
            Object object = this.chooseSourceFolder();
            if (object instanceof IJavaProject) {
                this.javaProjectText.setText(((IJavaProject)object).getElementName());
            } else if (object instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)object;
                this.javaProjectText.removeModifyListener((ModifyListener)this);
                this.javaProjectText.setText(iPackageFragmentRoot.getJavaProject().getElementName());
                this.javaProjectText.addModifyListener((ModifyListener)this);
                this.sourceFolderText.setText(iPackageFragmentRoot.getPath().removeFirstSegments(1).toString());
            }
        }
    }

    protected boolean validatePage() {
        String string = this.javaProjectText.getText();
        if (string.trim().length() == 0) {
            this.setErrorMessage(TestJavaPlugin.getString("_ERROR_WIZ_EMPTY_PROJECT"));
            return false;
        }
        IJavaProject iJavaProject = this.getJavaProject(string);
        if (iJavaProject == null) {
            this.setErrorMessage(TestJavaPlugin.getString("_ERROR_WIZ_NOT_EXIST_PROJECT"));
            return false;
        }
        List list = TestJavaUtil.getSourceFolders(iJavaProject);
        if (list.isEmpty()) {
            this.sourceFolderText.removeModifyListener((ModifyListener)this);
            this.sourceFolderText.setEditable(false);
            this.sourceFolderText.addModifyListener((ModifyListener)this);
        } else {
            this.sourceFolderText.setEditable(true);
            string = this.sourceFolderText.getText();
            if (string.trim().length() == 0) {
                this.setErrorMessage(TestJavaPlugin.getString("_ERROR_WIZ_EMPTY_FOLDER"));
                return false;
            }
            if (!this.isValidFolderName()) {
                this.setErrorMessage(TestJavaPlugin.getString("_ERROR_INV_FLD_NME"));
                return false;
            }
        }
        this.setErrorMessage(null);
        return true;
    }

    protected boolean isValidFolderName() {
        String string = this.getSourceFolder();
        if (string.startsWith("/")) {
            return false;
        }
        return !string.endsWith("/");
    }

    public String getSourceFolder() {
        if (this.sourceFolderText.getEditable()) {
            return this.sourceFolderText.getText().trim().replace('\\', '/');
        }
        return "";
    }

    protected IJavaProject getJavaProject() {
        return this.getJavaProject(this.javaProjectText.getText());
    }

    protected IJavaProject getJavaProject(String string) {
        IJavaProject iJavaProject;
        if (string != null && string.trim().length() > 0 && (iJavaProject = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProject(string)).exists()) {
            return iJavaProject;
        }
        return null;
    }

    protected IJavaProject chooseJavaProject() {
        JavaElementLabelProvider javaElementLabelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)javaElementLabelProvider);
        elementListSelectionDialog.setTitle(TestJavaPlugin.getString("TITLE_PROJECT_SELECT"));
        elementListSelectionDialog.setMessage(TestJavaPlugin.getString("STR_PROJECT_SELECT"));
        elementListSelectionDialog.setElements((Object[])this.javaProjects);
        IJavaProject iJavaProject = this.getJavaProject(this.javaProjectText.getText());
        if (iJavaProject != null) {
            elementListSelectionDialog.setInitialSelections(new Object[]{iJavaProject});
        }
        if (elementListSelectionDialog.open() == 0) {
            return (IJavaProject)elementListSelectionDialog.getFirstResult();
        }
        return null;
    }

    protected Object chooseSourceFolder() {
        ElementTreeSelectionDialog elementTreeSelectionDialog = TestJavaUtil.createSourceFolderDialog(this.getShell(), null);
        elementTreeSelectionDialog.setTitle(TestJavaPlugin.getString("TITLE_SRC_SELECT"));
        elementTreeSelectionDialog.setMessage(TestJavaPlugin.getString("STR_SRC_SELECT"));
        IJavaProject iJavaProject = this.getJavaProject(this.javaProjectText.getText());
        if (iJavaProject != null) {
            elementTreeSelectionDialog.setInitialSelections(new Object[]{iJavaProject});
        }
        if (elementTreeSelectionDialog.open() == 0) {
            return elementTreeSelectionDialog.getFirstResult();
        }
        return null;
    }
}

