/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.sample.svg.generator;

import org.eclipse.hyades.ui.sample.svg.generator.SegmentMarker;

public class DataRange {
    public static final int UNKNOWN = 0;
    public static final int BOTTOM = 1;
    public static final int LEFT = 2;
    public static final int TOP = 3;
    public static final int RIGHT = 4;
    public static final int CONTINUUM = 0;
    public static final int CATEGORIZATION = 1;
    private String id = null;
    private String label = null;
    private double minValue = 0.0;
    private double maxValue = 0.0;
    private int location = 0;
    private int type = 0;
    private SegmentMarker[] segmentMarkers = null;

    public DataRange(String locationString) {
        if (locationString != null) {
            int location = 0;
            if (locationString.equals("S")) {
                location = 1;
            } else if (locationString.equals("W")) {
                location = 2;
            } else if (locationString.equals("N")) {
                location = 3;
            } else if (locationString.equals("E")) {
                location = 4;
            }
            this.setLocation(location);
        }
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getLocation() {
        return this.location;
    }

    public void setLocation(int location) {
        this.location = location;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public SegmentMarker[] getSegmentMarkers() {
        return this.segmentMarkers;
    }

    public void setSegmentMarkers(SegmentMarker[] segmentMarkers) {
        this.segmentMarkers = segmentMarkers;
        if (segmentMarkers.length <= 0) {
            return;
        }
        this.maxValue = this.minValue = segmentMarkers[0].getValue();
        int i = 1;
        while (i < segmentMarkers.length) {
            double d = segmentMarkers[i].getValue();
            if (d < this.minValue) {
                this.minValue = d;
            }
            if (d > this.maxValue) {
                this.maxValue = d;
            }
            ++i;
        }
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public SegmentMarker findSegmentMarker(double value) {
        int i = 0;
        while (i < this.segmentMarkers.length) {
            if (this.segmentMarkers[i].getValue() == value) {
                return this.segmentMarkers[i];
            }
            ++i;
        }
        return null;
    }
}

