/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.editor.form;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.editor.extension.BaseEditorExtension;
import org.eclipse.hyades.test.ui.editor.extension.TestSuiteEditorExtension;
import org.eclipse.hyades.test.ui.editor.form.TestContextOverviewContribution;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.NamedElementSection;
import org.eclipse.hyades.test.ui.editor.form.util.TestObjectiveSection;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormSection;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.ui.editor.IEditorExtension;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class TestContextOverview
extends EditorForm {
    protected TestContextOverviewContribution tsoContributor;
    private TestSuiteEditorExtension editor;
    private NamedElementSection genericInfoSection;
    private TestObjectiveSection testObjectiveSection;
    private Object[] leftSections;
    private Object[] rightSections;
    private boolean hideGenericInformation = false;
    private boolean hideTestObjective = false;

    public TestContextOverview(BaseEditorExtension baseEditorExtension, WidgetFactory widgetFactory) {
        super(baseEditorExtension, widgetFactory);
        this.editor = (TestSuiteEditorExtension)baseEditorExtension;
        this.setHeadingText(TestUIPlugin.getString("W_OVERVIEW"));
    }

    public TestContextOverview(BaseEditorExtension baseEditorExtension, WidgetFactory widgetFactory, TestContextOverviewContribution testContextOverviewContributor) {
        super(baseEditorExtension, widgetFactory);
        this.editor = (TestSuiteEditorExtension)baseEditorExtension;
        this.tsoContributor = testContextOverviewContributor;
        this.tsoContributor.setOverviewForm(this);
        this.setHeadingText(TestUIPlugin.getString("W_OVERVIEW"));
    }

    public void dispose() {
        int i = 0;
        while (this.leftSections != null && i < this.leftSections.length) {
            if (this.leftSections[i] != null && this.leftSections[i] instanceof IDisposable) {
                ((IDisposable)this.leftSections[i]).dispose();
                this.leftSections[i] = null;
            }
            ++i;
        }
        int i2 = 0;
        while (this.rightSections != null && i2 < this.rightSections.length) {
            if (this.rightSections[i2] != null && this.rightSections[i2] instanceof IDisposable) {
                ((IDisposable)this.rightSections[i2]).dispose();
                this.rightSections[i2] = null;
            }
            ++i2;
        }
        if (this.genericInfoSection != null && this.genericInfoSection instanceof IDisposable) {
            this.genericInfoSection.dispose();
            this.genericInfoSection = null;
        }
        if (this.testObjectiveSection != null && this.testObjectiveSection instanceof IDisposable) {
            this.testObjectiveSection.dispose();
            this.testObjectiveSection = null;
        }
        super.dispose();
    }

    protected TPFTestSuite getTestContext() {
        return this.editor.getTestSuite();
    }

    public Control createControl() {
        Control control = super.createControl();
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)(TestUIPlugin.getID() + ".tstf0001"));
        return control;
    }

    protected void createEditorFormContents(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginWidth = 10;
        gridLayout.horizontalSpacing = 15;
        parent.setLayout((Layout)gridLayout);
        Composite leftColumn = this.createColumn(parent);
        Composite rightColumn = this.createColumn(parent);
        if (this.tsoContributor == null || this.tsoContributor != null && this.tsoContributor.hideGenericInformation()) {
            this.hideGenericInformation = true;
        } else {
            Control control = this.createGenericInformation(leftColumn);
            control.setLayoutData((Object)new GridData(770));
            WorkbenchHelp.setHelp((Control)control, (String)(TestUIPlugin.getID() + ".tstf0004"));
        }
        if (this.tsoContributor == null || this.tsoContributor != null && this.tsoContributor.hideTestObjectiveSection()) {
            this.hideTestObjective = true;
        } else {
            this.createTestObjectiveSection(leftColumn);
        }
        if (this.tsoContributor != null) {
            this.leftSections = this.tsoContributor.createLeftSections((IEditorExtension)this.editor);
            this.rightSections = this.tsoContributor.createRightSections((IEditorExtension)this.editor);
            int i = 0;
            while (i < this.leftSections.length) {
                if (this.leftSections[i] instanceof FormSection) {
                    this.registerSection((FormSection)((Object)this.leftSections[i]));
                    Control control = ((FormSection)((Object)this.leftSections[i])).createControl(leftColumn, this.factory);
                    control.setLayoutData((Object)new GridData(770));
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < this.rightSections.length) {
                if (this.rightSections[i2] instanceof FormSection) {
                    this.registerSection((FormSection)((Object)this.rightSections[i2]));
                    Control control = ((FormSection)((Object)this.rightSections[i2])).createControl(rightColumn, this.factory);
                    control.setLayoutData((Object)new GridData(770));
                }
                ++i2;
            }
        }
    }

    protected Control createTestObjectiveSection(Composite arg) {
        Control retControl = null;
        this.testObjectiveSection = new TestObjectiveSection(this.getBaseEditorExtension(), this.getWidgetFactory());
        this.testObjectiveSection.setCollapsable(true);
        this.testObjectiveSection.setHeaderText(TestUIPlugin.getString("L_TEST_OBJECTIVE"));
        this.testObjectiveSection.setDescription(TestUIPlugin.getString("L_TEST_OBJECTIVE_DSC"));
        retControl = this.testObjectiveSection.createControl(arg, this.getWidgetFactory());
        return retControl;
    }

    protected Control createGenericInformation(Composite arg) {
        this.genericInfoSection = new NamedElementSection(this){
            private StyledText typeText;
            private StyledText fileText;

            protected void addCenterControls(Composite parent, FormWidgetFactory formWidgetFactory) {
                if (TestContextOverview.this.tsoContributor != null) {
                    TestContextOverview.this.tsoContributor.addCenterGenericInformation(parent, TestContextOverview.this.getWidgetFactory());
                }
            }

            protected void addSouthControls(Composite parent, FormWidgetFactory formWidgetFactory) {
                Composite detailComposite = TestContextOverview.this.getWidgetFactory().createComposite(parent);
                GridLayout gridLayout = new GridLayout(2, false);
                gridLayout.marginHeight = 0;
                gridLayout.marginWidth = 0;
                detailComposite.setLayout((Layout)gridLayout);
                detailComposite.setLayoutData((Object)GridDataUtil.createHorizontalFill());
                WidgetFactory detailWidgetFactory = TestContextOverview.this.getWidgetFactory();
                detailWidgetFactory.createLabel(detailComposite, TestUIPlugin.getString("L_TYPE"));
                this.typeText = detailWidgetFactory.createStyledText(detailComposite, 65540);
                this.typeText.setEnabled(false);
                this.typeText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
                detailWidgetFactory.createLabel(detailComposite, TestUIPlugin.getString("L_FILE"));
                this.fileText = detailWidgetFactory.createStyledText(detailComposite, 65540);
                this.fileText.setEnabled(false);
                this.fileText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
                WorkbenchHelp.setHelp((Control)this.typeText, (String)(TestUIPlugin.getID() + ".tstf0003"));
                WorkbenchHelp.setHelp((Control)this.fileText, (String)(TestUIPlugin.getID() + ".tstf0002"));
                if (TestContextOverview.this.tsoContributor != null) {
                    TestContextOverview.this.tsoContributor.addSouthGenericInformation(detailComposite, TestContextOverview.this.getWidgetFactory());
                }
            }

            public void setInput(Object object) {
                IFile file;
                String value;
                String name;
                super.setInput(object);
                if (this.getNameTextField() != null && (name = this.getNameTextField().getText()) != null && !name.equals("")) {
                    TestContextOverview.this.getBaseEditorExtension().getHyadesEditorPart().setTitle(name);
                }
                if ((value = TestContextOverview.this.getTestContext().getType()) != null) {
                    IAssociationDescriptor descriptor = TestUIExtension.getTestSuiteMappingRegistry().getAssociationMapping("typeDescriptions").getDefaultAssociationDescriptor(value);
                    if (descriptor != null && descriptor.getName() != null) {
                        value = descriptor.getName();
                    }
                    this.typeText.setText(value);
                }
                if ((file = EMFUtil.getWorkspaceFile((EObject)TestContextOverview.this.getTestContext())) != null) {
                    this.fileText.setText(file.getFullPath().toString());
                }
            }
        };
        this.registerSection(this.genericInfoSection);
        this.genericInfoSection.setHeaderText(TestUIPlugin.getString("EDT_GENERAL_INFO"));
        this.genericInfoSection.setDescription(TestUIPlugin.getString("EDT_GENERAL_DSC"));
        Control retControl = this.genericInfoSection.createControl(arg, this.getWidgetFactory());
        return retControl;
    }

    public void load() {
        if (!this.hideGenericInformation) {
            this.genericInfoSection.setInput(this.getTestContext());
        }
        if (!this.hideTestObjective) {
            this.testObjectiveSection.setInput(this.getTestContext());
        }
        if (this.tsoContributor != null) {
            this.tsoContributor.setTestContext(this.getTestContext());
            if (!this.hideGenericInformation) {
                this.tsoContributor.initializeSouthGenericInformation();
                this.tsoContributor.initializeCenterGenericInformation();
            }
            this.tsoContributor.initializeLeftSections(this.leftSections);
            this.tsoContributor.initializeRightSections(this.rightSections);
        }
    }

    public boolean activated() {
        return true;
    }

    public ISelection getSelection() {
        return new StructuredSelection((Object)this.getTestContext());
    }
}

