/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.editor.form.util;

import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.SelectableFormLabel;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.events.ArmEvent;
import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class WidgetFactory
extends FormWidgetFactory
implements IDisposable {
    private VisibilityHandler visibilityHandler = new VisibilityHandler();
    private BorderPainter borderPainter = new BorderPainter();

    public WidgetFactory() {
        this(Display.getCurrent());
    }

    public WidgetFactory(Display display) {
        super(display);
    }

    public void dispose() {
        this.visibilityHandler = null;
        this.borderPainter = null;
        super.dispose();
    }

    protected VisibilityHandler getVisibilityHandler() {
        return this.visibilityHandler;
    }

    protected BorderPainter getBorderPainter() {
        return this.borderPainter;
    }

    public StyledText createStyledText(Composite parent, int style) {
        try {
            StyledText styledText = new StyledText(parent, style);
            styledText.setBackground(this.getBackgroundColor());
            styledText.setForeground(this.getForegroundColor());
            styledText.addFocusListener((FocusListener)this.getVisibilityHandler());
            this.addEditPopupMenu(styledText);
            return styledText;
        }
        catch (Throwable t) {
            TestUIPlugin.logError(t);
            return null;
        }
    }

    public Menu addEditPopupMenu(StyledText text) {
        try {
            Menu menu = new Menu((Control)text);
            text.setMenu(menu);
            MenuItem cutItem = new MenuItem(menu, 0);
            cutItem.setText(TestUIPlugin.getString("command.Cut"));
            cutItem.setData((Object)text);
            cutItem.setEnabled(text.isEnabled() && text.getEditable());
            cutItem.addArmListener(new ArmListener(){

                public void widgetArmed(ArmEvent e) {
                    MenuItem menuItem;
                    Object obj;
                    if (e.widget != null && e.widget instanceof MenuItem && (obj = (menuItem = (MenuItem)e.widget).getData()) != null && obj instanceof StyledText) {
                        menuItem.setEnabled(((StyledText)obj).isEnabled() && ((StyledText)obj).getEditable());
                    }
                }
            });
            cutItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    MenuItem menuItem;
                    Object obj;
                    if (e.widget != null && e.widget instanceof MenuItem && (obj = (menuItem = (MenuItem)e.widget).getData()) != null && obj instanceof StyledText) {
                        ((StyledText)obj).cut();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            MenuItem copyItem = new MenuItem(menu, 0);
            copyItem.setText(TestUIPlugin.getString("command.Copy"));
            copyItem.setData((Object)text);
            copyItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    MenuItem menuItem;
                    Object obj;
                    if (e.widget != null && e.widget instanceof MenuItem && (obj = (menuItem = (MenuItem)e.widget).getData()) != null && obj instanceof StyledText) {
                        ((StyledText)obj).copy();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            MenuItem pasteItem = new MenuItem(menu, 0);
            pasteItem.setText(TestUIPlugin.getString("command.Paste"));
            pasteItem.setData((Object)text);
            pasteItem.setEnabled(text.isEnabled() && text.getEditable());
            pasteItem.addArmListener(new ArmListener(){

                public void widgetArmed(ArmEvent e) {
                    MenuItem menuItem;
                    Object obj;
                    if (e.widget != null && e.widget instanceof MenuItem && (obj = (menuItem = (MenuItem)e.widget).getData()) != null && obj instanceof StyledText) {
                        menuItem.setEnabled(((StyledText)obj).isEnabled() && ((StyledText)obj).getEditable());
                    }
                }
            });
            pasteItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    MenuItem menuItem;
                    Object obj;
                    if (e.widget != null && e.widget instanceof MenuItem && (obj = (menuItem = (MenuItem)e.widget).getData()) != null && obj instanceof StyledText) {
                        ((StyledText)obj).paste();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            return menu;
        }
        catch (Throwable t) {
            TestUIPlugin.logError(t);
            return null;
        }
    }

    public CCombo createCCombo(Composite parent, int style) {
        try {
            CCombo combo = new CCombo(parent, style);
            combo.setBackground(this.getBackgroundColor());
            combo.setForeground(this.getForegroundColor());
            combo.addFocusListener((FocusListener)this.getVisibilityHandler());
            return combo;
        }
        catch (Throwable t) {
            TestUIPlugin.logError(t);
            return null;
        }
    }

    public void paintBordersFor(Composite composite) {
        composite.addPaintListener((PaintListener)this.getBorderPainter());
    }

    protected static class VisibilityHandler
    extends FocusAdapter {
        protected VisibilityHandler() {
        }

        public void focusGained(FocusEvent e) {
            Widget w = e.widget;
            if (w instanceof Control) {
                FormWidgetFactory.ensureVisible((Control)w);
            }
        }
    }

    protected class BorderPainter
    implements PaintListener {
        protected BorderPainter() {
        }

        public void paintControl(PaintEvent event) {
            Composite composite = (Composite)event.widget;
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                block12: {
                    GC gc;
                    Rectangle b;
                    boolean inactiveBorder;
                    Control c;
                    block13: {
                        c = children[i];
                        inactiveBorder = false;
                        if (!c.getEnabled() && !(c instanceof CCombo) || c instanceof SelectableFormLabel) break block12;
                        Object flag = c.getData("FormWidgetFactory.drawBorder");
                        if (flag == null) break block13;
                        if (flag.equals(Boolean.FALSE)) break block12;
                        if (flag.equals("treeBorder")) {
                            inactiveBorder = true;
                        }
                    }
                    if (!inactiveBorder && (c instanceof Text || c instanceof Canvas || c instanceof CCombo)) {
                        b = c.getBounds();
                        gc = event.gc;
                        gc.setForeground(c.getBackground());
                        gc.drawRectangle(b.x - 1, b.y - 1, b.width + 1, b.height + 1);
                        gc.setForeground(WidgetFactory.this.getForegroundColor());
                        if (c instanceof CCombo) {
                            gc.drawRectangle(b.x - 1, b.y - 1, b.width + 1, b.height + 1);
                        } else if (c instanceof StyledText) {
                            gc.drawRectangle(b.x - 2, b.y - 2, b.width + 2, b.height + 3);
                        } else {
                            gc.drawRectangle(b.x - 1, b.y - 2, b.width + 1, b.height + 3);
                        }
                    } else if (inactiveBorder || c instanceof Table || c instanceof Tree || c instanceof TableTree) {
                        b = c.getBounds();
                        gc = event.gc;
                        gc.setForeground(WidgetFactory.this.getBorderColor());
                        gc.drawRectangle(b.x - 1, b.y - 1, b.width + 2, b.height + 2);
                    }
                }
                ++i;
            }
        }
    }
}

